## Bounties

We use bounties to incentivize development and reward contributors. All issues available for a bounty are listed [here](https://github.com/haveno-dex/haveno/issues?q=is%3Aissue%20state%3Aopen%20label%3A%F0%9F%92%B0bounty). It's possible to list on each repository the issues with a bounty on them, by searching issues with the '💰bounty' label.

To receive a bounty, you agree to these conditions:

- Your changes must follow the [styling guidelines](CONTRIBUTING.md).
- Bounties will be set and awarded in XMR at discretion of the Haveno core team.
- The issues eligible for a bounty are labelled '💰bounty' and have the amount of the bounty specified in the title in this form: `[$200]` if in dollars or `[1 XMR]` if in Monero.
- An issue is considered resolved when the patch(es) proposed by the contributor is/are merged in the appropriate repository according to terms of the issue. Pull requests to monero-project must be merged into the release branch to be considered final.
- The first person who resolves an issue in its entirety will receive the entire amount of the bounty.
- If the issue is resolved collaboratively by more than one person, the reward will be distributed among the contributors at discretion of the Haveno core team.
- Let the Maintainers know if you intend to work on a bounty, so that the issue can be assigned to you. Being assigned to an issue doesn't make that issue resolvable only by the assignee. It's meant to avoid duplication of efforts and not to discourage collective works.
- After the issue is resolved, contact the maintainers and claim your bounty (remember to provide them with a Monero address).
- If a big number of bounties is claimed at the same time, the maintainers might opt for sending all the rewards on a specific day of the month instead of right after resolution.
- If the bounty is in dollars, the contributor will receive the amount in Monero according to the value of XMR at the moment the issue was practically resolved, so in the moment the maintainers accept the last patch resolving the issue.

We want to keep the system simple and flexible, but we will add new rules or edit existing ones if necessary.
