/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j.spring.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.ExceptionResolver;
import com.googlecode.jsonrpc4j.JsonRpcClient;
import com.googlecode.jsonrpc4j.ReflectionUtil;
import com.googlecode.jsonrpc4j.spring.rest.JsonRpcRestClient;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;
import org.springframework.web.client.RestTemplate;

class JsonRestProxyFactoryBean<T>
extends UrlBasedRemoteAccessor
implements MethodInterceptor,
InitializingBean,
FactoryBean<T>,
ApplicationContextAware {
    private T proxyObject = null;
    private JsonRpcClient.RequestListener requestListener = null;
    private ObjectMapper objectMapper = null;
    private RestTemplate restTemplate = null;
    private JsonRpcRestClient jsonRpcRestClient = null;
    private Map<String, String> extraHttpHeaders = new HashMap<String, String>();
    private SSLContext sslContext = null;
    private HostnameVerifier hostNameVerifier = null;
    private ExceptionResolver exceptionResolver;
    private ApplicationContext applicationContext;

    JsonRestProxyFactoryBean() {
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.proxyObject = ProxyFactory.getProxy(this.getObjectType(), (Interceptor)this);
        if (this.jsonRpcRestClient == null) {
            if (this.objectMapper == null && this.applicationContext != null && this.applicationContext.containsBean("objectMapper")) {
                this.objectMapper = (ObjectMapper)this.applicationContext.getBean("objectMapper");
            }
            if (this.objectMapper == null && this.applicationContext != null) {
                try {
                    this.objectMapper = (ObjectMapper)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ObjectMapper.class);
                }
                catch (Exception e) {
                    this.logger.debug((Object)e);
                }
            }
            if (this.objectMapper == null) {
                this.objectMapper = new ObjectMapper();
            }
            try {
                this.jsonRpcRestClient = new JsonRpcRestClient(new URL(this.getServiceUrl()), this.objectMapper, this.restTemplate, new HashMap<String, String>());
                this.jsonRpcRestClient.setRequestListener(this.requestListener);
                this.jsonRpcRestClient.setSslContext(this.sslContext);
                this.jsonRpcRestClient.setHostNameVerifier(this.hostNameVerifier);
                if (this.exceptionResolver != null) {
                    this.jsonRpcRestClient.setExceptionResolver(this.exceptionResolver);
                }
            }
            catch (MalformedURLException mue) {
                throw new RuntimeException(mue);
            }
        }
        ReflectionUtil.clearCache();
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (method.getDeclaringClass() == Object.class && method.getName().equals("toString")) {
            return this.proxyObject.getClass().getName() + "@" + System.identityHashCode(this.proxyObject);
        }
        Class<?> retType = invocation.getMethod().getGenericReturnType() != null ? invocation.getMethod().getGenericReturnType() : invocation.getMethod().getReturnType();
        Object arguments = ReflectionUtil.parseArguments(invocation.getMethod(), invocation.getArguments());
        return this.jsonRpcRestClient.invoke(invocation.getMethod().getName(), arguments, (Type)retType, this.extraHttpHeaders);
    }

    public T getObject() {
        return this.proxyObject;
    }

    public Class<T> getObjectType() {
        return this.getServiceInterface();
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setExtraHttpHeaders(Map<String, String> extraHttpHeaders) {
        this.extraHttpHeaders = extraHttpHeaders;
    }

    public void setRequestListener(JsonRpcClient.RequestListener requestListener) {
        this.requestListener = requestListener;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setHostNameVerifier(HostnameVerifier hostNameVerifier) {
        this.hostNameVerifier = hostNameVerifier;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setJsonRpcRestClient(JsonRpcRestClient jsonRpcRestClient) {
        this.jsonRpcRestClient = jsonRpcRestClient;
    }

    public void setExceptionResolver(ExceptionResolver exceptionResolver) {
        this.exceptionResolver = exceptionResolver;
    }
}

