/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.ConvertedParameterTransformer;
import com.googlecode.jsonrpc4j.ErrorResolver;
import com.googlecode.jsonrpc4j.HttpStatusCodeProvider;
import com.googlecode.jsonrpc4j.InvocationListener;
import com.googlecode.jsonrpc4j.JsonRpcInterceptor;
import com.googlecode.jsonrpc4j.JsonRpcService;
import com.googlecode.jsonrpc4j.spring.AutoJsonRpcServiceImpl;
import com.googlecode.jsonrpc4j.spring.JsonServiceExporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.util.ClassUtils;

public class AutoJsonRpcServiceImplExporter
implements BeanFactoryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AutoJsonRpcServiceImplExporter.class);
    private static final String PATH_PREFIX = "/";
    private static final Pattern PATTERN_JSONRPC_PATH = Pattern.compile("^/?[A-Za-z0-9._~-]+(/[A-Za-z0-9._~-]+)*$");
    private ObjectMapper objectMapper;
    private ErrorResolver errorResolver = null;
    private Boolean registerTraceInterceptor;
    private boolean backwardsCompatible = true;
    private boolean rethrowExceptions = false;
    private boolean allowExtraParams = false;
    private boolean allowLessParams = false;
    private boolean shouldLogInvocationErrors = true;
    private InvocationListener invocationListener = null;
    private HttpStatusCodeProvider httpStatusCodeProvider = null;
    private ConvertedParameterTransformer convertedParameterTransformer = null;
    private String contentType = null;
    private List<JsonRpcInterceptor> interceptorList = null;
    private ExecutorService batchExecutorService = null;
    private long parallelBatchProcessingTimeout;

    private static Map<String, String> findServiceBeanDefinitions(ConfigurableListableBeanFactory beanFactory) {
        HashMap<String, String> serviceBeanNames = new HashMap<String, String>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            AutoJsonRpcServiceImpl autoJsonRpcServiceImplAnnotation = (AutoJsonRpcServiceImpl)beanFactory.findAnnotationOnBean(beanName, AutoJsonRpcServiceImpl.class);
            JsonRpcService jsonRpcServiceAnnotation = (JsonRpcService)beanFactory.findAnnotationOnBean(beanName, JsonRpcService.class);
            if (null == autoJsonRpcServiceImplAnnotation) continue;
            if (null == jsonRpcServiceAnnotation) {
                throw new IllegalStateException("on the bean [" + beanName + "], @" + AutoJsonRpcServiceImpl.class.getSimpleName() + " was found, but not @" + JsonRpcService.class.getSimpleName() + " -- both are required");
            }
            ArrayList<String> paths = new ArrayList<String>();
            Collections.addAll(paths, autoJsonRpcServiceImplAnnotation.additionalPaths());
            paths.add(jsonRpcServiceAnnotation.value());
            for (String path : paths) {
                if (!PATTERN_JSONRPC_PATH.matcher(path).matches()) {
                    throw new RuntimeException("the path [" + path + "] for the bean [" + beanName + "] is not valid");
                }
                logger.info("exporting bean [{}] ---> [{}]", (Object)beanName, (Object)path);
                if (!AutoJsonRpcServiceImplExporter.isNotDuplicateService(serviceBeanNames, beanName, path)) continue;
                serviceBeanNames.put(path, beanName);
            }
        }
        AutoJsonRpcServiceImplExporter.collectFromParentBeans(beanFactory, serviceBeanNames);
        return serviceBeanNames;
    }

    private static void collectFromParentBeans(ConfigurableListableBeanFactory beanFactory, Map<String, String> serviceBeanNames) {
        BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
        if (parentBeanFactory != null && ConfigurableListableBeanFactory.class.isInstance(parentBeanFactory)) {
            for (Map.Entry<String, String> entry : AutoJsonRpcServiceImplExporter.findServiceBeanDefinitions((ConfigurableListableBeanFactory)parentBeanFactory).entrySet()) {
                if (!AutoJsonRpcServiceImplExporter.isNotDuplicateService(serviceBeanNames, entry.getKey(), entry.getValue())) continue;
                serviceBeanNames.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private static boolean isNotDuplicateService(Map<String, String> serviceBeanNames, String beanName, String pathValue) {
        if (serviceBeanNames.containsKey(pathValue)) {
            String otherBeanName = serviceBeanNames.get(pathValue);
            logger.debug("Duplicate JSON-RPC path specification: found {} on both [{}] and [{}].", new Object[]{pathValue, beanName, otherBeanName});
            return false;
        }
        return true;
    }

    private static boolean hasServiceAnnotation(JsonRpcService jsonRpcPath) {
        return jsonRpcPath != null;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        Map<String, String> servicePathToBeanName = AutoJsonRpcServiceImplExporter.findServiceBeanDefinitions((ConfigurableListableBeanFactory)defaultListableBeanFactory);
        for (Map.Entry<String, String> entry : servicePathToBeanName.entrySet()) {
            this.registerServiceProxy(defaultListableBeanFactory, this.makeUrlPath(entry.getKey()), entry.getValue());
        }
    }

    private String makeUrlPath(String servicePath) {
        if (null == servicePath || 0 == servicePath.length()) {
            throw new IllegalArgumentException("the service path must be provided");
        }
        if ('/' == servicePath.charAt(0)) {
            return servicePath;
        }
        return PATH_PREFIX.concat(servicePath);
    }

    private void registerServiceProxy(DefaultListableBeanFactory defaultListableBeanFactory, String servicePath, String serviceBeanName) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(JsonServiceExporter.class).addPropertyReference("service", serviceBeanName);
        BeanDefinition serviceBeanDefinition = this.findBeanDefinition((ConfigurableListableBeanFactory)defaultListableBeanFactory, serviceBeanName);
        for (Class<?> currentInterface : this.getBeanInterfaces(serviceBeanDefinition, defaultListableBeanFactory.getBeanClassLoader())) {
            if (!currentInterface.isAnnotationPresent(JsonRpcService.class)) continue;
            String serviceInterface = currentInterface.getName();
            logger.debug("Registering interface '{}' for JSON-RPC bean [{}].", (Object)serviceInterface, (Object)serviceBeanName);
            builder.addPropertyValue("serviceInterface", (Object)serviceInterface);
            break;
        }
        if (this.objectMapper != null) {
            builder.addPropertyValue("objectMapper", (Object)this.objectMapper);
        }
        if (this.errorResolver != null) {
            builder.addPropertyValue("errorResolver", (Object)this.errorResolver);
        }
        if (this.invocationListener != null) {
            builder.addPropertyValue("invocationListener", (Object)this.invocationListener);
        }
        if (this.registerTraceInterceptor != null) {
            builder.addPropertyValue("registerTraceInterceptor", (Object)this.registerTraceInterceptor);
        }
        if (this.httpStatusCodeProvider != null) {
            builder.addPropertyValue("httpStatusCodeProvider", (Object)this.httpStatusCodeProvider);
        }
        if (this.convertedParameterTransformer != null) {
            builder.addPropertyValue("convertedParameterTransformer", (Object)this.convertedParameterTransformer);
        }
        if (this.contentType != null) {
            builder.addPropertyValue("contentType", (Object)this.contentType);
        }
        if (this.interceptorList != null) {
            builder.addPropertyValue("interceptorList", this.interceptorList);
        }
        if (this.batchExecutorService != null) {
            builder.addPropertyValue("batchExecutorService", (Object)this.batchExecutorService);
        }
        builder.addPropertyValue("backwardsCompatible", (Object)this.backwardsCompatible);
        builder.addPropertyValue("rethrowExceptions", (Object)this.rethrowExceptions);
        builder.addPropertyValue("allowExtraParams", (Object)this.allowExtraParams);
        builder.addPropertyValue("allowLessParams", (Object)this.allowLessParams);
        builder.addPropertyValue("shouldLogInvocationErrors", (Object)this.shouldLogInvocationErrors);
        defaultListableBeanFactory.registerBeanDefinition(servicePath, (BeanDefinition)builder.getBeanDefinition());
    }

    private BeanDefinition findBeanDefinition(ConfigurableListableBeanFactory beanFactory, String serviceBeanName) {
        if (beanFactory.containsLocalBean(serviceBeanName)) {
            return beanFactory.getBeanDefinition(serviceBeanName);
        }
        BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
        if (parentBeanFactory != null && ConfigurableListableBeanFactory.class.isInstance(parentBeanFactory)) {
            return this.findBeanDefinition((ConfigurableListableBeanFactory)parentBeanFactory, serviceBeanName);
        }
        throw new NoSuchBeanDefinitionException(serviceBeanName);
    }

    private Class<?>[] getBeanInterfaces(BeanDefinition serviceBeanDefinition, ClassLoader beanClassLoader) {
        String beanClassName = serviceBeanDefinition.getBeanClassName();
        try {
            Class beanClass = ClassUtils.forName((String)beanClassName, (ClassLoader)beanClassLoader);
            return ClassUtils.getAllInterfacesForClass((Class)beanClass, (ClassLoader)beanClassLoader);
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new IllegalStateException(String.format("Cannot find bean class '%s'.", beanClassName), e);
        }
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setErrorResolver(ErrorResolver errorResolver) {
        this.errorResolver = errorResolver;
    }

    public void setBackwardsCompatible(boolean backwardsCompatible) {
        this.backwardsCompatible = backwardsCompatible;
    }

    public void setRethrowExceptions(boolean rethrowExceptions) {
        this.rethrowExceptions = rethrowExceptions;
    }

    public void setAllowExtraParams(boolean allowExtraParams) {
        this.allowExtraParams = allowExtraParams;
    }

    public void setAllowLessParams(boolean allowLessParams) {
        this.allowLessParams = allowLessParams;
    }

    public void setRegisterTraceInterceptor(boolean registerTraceInterceptor) {
        this.registerTraceInterceptor = registerTraceInterceptor;
    }

    public void setInvocationListener(InvocationListener invocationListener) {
        this.invocationListener = invocationListener;
    }

    public void setHttpStatusCodeProvider(HttpStatusCodeProvider httpStatusCodeProvider) {
        this.httpStatusCodeProvider = httpStatusCodeProvider;
    }

    public void setConvertedParameterTransformer(ConvertedParameterTransformer convertedParameterTransformer) {
        this.convertedParameterTransformer = convertedParameterTransformer;
    }

    public void setShouldLogInvocationErrors(boolean shouldLogInvocationErrors) {
        this.shouldLogInvocationErrors = shouldLogInvocationErrors;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setInterceptorList(List<JsonRpcInterceptor> interceptorList) {
        if (interceptorList == null || interceptorList.isEmpty()) {
            throw new IllegalArgumentException("Interceptor list must be not null and not empty");
        }
        this.interceptorList = interceptorList;
    }

    public void setBatchExecutorService(ExecutorService batchExecutorService) {
        this.batchExecutorService = batchExecutorService;
    }

    public void setParallelBatchProcessingTimeout(long parallelBatchProcessingTimeout) {
        this.parallelBatchProcessingTimeout = parallelBatchProcessingTimeout;
    }
}

