/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.JsonRpcService;
import com.googlecode.jsonrpc4j.spring.JsonProxyFactoryBean;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ClassUtils;

public class AutoJsonRpcClientProxyCreator
implements BeanFactoryPostProcessor,
ApplicationContextAware,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(AutoJsonRpcClientProxyCreator.class);
    private ApplicationContext applicationContext;
    private Environment environment;
    private String scanPackage;
    private URL baseUrl;
    private ObjectMapper objectMapper;
    private String contentType;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        SimpleMetadataReaderFactory metadataReaderFactory = new SimpleMetadataReaderFactory((ResourceLoader)this.applicationContext);
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        String resolvedPath = this.resolvePackageToScan();
        logger.debug("Scanning '{}' for JSON-RPC service interfaces.", (Object)resolvedPath);
        try {
            for (Resource resource : this.applicationContext.getResources(resolvedPath)) {
                String jsonRpcPathAnnotation;
                if (!resource.isReadable()) continue;
                MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
                ClassMetadata classMetadata = metadataReader.getClassMetadata();
                AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
                if (!annotationMetadata.isAnnotated(jsonRpcPathAnnotation = JsonRpcService.class.getName())) continue;
                String className = classMetadata.getClassName();
                String path = (String)annotationMetadata.getAnnotationAttributes(jsonRpcPathAnnotation).get("value");
                path = this.environment.resolvePlaceholders(path);
                logger.debug("Found JSON-RPC service to proxy [{}] on path '{}'.", (Object)className, (Object)path);
                this.registerJsonProxyBean(defaultListableBeanFactory, className, path);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Cannot scan package '%s' for classes.", resolvedPath), e);
        }
    }

    private String resolvePackageToScan() {
        return "classpath:" + ClassUtils.convertClassNameToResourcePath((String)this.scanPackage) + "/**/*.class";
    }

    private void registerJsonProxyBean(DefaultListableBeanFactory defaultListableBeanFactory, String className, String path) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(JsonProxyFactoryBean.class).addPropertyValue("serviceUrl", (Object)this.appendBasePath(path)).addPropertyValue("serviceInterface", (Object)className);
        if (this.objectMapper != null) {
            beanDefinitionBuilder.addPropertyValue("objectMapper", (Object)this.objectMapper);
        }
        if (this.contentType != null) {
            beanDefinitionBuilder.addPropertyValue("contentType", (Object)this.contentType);
        }
        defaultListableBeanFactory.registerBeanDefinition(className + "-clientProxy", (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    private String appendBasePath(String path) {
        try {
            return new URL(this.baseUrl, path).toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Cannot combine URLs '%s' and '%s' to valid URL.", this.baseUrl, path), e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setScanPackage(String scanPackage) {
        this.scanPackage = scanPackage;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setContentType(String contextType) {
        this.contentType = contextType;
    }
}

