/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.googlecode.jsonrpc4j.DefaultExceptionResolver;
import com.googlecode.jsonrpc4j.ExceptionResolver;
import com.googlecode.jsonrpc4j.JsonRpcClientException;
import com.googlecode.jsonrpc4j.NoCloseOutputStream;
import com.googlecode.jsonrpc4j.ReadContext;
import com.googlecode.jsonrpc4j.RequestIDGenerator;
import com.googlecode.jsonrpc4j.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcClient {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper mapper;
    private final Random random;
    private RequestListener requestListener;
    private RequestIDGenerator requestIDGenerator;
    private ExceptionResolver exceptionResolver;
    private Map<String, Object> additionalJsonContent = new HashMap<String, Object>();

    public JsonRpcClient() {
        this(new ObjectMapper());
    }

    public JsonRpcClient(ObjectMapper mapper) {
        this(mapper, DefaultExceptionResolver.INSTANCE);
    }

    public JsonRpcClient(ObjectMapper mapper, ExceptionResolver exceptionResolver) {
        this.mapper = mapper;
        this.random = new Random(System.currentTimeMillis());
        this.requestIDGenerator = new RandomRequestIDGenerator();
        this.exceptionResolver = exceptionResolver;
    }

    public Map<String, Object> getAdditionalJsonContent() {
        return this.additionalJsonContent;
    }

    public void setAdditionalJsonContent(Map<String, Object> additionalJsonContent) {
        this.additionalJsonContent = additionalJsonContent;
    }

    public void setRequestListener(RequestListener requestListener) {
        this.requestListener = requestListener;
    }

    public void setRequestIDGenerator(RequestIDGenerator requestIDGenerator) {
        this.requestIDGenerator = requestIDGenerator;
    }

    public <T> T invokeAndReadResponse(String methodName, Object argument, Class<T> clazz, OutputStream output, InputStream input) throws Throwable {
        return (T)this.invokeAndReadResponse(methodName, argument, (Type)Type.class.cast(clazz), output, input);
    }

    public Object invokeAndReadResponse(String methodName, Object argument, Type returnType, OutputStream output, InputStream input) throws Throwable {
        return this.invokeAndReadResponse(methodName, argument, returnType, output, input, this.requestIDGenerator.generateID());
    }

    private Object invokeAndReadResponse(String methodName, Object argument, Type returnType, OutputStream output, InputStream input, String id) throws Throwable {
        this.invoke(methodName, argument, output, id);
        return this.readResponse(returnType, input, id);
    }

    private void invoke(String methodName, Object argument, OutputStream output, String id) throws IOException {
        this.writeRequest(methodName, argument, output, id);
        output.flush();
    }

    private Object readResponse(Type returnType, InputStream input, String id) throws Throwable {
        ReadContext context = ReadContext.getReadContext(input, this.mapper);
        ObjectNode jsonObject = this.getValidResponse(id, context);
        this.notifyAnswerListener(jsonObject);
        this.handleErrorResponse(jsonObject);
        if (this.hasResult(jsonObject)) {
            if (this.isReturnTypeInvalid(returnType)) {
                return null;
            }
            return this.constructResponseObject(returnType, jsonObject);
        }
        return null;
    }

    private void writeRequest(String methodName, Object argument, OutputStream output, String id) throws IOException {
        this.internalWriteRequest(methodName, argument, output, id);
    }

    private ObjectNode getValidResponse(String id, ReadContext context) throws IOException {
        JsonNode response = this.readResponseNode(context);
        this.raiseExceptionIfNotValidResponseObject(response);
        ObjectNode jsonObject = (ObjectNode)ObjectNode.class.cast(response);
        if (id != null) {
            while (this.isIdValueNotCorrect(id, jsonObject)) {
                response = context.nextValue();
                this.raiseExceptionIfNotValidResponseObject(response);
                jsonObject = (ObjectNode)ObjectNode.class.cast(response);
            }
        }
        return jsonObject;
    }

    private void notifyAnswerListener(ObjectNode jsonObject) {
        if (this.requestListener != null) {
            this.requestListener.onBeforeResponseProcessed(this, jsonObject);
        }
    }

    protected void handleErrorResponse(ObjectNode jsonObject) throws Throwable {
        if (this.hasError(jsonObject)) {
            if (this.exceptionResolver == null) {
                throw DefaultExceptionResolver.INSTANCE.resolveException(jsonObject);
            }
            throw this.exceptionResolver.resolveException(jsonObject);
        }
    }

    private boolean hasResult(ObjectNode jsonObject) {
        return Util.hasNonNullData(jsonObject, "result");
    }

    private boolean isReturnTypeInvalid(Type returnType) {
        if (returnType == null || returnType == Void.class) {
            this.logger.warn("Server returned result but returnType is null");
            return true;
        }
        return false;
    }

    private Object constructResponseObject(Type returnType, ObjectNode jsonObject) throws IOException {
        JsonParser returnJsonParser = this.mapper.treeAsTokens((TreeNode)jsonObject.get("result"));
        JavaType returnJavaType = this.mapper.getTypeFactory().constructType(returnType);
        return this.mapper.readValue(returnJsonParser, returnJavaType);
    }

    private void internalWriteRequest(String methodName, Object arguments, OutputStream output, String id) throws IOException {
        ObjectNode request = this.internalCreateRequest(methodName, arguments, id);
        this.logger.debug("Request {}", (Object)request);
        this.writeAndFlushValue(output, request);
    }

    private JsonNode readResponseNode(ReadContext context) throws IOException {
        context.assertReadable();
        JsonNode response = context.nextValue();
        this.logger.debug("JSON-RPC Response: {}", (Object)response);
        return response;
    }

    private void raiseExceptionIfNotValidResponseObject(JsonNode response) {
        if (this.isInvalidResponse(response)) {
            throw new JsonRpcClientException(0, "Invalid JSON-RPC response", response);
        }
    }

    private boolean isIdValueNotCorrect(String id, ObjectNode jsonObject) {
        return !jsonObject.has("id") || jsonObject.get("id") == null || !jsonObject.get("id").asText().equals(id);
    }

    protected boolean hasError(ObjectNode jsonObject) {
        return jsonObject.has("error") && jsonObject.get("error") != null && !jsonObject.get("error").isNull() && (!jsonObject.get("error").isInt() || jsonObject.intValue() != 0);
    }

    private ObjectNode internalCreateRequest(String methodName, Object arguments, String id) {
        ObjectNode request = this.mapper.createObjectNode();
        this.addId(id, request);
        this.addProtocolAndMethod(methodName, request);
        this.addParameters(arguments, request);
        this.addAdditionalHeaders(request);
        this.notifyBeforeRequestListener(request);
        this.addNoneArguments(request);
        return request;
    }

    private void writeAndFlushValue(OutputStream output, Object value) throws IOException {
        this.mapper.writeValue((OutputStream)new NoCloseOutputStream(output), value);
        output.flush();
    }

    private boolean isInvalidResponse(JsonNode response) {
        return !response.isObject();
    }

    private void addId(String id, ObjectNode request) {
        if (id != null) {
            request.put("id", id);
        }
    }

    private void addProtocolAndMethod(String methodName, ObjectNode request) {
        request.put("jsonrpc", "2.0");
        request.put("method", methodName);
    }

    private void addParameters(Object arguments, ObjectNode request) {
        if (this.isArrayArguments(arguments)) {
            this.addArrayArguments(arguments, request);
        } else if (this.isCollectionArguments(arguments)) {
            this.addCollectionArguments(arguments, request);
        } else if (this.isMapArguments(arguments)) {
            this.addMapArguments(arguments, request);
        } else if (arguments != null) {
            request.set("params", this.mapper.valueToTree(arguments));
        }
    }

    private void addAdditionalHeaders(ObjectNode request) {
        for (Map.Entry<String, Object> entry : this.additionalJsonContent.entrySet()) {
            request.set(entry.getKey(), this.mapper.valueToTree(entry.getValue()));
        }
    }

    private void notifyBeforeRequestListener(ObjectNode request) {
        if (this.requestListener != null) {
            this.requestListener.onBeforeRequestSent(this, request);
        }
    }

    private boolean isArrayArguments(Object arguments) {
        return arguments != null && arguments.getClass().isArray();
    }

    private void addArrayArguments(Object arguments, ObjectNode request) {
        Object[] args = (Object[])Object[].class.cast(arguments);
        if (args.length > 0) {
            ArrayNode paramsNode = new ArrayNode(this.mapper.getNodeFactory());
            for (Object arg : args) {
                JsonNode argNode = this.mapper.valueToTree(arg);
                paramsNode.add(argNode);
            }
            request.set("params", (JsonNode)paramsNode);
        }
    }

    private boolean isCollectionArguments(Object arguments) {
        return arguments != null && Collection.class.isInstance(arguments);
    }

    private void addNoneArguments(ObjectNode request) {
        if (!request.has("params")) {
            request.set("params", this.mapper.valueToTree((Object)new String[0]));
        }
    }

    private void addCollectionArguments(Object arguments, ObjectNode request) {
        Collection args = (Collection)Collection.class.cast(arguments);
        if (!args.isEmpty()) {
            ArrayNode paramsNode = new ArrayNode(this.mapper.getNodeFactory());
            for (Object arg : args) {
                JsonNode argNode = this.mapper.valueToTree(arg);
                paramsNode.add(argNode);
            }
            request.set("params", (JsonNode)paramsNode);
        }
    }

    private boolean isMapArguments(Object arguments) {
        return arguments != null && Map.class.isInstance(arguments);
    }

    private void addMapArguments(Object arguments, ObjectNode request) {
        if (!((Map)Map.class.cast(arguments)).isEmpty()) {
            request.set("params", this.mapper.valueToTree(arguments));
        }
    }

    private String generateRandomId() {
        return Integer.toString(this.random.nextInt(Integer.MAX_VALUE));
    }

    public <T> T invokeAndReadResponse(String methodName, Object argument, Class<T> clazz, OutputStream output, InputStream input, String id) throws Throwable {
        return (T)this.invokeAndReadResponse(methodName, argument, (Type)Type.class.cast(clazz), output, input, id);
    }

    public void invoke(String methodName, Object argument, OutputStream output) throws IOException {
        this.invoke(methodName, argument, output, this.requestIDGenerator.generateID());
    }

    public void invokeNotification(String methodName, Object argument, OutputStream output) throws IOException {
        this.writeRequest(methodName, argument, output, null);
        output.flush();
    }

    public <T> T readResponse(Class<T> clazz, InputStream input) throws Throwable {
        return (T)this.readResponse((Type)clazz, input);
    }

    public Object readResponse(Type returnType, InputStream input) throws Throwable {
        return this.readResponse(returnType, input, null);
    }

    public <T> T readResponse(Class<T> clazz, InputStream input, String id) throws Throwable {
        return (T)this.readResponse((Type)clazz, input, id);
    }

    protected ObjectNode createRequest(String methodName, Object argument) {
        return this.internalCreateRequest(methodName, argument, this.requestIDGenerator.generateID());
    }

    public ObjectNode createRequest(String methodName, Object argument, String id) {
        return this.internalCreateRequest(methodName, argument, id);
    }

    public void writeNotification(String methodName, Object argument, OutputStream output) throws IOException {
        this.internalWriteRequest(methodName, argument, output, null);
    }

    protected Object readResponse(Type returnType, JsonNode jsonObject) throws Throwable {
        return this.readResponse(returnType, jsonObject, null);
    }

    private Object readResponse(Type returnType, JsonNode jsonNode, String id) throws Throwable {
        this.raiseExceptionIfNotValidResponseObject(jsonNode);
        ObjectNode jsonObject = (ObjectNode)ObjectNode.class.cast(jsonNode);
        this.notifyAnswerListener(jsonObject);
        this.handleErrorResponse(jsonObject);
        if (this.hasResult(jsonObject)) {
            if (this.isReturnTypeInvalid(returnType)) {
                return null;
            }
            return this.constructResponseObject(returnType, jsonObject);
        }
        return null;
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public void setExceptionResolver(ExceptionResolver exceptionResolver) {
        this.exceptionResolver = exceptionResolver;
    }

    class RandomRequestIDGenerator
    implements RequestIDGenerator {
        RandomRequestIDGenerator() {
        }

        @Override
        public String generateID() {
            return JsonRpcClient.this.generateRandomId();
        }
    }

    public static interface RequestListener {
        public void onBeforeRequestSent(JsonRpcClient var1, ObjectNode var2);

        public void onBeforeResponseProcessed(JsonRpcClient var1, ObjectNode var2);
    }
}

