/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.googlecode.jsonrpc4j.AnnotationsErrorResolver;
import com.googlecode.jsonrpc4j.ConvertedParameterTransformer;
import com.googlecode.jsonrpc4j.DefaultErrorResolver;
import com.googlecode.jsonrpc4j.ErrorResolver;
import com.googlecode.jsonrpc4j.HttpStatusCodeProvider;
import com.googlecode.jsonrpc4j.InvocationListener;
import com.googlecode.jsonrpc4j.JsonResponse;
import com.googlecode.jsonrpc4j.JsonRpcInterceptor;
import com.googlecode.jsonrpc4j.JsonRpcParam;
import com.googlecode.jsonrpc4j.JsonUtil;
import com.googlecode.jsonrpc4j.MultipleErrorResolver;
import com.googlecode.jsonrpc4j.NoCloseOutputStream;
import com.googlecode.jsonrpc4j.ReadContext;
import com.googlecode.jsonrpc4j.ReflectionUtil;
import com.googlecode.jsonrpc4j.RequestInterceptor;
import com.googlecode.jsonrpc4j.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.iharder.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcBasicServer {
    public static final String JSONRPC_CONTENT_TYPE = "application/json-rpc";
    public static final String PARAMS = "params";
    public static final String METHOD = "method";
    public static final String JSONRPC = "jsonrpc";
    public static final String ID = "id";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ERROR = "error";
    public static final String ERROR_MESSAGE = "message";
    public static final String ERROR_CODE = "code";
    public static final String DATA = "data";
    public static final String RESULT = "result";
    public static final String EXCEPTION_TYPE_NAME = "exceptionTypeName";
    public static final String VERSION = "2.0";
    public static final int CODE_OK = 0;
    public static final String WEB_PARAM_ANNOTATION_CLASS_LOADER = "javax.jws.WebParam";
    public static final String NAME = "name";
    public static final String NULL = "null";
    private static final Logger logger = LoggerFactory.getLogger(JsonRpcBasicServer.class);
    private static final ErrorResolver DEFAULT_ERROR_RESOLVER = new MultipleErrorResolver(AnnotationsErrorResolver.INSTANCE, DefaultErrorResolver.INSTANCE);
    private static Pattern BASE64_PATTERN = Pattern.compile("[A-Za-z0-9_=-]+");
    private static Class<? extends Annotation> WEB_PARAM_ANNOTATION_CLASS;
    private static Method WEB_PARAM_NAME_METHOD;
    private final ObjectMapper mapper;
    private final Class<?> remoteInterface;
    private final Object handler;
    protected HttpStatusCodeProvider httpStatusCodeProvider = null;
    private boolean backwardsCompatible = true;
    private boolean rethrowExceptions = false;
    private boolean allowExtraParams = false;
    private boolean allowLessParams = false;
    private RequestInterceptor requestInterceptor = null;
    private ErrorResolver errorResolver = null;
    private InvocationListener invocationListener = null;
    private ConvertedParameterTransformer convertedParameterTransformer = null;
    private boolean shouldLogInvocationErrors = true;
    private List<JsonRpcInterceptor> interceptorList = new ArrayList<JsonRpcInterceptor>();
    private ExecutorService batchExecutorService = null;
    private long parallelBatchProcessingTimeout = Long.MAX_VALUE;

    public JsonRpcBasicServer(ObjectMapper mapper, Object handler) {
        this(mapper, handler, null);
    }

    public JsonRpcBasicServer(ObjectMapper mapper, Object handler, Class<?> remoteInterface) {
        this.mapper = mapper;
        this.handler = handler;
        this.remoteInterface = remoteInterface;
        if (handler != null) {
            logger.debug("created server for interface {} with handler {}", remoteInterface, handler.getClass());
        }
    }

    public JsonRpcBasicServer(Object handler, Class<?> remoteInterface) {
        this(new ObjectMapper(), handler, remoteInterface);
    }

    public JsonRpcBasicServer(Object handler) {
        this(new ObjectMapper(), handler, null);
    }

    private static void loadAnnotationSupportEngine() {
        ClassLoader classLoader = JsonRpcBasicServer.class.getClassLoader();
        try {
            WEB_PARAM_ANNOTATION_CLASS = classLoader.loadClass(WEB_PARAM_ANNOTATION_CLASS_LOADER).asSubclass(Annotation.class);
            WEB_PARAM_NAME_METHOD = WEB_PARAM_ANNOTATION_CLASS.getMethod(NAME, new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            logger.error("Could not find {}.{}", new Object[]{WEB_PARAM_ANNOTATION_CLASS_LOADER, NAME, e});
        }
    }

    static InputStream createInputStream(String method, String id, String params) throws IOException {
        StringBuilder envelope = new StringBuilder();
        envelope.append("{\"");
        envelope.append(JSONRPC);
        envelope.append("\":\"");
        envelope.append(VERSION);
        envelope.append("\",\"");
        envelope.append(ID);
        envelope.append("\":");
        if (null != id && !id.isEmpty()) {
            envelope.append(id);
        } else {
            envelope.append(NULL);
        }
        envelope.append(",\"");
        envelope.append(METHOD);
        envelope.append("\":");
        if (null != method && !method.isEmpty()) {
            envelope.append('\"');
            envelope.append(method);
            envelope.append('\"');
        } else {
            envelope.append(NULL);
        }
        envelope.append(",\"");
        envelope.append(PARAMS);
        envelope.append("\":");
        if (null != params && !params.isEmpty()) {
            String decodedParams;
            if (BASE64_PATTERN.matcher(params).matches()) {
                decodedParams = new String(Base64.decode((String)params), StandardCharsets.UTF_8);
            } else {
                switch (params.charAt(0)) {
                    case '[': 
                    case '{': {
                        decodedParams = params;
                        break;
                    }
                    default: {
                        throw new IOException("badly formed 'param' parameter starting with; [" + params.charAt(0) + "]");
                    }
                }
            }
            envelope.append(decodedParams);
        } else {
            envelope.append("[]");
        }
        envelope.append('}');
        return new ByteArrayInputStream(envelope.toString().getBytes(StandardCharsets.UTF_8));
    }

    public RequestInterceptor getRequestInterceptor() {
        return this.requestInterceptor;
    }

    public void setRequestInterceptor(RequestInterceptor requestInterceptor) {
        this.requestInterceptor = requestInterceptor;
    }

    public int handleRequest(InputStream input, OutputStream output) throws IOException {
        ReadContext readContext = ReadContext.getReadContext(input, this.mapper);
        try {
            readContext.assertReadable();
            JsonNode jsonNode = readContext.nextValue();
            for (JsonRpcInterceptor interceptor : this.interceptorList) {
                interceptor.preHandleJson(jsonNode);
            }
            JsonResponse jsonResponse = this.handleJsonNodeRequest(jsonNode);
            this.writeAndFlushValue(output, jsonResponse.getResponse());
            if (jsonResponse.getExceptionToRethrow() != null) {
                throw jsonResponse.getExceptionToRethrow();
            }
            return jsonResponse.getCode();
        }
        catch (JsonParseException | JsonMappingException e) {
            JsonResponse responseError = this.createResponseError(VERSION, NULL, ErrorResolver.JsonError.PARSE_ERROR);
            this.writeAndFlushValue(output, responseError.getResponse());
            return responseError.getCode();
        }
    }

    protected Class<?>[] getHandlerInterfaces(String serviceName) {
        if (this.remoteInterface != null) {
            return new Class[]{this.remoteInterface};
        }
        if (Proxy.isProxyClass(this.handler.getClass())) {
            return this.handler.getClass().getInterfaces();
        }
        return new Class[]{this.handler.getClass()};
    }

    protected JsonResponse handleJsonNodeRequest(JsonNode node) throws JsonParseException, JsonMappingException {
        if (node.isArray()) {
            return this.handleArray((ArrayNode)node);
        }
        if (node.isObject()) {
            return this.handleObject((ObjectNode)node);
        }
        return this.createResponseError(VERSION, NULL, ErrorResolver.JsonError.INVALID_REQUEST);
    }

    private JsonResponse handleArray(ArrayNode node) {
        logger.debug("Handling {} requests", (Object)node.size());
        if (this.batchExecutorService != null) {
            return this.getBatchResponseInParallel(node);
        }
        return this.getBatchResponseSequentially(node);
    }

    private JsonResponse getBatchResponseSequentially(ArrayNode node) {
        ErrorResolver.JsonError result = ErrorResolver.JsonError.OK;
        ArrayNode batchResult = this.mapper.createArrayNode();
        int errorCount = 0;
        JsonResponse response = new JsonResponse();
        for (int i = 0; i < node.size(); ++i) {
            JsonResponse nodeResult;
            try {
                nodeResult = this.handleJsonNodeRequest(node.get(i));
            }
            catch (Exception e) {
                nodeResult = this.createResponseError(VERSION, NULL, ErrorResolver.JsonError.PARSE_ERROR);
            }
            this.handleRethrowException(response, nodeResult);
            batchResult.add(nodeResult.getResponse());
            if (!this.isError(nodeResult)) continue;
            result = ErrorResolver.JsonError.BULK_ERROR;
            ++errorCount;
        }
        logger.debug("served {} requests, error {}, result {}", new Object[]{node.size(), errorCount, result});
        response.setResponse((JsonNode)batchResult);
        response.setCode(result.getCode());
        return response;
    }

    private JsonResponse getBatchResponseInParallel(ArrayNode node) {
        ErrorResolver.JsonError result = ErrorResolver.JsonError.OK;
        ArrayNode batchResult = this.mapper.createArrayNode();
        int errorCount = 0;
        JsonResponse response = new JsonResponse();
        HashMap<Object, Future<JsonResponse>> responses = new HashMap<Object, Future<JsonResponse>>();
        for (int i = 0; i < node.size(); ++i) {
            JsonNode jsonNode = node.get(i);
            Object id = this.parseId(jsonNode.get(ID));
            Future<JsonResponse> responseFuture = this.batchExecutorService.submit(() -> this.handleJsonNodeRequest(jsonNode));
            responses.put(id, responseFuture);
        }
        for (Map.Entry<Object, Future<JsonResponse>> entry : responses.entrySet()) {
            JsonResponse singleJsonResponse = this.getSingleJsonResponse(entry);
            this.handleRethrowException(response, singleJsonResponse);
            batchResult.add(singleJsonResponse.getResponse());
            if (!this.isError(singleJsonResponse)) continue;
            result = ErrorResolver.JsonError.BULK_ERROR;
            ++errorCount;
        }
        logger.debug("served {} requests, error {}, result {}", new Object[]{node.size(), errorCount, result});
        response.setResponse((JsonNode)batchResult);
        response.setCode(result.getCode());
        return response;
    }

    private void handleRethrowException(JsonResponse response, JsonResponse singleJsonResponse) {
        if (singleJsonResponse.getExceptionToRethrow() != null && response.getExceptionToRethrow() == null) {
            response.setExceptionToRethrow(singleJsonResponse.getExceptionToRethrow());
        }
    }

    private JsonResponse getSingleJsonResponse(Map.Entry<Object, Future<JsonResponse>> responseFuture) {
        JsonResponse response;
        try {
            response = responseFuture.getValue().get(this.parallelBatchProcessingTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            ErrorResolver.JsonError jsonError = new ErrorResolver.JsonError(ErrorResolver.JsonError.INTERNAL_ERROR.code, t.getMessage(), t.getClass().getName());
            return this.createResponseError(VERSION, responseFuture.getKey(), jsonError);
        }
        return response;
    }

    private boolean isError(JsonResponse result) {
        return result.getCode() != ErrorResolver.JsonError.OK.code;
    }

    private JsonResponse handleObject(ObjectNode node) throws JsonParseException, JsonMappingException {
        String jsonRpc;
        logger.debug("Request: {}", (Object)node);
        if (!this.isValidRequest(node)) {
            return this.createResponseError(VERSION, NULL, ErrorResolver.JsonError.INVALID_REQUEST);
        }
        Object id = this.parseId(node.get(ID));
        String string = jsonRpc = Util.hasNonNullData(node, JSONRPC) ? node.get(JSONRPC).asText() : VERSION;
        if (!Util.hasNonNullData(node, METHOD)) {
            return this.createResponseError(jsonRpc, id, ErrorResolver.JsonError.METHOD_NOT_FOUND);
        }
        String fullMethodName = node.get(METHOD).asText();
        String partialMethodName = this.getMethodName(fullMethodName);
        String serviceName = this.getServiceName(fullMethodName);
        Set<Method> methods = ReflectionUtil.findCandidateMethods(this.getHandlerInterfaces(serviceName), partialMethodName);
        if (methods.isEmpty()) {
            return this.createResponseError(jsonRpc, id, ErrorResolver.JsonError.METHOD_NOT_FOUND);
        }
        AMethodWithItsArgs methodArgs = this.findBestMethodByParamsNode(methods, node.get(PARAMS));
        if (methodArgs == null) {
            return this.createResponseError(jsonRpc, id, ErrorResolver.JsonError.METHOD_PARAMS_INVALID);
        }
        Throwable throwable = null;
        try (InvokeListenerHandler handler = new InvokeListenerHandler(methodArgs, this.invocationListener);){
            Object object;
            JsonNode result;
            if (this.requestInterceptor != null) {
                this.requestInterceptor.interceptRequest((JsonNode)node);
            }
            Object target = this.getHandler(serviceName);
            for (JsonRpcInterceptor interceptor : this.interceptorList) {
                interceptor.preHandle(target, methodArgs.method, methodArgs.arguments);
            }
            handler.result = result = this.invoke(target, methodArgs.method, methodArgs.arguments);
            for (JsonRpcInterceptor interceptor : this.interceptorList) {
                interceptor.postHandle(target, methodArgs.method, methodArgs.arguments, result);
            }
            if (!this.isNotificationRequest(id)) {
                object = this.createResponseSuccess(jsonRpc, id, handler.result);
                return object;
            }
            object = new JsonResponse(null, ErrorResolver.JsonError.OK.code);
            return object;
        }
        catch (JsonParseException | JsonMappingException e) {
            throw e;
        }
        catch (Throwable e) {
            handler.error = e;
            JsonResponse jsonResponse = this.handleError(id, jsonRpc, methodArgs, e);
            return jsonResponse;
        }
    }

    private JsonResponse handleError(Object id, String jsonRpc, AMethodWithItsArgs methodArgs, Throwable e) {
        Throwable unwrappedException = this.getException(e);
        if (this.shouldLogInvocationErrors) {
            logger.warn("Error in JSON-RPC Service", unwrappedException);
        }
        ErrorResolver.JsonError error = this.resolveError(methodArgs, unwrappedException);
        JsonResponse responseError = this.createResponseError(jsonRpc, id, error);
        if (this.rethrowExceptions) {
            responseError.setExceptionToRethrow(new RuntimeException(unwrappedException));
        }
        return responseError;
    }

    private Throwable getException(Throwable thrown) {
        Throwable e = thrown;
        while (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
            while (e instanceof UndeclaredThrowableException) {
                e = ((UndeclaredThrowableException)e).getUndeclaredThrowable();
            }
        }
        return e;
    }

    private ErrorResolver.JsonError resolveError(AMethodWithItsArgs methodArgs, Throwable e) {
        ErrorResolver currentResolver = this.errorResolver == null ? DEFAULT_ERROR_RESOLVER : this.errorResolver;
        ErrorResolver.JsonError error = currentResolver.resolveError(e, methodArgs.method, methodArgs.arguments);
        if (error == null) {
            error = new ErrorResolver.JsonError(ErrorResolver.JsonError.ERROR_NOT_HANDLED.code, e.getMessage(), e.getClass().getName());
        }
        return error;
    }

    private boolean isNotificationRequest(Object id) {
        return id == null;
    }

    private boolean isValidRequest(ObjectNode node) {
        return this.backwardsCompatible || this.hasMethodAndVersion(node);
    }

    private boolean hasMethodAndVersion(ObjectNode node) {
        return node.has(JSONRPC) && node.has(METHOD);
    }

    protected String getServiceName(String methodName) {
        return null;
    }

    protected String getMethodName(String methodName) {
        return methodName;
    }

    protected Object getHandler(String serviceName) {
        return this.handler;
    }

    private JsonNode invoke(Object target, Method method, List<JsonNode> params) throws IOException, IllegalAccessException, InvocationTargetException {
        Object result;
        logger.debug("Invoking method: {} with args {}", (Object)method.getName(), params);
        if (method.getGenericParameterTypes().length == 1 && method.isVarArgs()) {
            Class<?> componentType = method.getParameterTypes()[0].getComponentType();
            result = componentType.isPrimitive() ? this.invokePrimitiveVarargs(target, method, params, componentType) : this.invokeNonPrimitiveVarargs(target, method, params, componentType);
        } else {
            Object[] convertedParams = this.convertJsonToParameters(method, params);
            if (this.convertedParameterTransformer != null) {
                convertedParams = this.convertedParameterTransformer.transformConvertedParameters(target, convertedParams);
            }
            result = method.invoke(target, convertedParams);
        }
        logger.debug("Invoked method: {}, result {}", (Object)method.getName(), result);
        return this.hasReturnValue(method) ? this.mapper.valueToTree(result) : null;
    }

    private Object invokePrimitiveVarargs(Object target, Method method, List<JsonNode> params, Class<?> componentType) throws IllegalAccessException, InvocationTargetException {
        Object convertedParams = Array.newInstance(componentType, params.size());
        for (int i = 0; i < params.size(); ++i) {
            JsonNode jsonNode = params.get(i);
            Class type = JsonUtil.getJavaTypeForJsonType(jsonNode);
            Object object = this.mapper.convertValue((Object)jsonNode, type);
            logger.debug("[{}] param: {} -> {}", new Object[]{method.getName(), i, type.getName()});
            Array.set(convertedParams, i, object);
        }
        return method.invoke(target, convertedParams);
    }

    private Object invokeNonPrimitiveVarargs(Object target, Method method, List<JsonNode> params, Class<?> componentType) throws IllegalAccessException, InvocationTargetException {
        Object[] convertedParams = (Object[])Array.newInstance(componentType, params.size());
        for (int i = 0; i < params.size(); ++i) {
            JsonNode jsonNode = params.get(i);
            Class type = JsonUtil.getJavaTypeForJsonType(jsonNode);
            Object object = this.mapper.convertValue((Object)jsonNode, type);
            logger.debug("[{}] param: {} -> {}", new Object[]{method.getName(), i, type.getName()});
            convertedParams[i] = object;
        }
        return method.invoke(target, new Object[]{convertedParams});
    }

    private boolean hasReturnValue(Method m) {
        return m.getGenericReturnType() != null;
    }

    private Object[] convertJsonToParameters(Method m, List<JsonNode> params) throws IOException {
        Object[] convertedParams = new Object[params.size()];
        Type[] parameterTypes = m.getGenericParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            JsonParser paramJsonParser = this.mapper.treeAsTokens((TreeNode)params.get(i));
            JavaType paramJavaType = this.mapper.getTypeFactory().constructType(parameterTypes[i]);
            convertedParams[i] = this.mapper.readerFor(paramJavaType).with(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).readValue(paramJsonParser);
        }
        return convertedParams;
    }

    private JsonResponse createResponse(String jsonRpc, Object id, JsonNode result, ErrorResolver.JsonError errorObject) {
        ObjectNode response = this.mapper.createObjectNode();
        response.put(JSONRPC, jsonRpc);
        if (id instanceof Integer) {
            response.put(ID, ((Integer)id).intValue());
        } else if (id instanceof Long) {
            response.put(ID, ((Long)id).longValue());
        } else if (id instanceof Float) {
            response.put(ID, ((Float)id).floatValue());
        } else if (id instanceof Double) {
            response.put(ID, ((Double)id).doubleValue());
        } else if (id instanceof BigDecimal) {
            response.put(ID, (BigDecimal)id);
        } else {
            response.put(ID, (String)id);
        }
        int responseCode = ErrorResolver.JsonError.OK.code;
        if (errorObject != null) {
            ObjectNode error = this.mapper.createObjectNode();
            error.put(ERROR_CODE, errorObject.code);
            error.put(ERROR_MESSAGE, errorObject.message);
            if (errorObject.data != null) {
                error.set(DATA, this.mapper.valueToTree(errorObject.data));
            }
            responseCode = errorObject.getCode();
            response.set(ERROR, (JsonNode)error);
        } else {
            response.set(RESULT, result);
        }
        for (JsonRpcInterceptor interceptor : this.interceptorList) {
            interceptor.postHandleJson((JsonNode)response);
        }
        return new JsonResponse((JsonNode)response, responseCode);
    }

    private JsonResponse createResponseError(String jsonRpc, Object id, ErrorResolver.JsonError errorObject) {
        return this.createResponse(jsonRpc, id, null, errorObject);
    }

    private JsonResponse createResponseSuccess(String jsonRpc, Object id, JsonNode result) {
        return this.createResponse(jsonRpc, id, result, null);
    }

    private AMethodWithItsArgs findBestMethodByParamsNode(Set<Method> methods, JsonNode paramsNode) {
        AMethodWithItsArgs matchedMethod;
        if (this.hasNoParameters(paramsNode)) {
            return this.findBestMethodUsingParamIndexes(methods, 0, null);
        }
        if (paramsNode.isArray()) {
            matchedMethod = this.findBestMethodUsingParamIndexes(methods, paramsNode.size(), (ArrayNode)paramsNode);
        } else if (paramsNode.isObject()) {
            matchedMethod = this.findBestMethodUsingParamNames(methods, this.collectFieldNames(paramsNode), (ObjectNode)paramsNode);
        } else {
            throw new IllegalArgumentException("Unknown params node type: " + paramsNode.toString());
        }
        if (matchedMethod == null) {
            matchedMethod = this.findBestMethodForVarargs(methods, paramsNode);
        }
        return matchedMethod;
    }

    private Set<String> collectFieldNames(JsonNode paramsNode) {
        HashSet<String> fieldNames = new HashSet<String>();
        Iterator itr = paramsNode.fieldNames();
        while (itr.hasNext()) {
            fieldNames.add((String)itr.next());
        }
        return fieldNames;
    }

    private boolean hasNoParameters(JsonNode paramsNode) {
        return this.isNullNodeOrValue(paramsNode);
    }

    private AMethodWithItsArgs findBestMethodUsingParamIndexes(Set<Method> methods, int paramCount, ArrayNode paramNodes) {
        int numParams = this.isNullNodeOrValue((JsonNode)paramNodes) ? 0 : paramNodes.size();
        int bestParamNumDiff = Integer.MAX_VALUE;
        Set<Method> matchedMethods = this.collectMethodsMatchingParamCount(methods, paramCount, bestParamNumDiff);
        if (matchedMethods.isEmpty()) {
            return null;
        }
        Method bestMethod = this.getBestMatchingArgTypeMethod(paramNodes, numParams, matchedMethods);
        return new AMethodWithItsArgs(bestMethod, paramCount, paramNodes);
    }

    private Method getBestMatchingArgTypeMethod(ArrayNode paramNodes, int numParams, Set<Method> matchedMethods) {
        if (matchedMethods.size() == 1 || numParams == 0) {
            return matchedMethods.iterator().next();
        }
        Method bestMethod = null;
        int mostMatches = Integer.MIN_VALUE;
        for (Method method : matchedMethods) {
            List<Class<?>> parameterTypes = ReflectionUtil.getParameterTypes(method);
            int numMatches = this.getNumArgTypeMatches(paramNodes, numParams, parameterTypes);
            if (!this.hasMoreMatches(mostMatches, numMatches)) continue;
            mostMatches = numMatches;
            bestMethod = method;
        }
        return bestMethod;
    }

    private AMethodWithItsArgs findBestMethodForVarargs(Set<Method> methods, JsonNode paramsNode) {
        for (Method method : methods) {
            if (method.getParameterTypes().length != 1 || !method.isVarArgs()) continue;
            return new AMethodWithItsArgs(method, paramsNode);
        }
        return null;
    }

    private int getNumArgTypeMatches(ArrayNode paramNodes, int numParams, List<Class<?>> parameterTypes) {
        int numMatches = 0;
        for (int i = 0; i < parameterTypes.size() && i < numParams; ++i) {
            if (!this.isMatchingType(paramNodes.get(i), parameterTypes.get(i))) continue;
            ++numMatches;
        }
        return numMatches;
    }

    private Set<Method> collectMethodsMatchingParamCount(Set<Method> methods, int paramCount, int bestParamNumDiff) {
        HashSet<Method> matchedMethods = new HashSet<Method>();
        for (Method method : methods) {
            Class<?>[] paramTypes = method.getParameterTypes();
            int paramNumDiff = paramTypes.length - paramCount;
            if (!this.hasLessOrEqualAbsParamDiff(bestParamNumDiff, paramNumDiff) || !this.acceptParamCount(paramNumDiff)) continue;
            if (this.hasLessAbsParamDiff(bestParamNumDiff, paramNumDiff)) {
                matchedMethods.clear();
            }
            matchedMethods.add(method);
            bestParamNumDiff = paramNumDiff;
        }
        return matchedMethods;
    }

    private boolean hasLessAbsParamDiff(int bestParamNumDiff, int paramNumDiff) {
        return Math.abs(paramNumDiff) < Math.abs(bestParamNumDiff);
    }

    private boolean acceptParamCount(int paramNumDiff) {
        return paramNumDiff == 0 || this.acceptNonExactParam(paramNumDiff);
    }

    private boolean acceptNonExactParam(int paramNumDiff) {
        return this.acceptMoreParam(paramNumDiff) || this.acceptLessParam(paramNumDiff);
    }

    private boolean acceptLessParam(int paramNumDiff) {
        return this.allowLessParams && paramNumDiff > 0;
    }

    private boolean acceptMoreParam(int paramNumDiff) {
        return this.allowExtraParams && paramNumDiff < 0;
    }

    private boolean hasLessOrEqualAbsParamDiff(int bestParamNumDiff, int paramNumDiff) {
        return Math.abs(paramNumDiff) <= Math.abs(bestParamNumDiff);
    }

    private AMethodWithItsArgs findBestMethodUsingParamNames(Set<Method> methods, Set<String> paramNames, ObjectNode paramNodes) {
        ParameterCount max = new ParameterCount();
        for (Method method : methods) {
            ParameterCount parStat;
            List<Class<?>> parameterTypes = ReflectionUtil.getParameterTypes(method);
            int typeNameCountDiff = parameterTypes.size() - paramNames.size();
            if (!this.acceptParamCount(typeNameCountDiff) || !this.acceptParamCount((parStat = new ParameterCount(paramNames, paramNodes, parameterTypes, method)).nameCount - paramNames.size()) || !this.hasMoreMatches(max.nameCount, parStat.nameCount) && (parStat.nameCount != max.nameCount || !this.hasMoreMatches(max.typeCount, parStat.typeCount))) continue;
            max = parStat;
        }
        if (max.method == null) {
            return null;
        }
        return new AMethodWithItsArgs(max.method, paramNames, max.allNames, paramNodes);
    }

    private boolean hasMoreMatches(int maxMatchingParams, int numMatchingParams) {
        return numMatchingParams > maxMatchingParams;
    }

    private boolean missingAnnotation(JsonRpcParam name) {
        return name == null;
    }

    private boolean isMatchingType(JsonNode node, Class<?> type) {
        if (node.isNull()) {
            return true;
        }
        if (node.isTextual()) {
            return String.class.isAssignableFrom(type);
        }
        if (node.isNumber()) {
            return this.isNumericAssignable(type);
        }
        if (node.isArray() && type.isArray()) {
            return node.size() > 0 && this.isMatchingType(node.get(0), type.getComponentType());
        }
        if (node.isArray()) {
            return type.isArray() || Collection.class.isAssignableFrom(type);
        }
        if (node.isBinary()) {
            return this.byteOrCharAssignable(type);
        }
        if (node.isBoolean()) {
            return Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type);
        }
        if (node.isObject() || node.isPojo()) {
            return !type.isPrimitive() && !String.class.isAssignableFrom(type) && !Number.class.isAssignableFrom(type) && !Boolean.class.isAssignableFrom(type);
        }
        return false;
    }

    private boolean byteOrCharAssignable(Class<?> type) {
        return byte[].class.isAssignableFrom(type) || Byte[].class.isAssignableFrom(type) || char[].class.isAssignableFrom(type) || Character[].class.isAssignableFrom(type);
    }

    private boolean isNumericAssignable(Class<?> type) {
        return Number.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type);
    }

    private ErrorResolver.JsonError writeAndFlushValueError(OutputStream output, ErrorObjectWithJsonError value) throws IOException {
        logger.debug("failed {}", (Object)value);
        this.writeAndFlushValue(output, (JsonNode)value.node);
        return value.error;
    }

    private void writeAndFlushValue(OutputStream output, JsonNode value) throws IOException {
        if (value == null) {
            return;
        }
        logger.debug("Response: {}", (Object)value);
        this.mapper.writeValue((OutputStream)new NoCloseOutputStream(output), (Object)value);
        output.write(10);
    }

    private Object parseId(JsonNode node) {
        if (this.isNullNodeOrValue(node)) {
            return null;
        }
        if (node.isDouble()) {
            return node.asDouble();
        }
        if (node.isFloatingPointNumber()) {
            return node.asDouble();
        }
        if (node.isInt()) {
            return node.asInt();
        }
        if (node.isLong()) {
            return node.asLong();
        }
        if (node.isIntegralNumber()) {
            return node.asInt();
        }
        if (node.isTextual()) {
            return node.asText();
        }
        throw new IllegalArgumentException("Unknown id type");
    }

    private boolean isNullNodeOrValue(JsonNode node) {
        return node == null || node.isNull();
    }

    public void setBackwardsCompatible(boolean backwardsCompatible) {
        this.backwardsCompatible = backwardsCompatible;
    }

    public void setRethrowExceptions(boolean rethrowExceptions) {
        this.rethrowExceptions = rethrowExceptions;
    }

    public void setAllowExtraParams(boolean allowExtraParams) {
        this.allowExtraParams = allowExtraParams;
    }

    public void setAllowLessParams(boolean allowLessParams) {
        this.allowLessParams = allowLessParams;
    }

    public void setErrorResolver(ErrorResolver errorResolver) {
        this.errorResolver = errorResolver;
    }

    public void setInvocationListener(InvocationListener invocationListener) {
        this.invocationListener = invocationListener;
    }

    public void setHttpStatusCodeProvider(HttpStatusCodeProvider httpStatusCodeProvider) {
        this.httpStatusCodeProvider = httpStatusCodeProvider;
    }

    public void setConvertedParameterTransformer(ConvertedParameterTransformer convertedParameterTransformer) {
        this.convertedParameterTransformer = convertedParameterTransformer;
    }

    public void setShouldLogInvocationErrors(boolean shouldLogInvocationErrors) {
        this.shouldLogInvocationErrors = shouldLogInvocationErrors;
    }

    public void setBatchExecutorService(ExecutorService batchExecutorService) {
        this.batchExecutorService = batchExecutorService;
    }

    public void setParallelBatchProcessingTimeout(long parallelBatchProcessingTimeout) {
        this.parallelBatchProcessingTimeout = parallelBatchProcessingTimeout;
    }

    public List<JsonRpcInterceptor> getInterceptorList() {
        return this.interceptorList;
    }

    public void setInterceptorList(List<JsonRpcInterceptor> interceptorList) {
        if (interceptorList == null) {
            throw new IllegalArgumentException("Interceptors list can't be null");
        }
        this.interceptorList = interceptorList;
    }

    static {
        JsonRpcBasicServer.loadAnnotationSupportEngine();
    }

    private class ParameterCount {
        private final int typeCount;
        private final int nameCount;
        private final List<JsonRpcParam> allNames;
        private final Method method;

        public ParameterCount(Set<String> paramNames, ObjectNode paramNodes, List<Class<?>> parameterTypes, Method method) {
            this.allNames = this.getAnnotatedParameterNames(method);
            this.method = method;
            int typeCount = 0;
            int nameCount = 0;
            int at = 0;
            for (JsonRpcParam name : this.allNames) {
                if (JsonRpcBasicServer.this.missingAnnotation(name)) continue;
                String paramName = name.value();
                boolean hasParamName = paramNames.contains(paramName);
                if (hasParamName) {
                    ++nameCount;
                }
                if (hasParamName && JsonRpcBasicServer.this.isMatchingType(paramNodes.get(paramName), parameterTypes.get(at))) {
                    ++typeCount;
                }
                ++at;
            }
            this.typeCount = typeCount;
            this.nameCount = nameCount;
        }

        private List<JsonRpcParam> getAnnotatedParameterNames(Method method) {
            ArrayList<JsonRpcParam> parameterNames = new ArrayList<JsonRpcParam>();
            for (List<? extends Annotation> list : this.getWebParameterAnnotations(method)) {
                if (list.isEmpty()) continue;
                parameterNames.add(this.createNewJsonRcpParamType(list.get(0)));
            }
            for (List<Annotation> list : this.getJsonRpcParamAnnotations(method)) {
                if (list.isEmpty()) continue;
                parameterNames.add((JsonRpcParam)list.get(0));
            }
            return parameterNames;
        }

        private List<? extends List<? extends Annotation>> getWebParameterAnnotations(Method method) {
            if (WEB_PARAM_ANNOTATION_CLASS == null) {
                return new ArrayList();
            }
            return ReflectionUtil.getParameterAnnotations(method, WEB_PARAM_ANNOTATION_CLASS);
        }

        private JsonRpcParam createNewJsonRcpParamType(final Annotation annotation) {
            return new JsonRpcParam(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return JsonRpcParam.class;
                }

                @Override
                public String value() {
                    try {
                        return (String)WEB_PARAM_NAME_METHOD.invoke((Object)annotation, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }

        private List<List<JsonRpcParam>> getJsonRpcParamAnnotations(Method method) {
            return ReflectionUtil.getParameterAnnotations(method, JsonRpcParam.class);
        }

        public ParameterCount() {
            this.typeCount = -1;
            this.nameCount = -1;
            this.allNames = null;
            this.method = null;
        }

        public int getTypeCount() {
            return this.typeCount;
        }

        public int getNameCount() {
            return this.nameCount;
        }
    }

    private static class InvokeListenerHandler
    implements AutoCloseable {
        private final long startMs = System.currentTimeMillis();
        private final AMethodWithItsArgs methodArgs;
        private final InvocationListener invocationListener;
        public Throwable error = null;
        public JsonNode result = null;

        public InvokeListenerHandler(AMethodWithItsArgs methodArgs, InvocationListener invocationListener) {
            this.methodArgs = methodArgs;
            this.invocationListener = invocationListener;
            if (this.invocationListener != null) {
                this.invocationListener.willInvoke(methodArgs.method, methodArgs.arguments);
            }
        }

        @Override
        public void close() {
            if (this.invocationListener != null) {
                this.invocationListener.didInvoke(this.methodArgs.method, this.methodArgs.arguments, this.result, this.error, System.currentTimeMillis() - this.startMs);
            }
        }
    }

    private static class AMethodWithItsArgs {
        private final List<JsonNode> arguments = new ArrayList<JsonNode>();
        private final Method method;

        public AMethodWithItsArgs(Method method, int paramCount, ArrayNode paramNodes) {
            this(method);
            this.collectArgumentsBasedOnCount(method, paramCount, paramNodes);
        }

        public AMethodWithItsArgs(Method method) {
            this.method = method;
        }

        private void collectArgumentsBasedOnCount(Method method, int paramCount, ArrayNode paramNodes) {
            int numParameters = method.getParameterTypes().length;
            for (int i = 0; i < numParameters; ++i) {
                if (i < paramCount) {
                    this.addArgument(paramNodes.get(i));
                    continue;
                }
                this.addArgument((JsonNode)NullNode.getInstance());
            }
        }

        public AMethodWithItsArgs(Method method, Set<String> paramNames, List<JsonRpcParam> allNames, ObjectNode paramNodes) {
            this(method);
            this.collectArgumentsBasedOnName(method, paramNames, allNames, paramNodes);
        }

        public AMethodWithItsArgs(Method method, JsonNode jsonNode) {
            this(method);
            this.collectVarargsFromNode(jsonNode);
        }

        private void collectArgumentsBasedOnName(Method method, Set<String> paramNames, List<JsonRpcParam> allNames, ObjectNode paramNodes) {
            Class<?>[] types = method.getParameterTypes();
            int numParameters = types.length;
            for (int i = 0; i < numParameters; ++i) {
                JsonRpcParam param = allNames.get(i);
                if (param != null && paramNames.contains(param.value())) {
                    if (types[i].isArray() && method.isVarArgs() && numParameters == 1) {
                        this.collectVarargsFromNode(paramNodes.get(param.value()));
                        continue;
                    }
                    this.addArgument(paramNodes.get(param.value()));
                    continue;
                }
                this.addArgument((JsonNode)NullNode.getInstance());
            }
        }

        private void collectVarargsFromNode(JsonNode node) {
            if (node.isArray()) {
                ArrayNode arrayNode = (ArrayNode)node;
                for (int i = 0; i < node.size(); ++i) {
                    this.addArgument(arrayNode.get(i));
                }
            }
            if (node.isObject()) {
                ObjectNode objectNode = (ObjectNode)node;
                Iterator items = objectNode.fields();
                while (items.hasNext()) {
                    Map.Entry item = (Map.Entry)items.next();
                    ObjectNode name = JsonNodeFactory.instance.objectNode().put((String)item.getKey(), (String)item.getKey());
                    this.addArgument(name.get((String)item.getKey()));
                    this.addArgument((JsonNode)item.getValue());
                }
            }
        }

        public void addArgument(JsonNode argumentJsonNode) {
            this.arguments.add(argumentJsonNode);
        }
    }

    private static class ErrorObjectWithJsonError {
        private final ObjectNode node;
        private final ErrorResolver.JsonError error;

        public ErrorObjectWithJsonError(ObjectNode node, ErrorResolver.JsonError error) {
            this.node = node;
            this.error = error;
        }

        public String toString() {
            return "ErrorObjectWithJsonError{node=" + this.node + ", error=" + this.error + '}';
        }
    }
}

