/*
 * Decompiled with CFR 0.152.
 */
package org.berndpruenster.netlayer.tor;

import java.io.File;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.berndpruenster.netlayer.tor.WriteObserver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/berndpruenster/netlayer/tor/NativeWatchObserver;", "Lorg/berndpruenster/netlayer/tor/WriteObserver;", "fileToWatch", "Ljava/io/File;", "(Ljava/io/File;)V", "lastDigest", "", "messageDigestCreator", "Ljava/security/MessageDigest;", "poll", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "tor.native"})
public final class NativeWatchObserver
implements WriteObserver {
    private byte[] lastDigest;
    private MessageDigest messageDigestCreator;
    private final File fileToWatch;

    @Override
    public boolean poll(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        boolean result = false;
        for (long remaining = unit.toMillis(timeout); remaining > 0L && !result; remaining -= (long)250) {
            byte[] byArray;
            Thread.sleep(250L);
            byte[] byArray2 = this.lastDigest;
            Intrinsics.checkExpressionValueIsNotNull((Object)this.messageDigestCreator.digest(FilesKt.readBytes((File)this.fileToWatch)), (String)"messageDigestCreator.dig\u2026(fileToWatch.readBytes())");
            boolean bl = false;
            result = !Arrays.equals(byArray2, byArray);
        }
        return result;
    }

    public NativeWatchObserver(@NotNull File fileToWatch) {
        Intrinsics.checkParameterIsNotNull((Object)fileToWatch, (String)"fileToWatch");
        this.fileToWatch = fileToWatch;
        if (!this.fileToWatch.exists()) {
            throw (Throwable)new RuntimeException(this.fileToWatch + " does not exist");
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        Intrinsics.checkExpressionValueIsNotNull((Object)messageDigest, (String)"MessageDigest.getInstance(\"SHA-256\")");
        this.messageDigestCreator = messageDigest;
        byte[] byArray = this.messageDigestCreator.digest(FilesKt.readBytes((File)this.fileToWatch));
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"messageDigestCreator.dig\u2026(fileToWatch.readBytes())");
        this.lastDigest = byArray;
    }
}

