/*
 * Decompiled with CFR 0.152.
 */
package com.runjva.sourceforge.jsocks.protocol;

import com.runjva.sourceforge.jsocks.protocol.ProxyMessage;
import com.runjva.sourceforge.jsocks.protocol.SocksException;
import com.runjva.sourceforge.jsocks.protocol.SocksProxyBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocksSocket
extends Socket {
    protected SocksProxyBase proxy;
    protected String localHost;
    protected String remoteHost;
    protected InetAddress localIP;
    protected InetAddress remoteIP;
    protected int localPort;
    protected int remotePort;
    private Socket directSock = null;
    private Logger log = LoggerFactory.getLogger(SocksSocket.class);

    public SocksSocket(String host, int port) throws SocksException, UnknownHostException {
        this(SocksProxyBase.defaultProxy, host, port);
    }

    public SocksSocket(SocksProxyBase p, String host, int port) throws SocksException, UnknownHostException {
        if (p == null) {
            throw new SocksException(65536);
        }
        this.proxy = p.copy();
        this.remoteHost = host;
        this.remotePort = port;
        if (this.proxy.isDirect(host)) {
            this.remoteIP = InetAddress.getByName(host);
            this.doDirect();
        } else {
            this.processReply(this.proxy.connect(host, port));
        }
    }

    public SocksSocket(InetAddress ip, int port) throws SocksException {
        this(SocksProxyBase.defaultProxy, ip, port);
    }

    public SocksSocket(SocksProxyBase p, InetAddress ip, int port) throws SocksException {
        if (p == null) {
            throw new SocksException(65536);
        }
        this.proxy = p.copy();
        this.remoteIP = ip;
        this.remotePort = port;
        this.remoteHost = ip.getHostName();
        if (this.proxy.isDirect(this.remoteIP)) {
            this.doDirect();
        } else {
            this.processReply(this.proxy.connect(ip, port));
        }
    }

    protected SocksSocket(String host, int port, SocksProxyBase proxy) {
        this.remotePort = port;
        this.proxy = proxy;
        this.localIP = proxy.proxySocket.getLocalAddress();
        this.localPort = proxy.proxySocket.getLocalPort();
        this.remoteHost = host;
    }

    protected SocksSocket(InetAddress ip, int port, SocksProxyBase proxy) {
        this.remoteIP = ip;
        this.remotePort = port;
        this.proxy = proxy;
        this.localIP = proxy.proxySocket.getLocalAddress();
        this.localPort = proxy.proxySocket.getLocalPort();
        this.remoteHost = this.remoteIP.getHostName();
    }

    @Override
    public void close() throws IOException {
        if (this.proxy != null) {
            this.proxy.endSession();
        }
        this.proxy = null;
    }

    @Override
    public InputStream getInputStream() {
        return this.proxy.in;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.proxy.out;
    }

    @Override
    public int getPort() {
        return this.remotePort;
    }

    public String getHost() {
        return this.remoteHost;
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.remoteIP == null) {
            try {
                this.remoteIP = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        return this.remoteIP;
    }

    @Override
    public int getLocalPort() {
        return this.localPort;
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.localIP == null) {
            try {
                this.localIP = InetAddress.getByName(this.localHost);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        return this.localIP;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    @Override
    public void setSoLinger(boolean on, int val) throws SocketException {
        this.proxy.proxySocket.setSoLinger(on, val);
    }

    public int getSoLinger(int timeout) throws SocketException {
        return this.proxy.proxySocket.getSoLinger();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.proxy.proxySocket.setSoTimeout(timeout);
    }

    public int getSoTimeout(int timeout) throws SocketException {
        return this.proxy.proxySocket.getSoTimeout();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.proxy.proxySocket.setTcpNoDelay(on);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.proxy.proxySocket.getTcpNoDelay();
    }

    @Override
    public String toString() {
        if (this.directSock != null) {
            return "Direct connection:" + this.directSock;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Proxy:");
        sb.append(this.proxy);
        sb.append(";");
        sb.append("addr:");
        sb.append(this.remoteHost);
        sb.append(",port:");
        sb.append(this.remotePort);
        sb.append(",localport:");
        sb.append(this.localPort);
        return sb.toString();
    }

    private void processReply(ProxyMessage reply) throws SocksException {
        this.localPort = reply.port;
        if (reply.host.equals("0.0.0.0")) {
            this.localIP = this.proxy.proxyIP;
            this.localHost = this.localIP.getHostName();
        } else {
            this.localHost = reply.host;
            this.localIP = reply.ip;
        }
    }

    private void doDirect() throws SocksException {
        try {
            this.log.debug("IP: {}_{}", (Object)this.remoteIP, (Object)this.remotePort);
            this.directSock = new Socket(this.remoteIP, this.remotePort);
            this.proxy.out = this.directSock.getOutputStream();
            this.proxy.in = this.directSock.getInputStream();
            this.proxy.proxySocket = this.directSock;
            this.localIP = this.directSock.getLocalAddress();
            this.localPort = this.directSock.getLocalPort();
        }
        catch (IOException io_ex) {
            int errCode = 458752;
            throw new SocksException(458752, "Direct connect failed:", io_ex);
        }
    }
}

