/*
 * Decompiled with CFR 0.152.
 */
package com.runjva.sourceforge.jsocks.protocol;

import com.runjva.sourceforge.jsocks.protocol.InetRange;
import com.runjva.sourceforge.jsocks.protocol.ProxyMessage;
import com.runjva.sourceforge.jsocks.protocol.Socks4Proxy;
import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import com.runjva.sourceforge.jsocks.protocol.SocksException;
import com.runjva.sourceforge.jsocks.protocol.SocksSocket;
import com.runjva.sourceforge.jsocks.protocol.UserPasswordAuthentication;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public abstract class SocksProxyBase {
    protected InetRange directHosts = new InetRange();
    protected InetAddress proxyIP = null;
    protected String proxyHost = null;
    protected int proxyPort;
    protected Socket proxySocket = null;
    protected InputStream in;
    protected OutputStream out;
    protected int version;
    protected SocksProxyBase chainProxy = null;
    protected static SocksProxyBase defaultProxy = null;
    public static final int SOCKS_SUCCESS = 0;
    public static final int SOCKS_FAILURE = 1;
    public static final int SOCKS_BADCONNECT = 2;
    public static final int SOCKS_BADNETWORK = 3;
    public static final int SOCKS_HOST_UNREACHABLE = 4;
    public static final int SOCKS_CONNECTION_REFUSED = 5;
    public static final int SOCKS_TTL_EXPIRE = 6;
    public static final int SOCKS_CMD_NOT_SUPPORTED = 7;
    public static final int SOCKS_ADDR_NOT_SUPPORTED = 8;
    public static final int SOCKS_NO_PROXY = 65536;
    public static final int SOCKS_PROXY_NO_CONNECT = 131072;
    public static final int SOCKS_PROXY_IO_ERROR = 196608;
    public static final int SOCKS_AUTH_NOT_SUPPORTED = 262144;
    public static final int SOCKS_AUTH_FAILURE = 327680;
    public static final int SOCKS_JUST_ERROR = 393216;
    public static final int SOCKS_DIRECT_FAILED = 458752;
    public static final int SOCKS_METHOD_NOTSUPPORTED = 524288;
    static final int SOCKS_CMD_CONNECT = 1;
    static final int SOCKS_CMD_BIND = 2;
    static final int SOCKS_CMD_UDP_ASSOCIATE = 3;

    SocksProxyBase(SocksProxyBase chainProxy, String proxyHost, int proxyPort) throws UnknownHostException {
        this.chainProxy = chainProxy;
        this.proxyHost = proxyHost;
        if (chainProxy == null) {
            this.proxyIP = InetAddress.getByName(proxyHost);
        }
        this.proxyPort = proxyPort;
    }

    SocksProxyBase(String proxyHost, int proxyPort) throws UnknownHostException {
        this(null, proxyHost, proxyPort);
    }

    SocksProxyBase(SocksProxyBase chainProxy, InetAddress proxyIP, int proxyPort) {
        this.chainProxy = chainProxy;
        this.proxyIP = proxyIP;
        this.proxyPort = proxyPort;
    }

    SocksProxyBase(InetAddress proxyIP, int proxyPort) {
        this(null, proxyIP, proxyPort);
    }

    SocksProxyBase(SocksProxyBase p) {
        this.proxyIP = p.proxyIP;
        this.proxyPort = p.proxyPort;
        this.version = p.version;
        this.directHosts = p.directHosts;
    }

    public int getPort() {
        return this.proxyPort;
    }

    public InetAddress getInetAddress() {
        return this.proxyIP;
    }

    public void addDirect(InetAddress ip) {
        this.directHosts.add(ip);
    }

    public boolean addDirect(String host) {
        return this.directHosts.add(host);
    }

    public void addDirect(InetAddress from, InetAddress to) {
        this.directHosts.add(from, to);
    }

    public void setDirect(InetRange ir) {
        this.directHosts = ir;
    }

    public InetRange getDirect() {
        return this.directHosts;
    }

    public boolean isDirect(String host) {
        return this.directHosts.contains(host);
    }

    public boolean isDirect(InetAddress host) {
        return this.directHosts.contains(host);
    }

    public void setChainProxy(SocksProxyBase chainProxy) {
        this.chainProxy = chainProxy;
    }

    public SocksProxyBase getChainProxy() {
        return this.chainProxy;
    }

    public String toString() {
        return "" + this.proxyIP.getHostName() + ":" + this.proxyPort + "\tVersion " + this.version;
    }

    public static void setDefaultProxy(String hostName, int port, String user) throws UnknownHostException {
        defaultProxy = new Socks4Proxy(hostName, port, user);
    }

    public static void setDefaultProxy(InetAddress ipAddress, int port, String user) {
        defaultProxy = new Socks4Proxy(ipAddress, port, user);
    }

    public static void setDefaultProxy(String hostName, int port) throws UnknownHostException {
        defaultProxy = new Socks5Proxy(hostName, port);
    }

    public static void setDefaultProxy(InetAddress ipAddress, int port) {
        defaultProxy = new Socks5Proxy(ipAddress, port);
    }

    public static void setDefaultProxy(SocksProxyBase p) {
        defaultProxy = p;
    }

    public static SocksProxyBase getDefaultProxy() {
        return defaultProxy;
    }

    public static SocksProxyBase parseProxy(String proxy_entry) {
        SocksProxyBase proxy;
        int proxy_port = 1080;
        String proxy_user = null;
        String proxy_password = null;
        StringTokenizer st = new StringTokenizer(proxy_entry, ":");
        if (st.countTokens() < 1) {
            return null;
        }
        String proxy_host = st.nextToken();
        if (st.hasMoreTokens()) {
            try {
                proxy_port = Integer.parseInt(st.nextToken().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (st.hasMoreTokens()) {
            proxy_user = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            proxy_password = st.nextToken();
        }
        try {
            if (proxy_user == null) {
                proxy = new Socks5Proxy(proxy_host, proxy_port);
            } else if (proxy_password == null) {
                proxy = new Socks4Proxy(proxy_host, proxy_port, proxy_user);
            } else {
                proxy = new Socks5Proxy(proxy_host, proxy_port);
                UserPasswordAuthentication upa = new UserPasswordAuthentication(proxy_user, proxy_password);
                ((Socks5Proxy)proxy).setAuthenticationMethod(2, upa);
            }
        }
        catch (UnknownHostException uhe) {
            return null;
        }
        return proxy;
    }

    protected void startSession() throws SocksException {
        try {
            this.proxySocket = this.chainProxy == null ? new Socket(this.proxyIP, this.proxyPort) : (this.proxyIP != null ? new SocksSocket(this.chainProxy, this.proxyIP, this.proxyPort) : new SocksSocket(this.chainProxy, this.proxyHost, this.proxyPort));
            this.in = this.proxySocket.getInputStream();
            this.out = this.proxySocket.getOutputStream();
        }
        catch (SocksException se) {
            throw se;
        }
        catch (IOException io_ex) {
            throw new SocksException(196608, "" + io_ex);
        }
    }

    protected abstract SocksProxyBase copy();

    protected abstract ProxyMessage formMessage(int var1, InetAddress var2, int var3);

    protected abstract ProxyMessage formMessage(int var1, String var2, int var3) throws UnknownHostException;

    protected abstract ProxyMessage formMessage(InputStream var1) throws SocksException, IOException;

    protected ProxyMessage connect(InetAddress ip, int port) throws SocksException {
        try {
            this.startSession();
            ProxyMessage request = this.formMessage(1, ip, port);
            return this.exchange(request);
        }
        catch (SocksException se) {
            this.endSession();
            throw se;
        }
    }

    protected ProxyMessage connect(String host, int port) throws UnknownHostException, SocksException {
        try {
            this.startSession();
            ProxyMessage request = this.formMessage(1, host, port);
            return this.exchange(request);
        }
        catch (SocksException se) {
            this.endSession();
            throw se;
        }
    }

    protected ProxyMessage bind(InetAddress ip, int port) throws SocksException {
        try {
            this.startSession();
            ProxyMessage request = this.formMessage(2, ip, port);
            return this.exchange(request);
        }
        catch (SocksException se) {
            this.endSession();
            throw se;
        }
    }

    protected ProxyMessage bind(String host, int port) throws UnknownHostException, SocksException {
        try {
            this.startSession();
            ProxyMessage request = this.formMessage(2, host, port);
            return this.exchange(request);
        }
        catch (SocksException se) {
            this.endSession();
            throw se;
        }
    }

    protected ProxyMessage accept() throws IOException, SocksException {
        ProxyMessage msg;
        try {
            msg = this.formMessage(this.in);
        }
        catch (InterruptedIOException iioe) {
            throw iioe;
        }
        catch (IOException io_ex) {
            this.endSession();
            throw new SocksException(196608, "While Trying accept:" + io_ex);
        }
        return msg;
    }

    protected ProxyMessage udpAssociate(InetAddress ip, int port) throws SocksException {
        try {
            this.startSession();
            ProxyMessage request = this.formMessage(3, ip, port);
            if (request != null) {
                return this.exchange(request);
            }
        }
        catch (SocksException se) {
            this.endSession();
            throw se;
        }
        this.endSession();
        throw new SocksException(524288, "This version of proxy does not support UDP associate, use version 5");
    }

    protected ProxyMessage udpAssociate(String host, int port) throws UnknownHostException, SocksException {
        try {
            this.startSession();
            ProxyMessage request = this.formMessage(3, host, port);
            if (request != null) {
                return this.exchange(request);
            }
        }
        catch (SocksException se) {
            this.endSession();
            throw se;
        }
        this.endSession();
        throw new SocksException(524288, "This version of proxy does not support UDP associate, use version 5");
    }

    protected void endSession() {
        try {
            if (this.proxySocket != null) {
                this.proxySocket.close();
            }
            this.proxySocket = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void sendMsg(ProxyMessage msg) throws SocksException, IOException {
        msg.write(this.out);
    }

    protected ProxyMessage readMsg() throws SocksException, IOException {
        return this.formMessage(this.in);
    }

    protected ProxyMessage exchange(ProxyMessage request) throws SocksException {
        ProxyMessage reply;
        try {
            request.write(this.out);
            reply = this.formMessage(this.in);
        }
        catch (SocksException s_ex) {
            throw s_ex;
        }
        catch (IOException ioe) {
            throw new SocksException(196608, "" + ioe);
        }
        return reply;
    }
}

