/*
 * Decompiled with CFR 0.152.
 */
package com.runjva.sourceforge.jsocks.protocol;

import com.runjva.sourceforge.jsocks.protocol.InetRange;
import com.runjva.sourceforge.jsocks.protocol.Socks4Proxy;
import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import com.runjva.sourceforge.jsocks.protocol.SocksProxyBase;
import com.runjva.sourceforge.jsocks.protocol.UserPasswordAuthentication;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.UnknownHostException;

public class SocksDialog
extends Dialog
implements WindowListener,
ItemListener,
ActionListener,
Runnable {
    private static final long serialVersionUID = 1L;
    TextField host_text;
    TextField port_text;
    TextField user_text;
    TextField password_text;
    TextField direct_text;
    Button add_button;
    Button remove_button;
    Button cancel_button;
    Button ok_button;
    Button dismiss_button;
    List direct_list;
    Checkbox socks4radio;
    Checkbox socks5radio;
    Checkbox none_check;
    Checkbox up_check;
    Checkbox gssapi_check;
    Dialog warning_dialog;
    Label warning_label;
    String host;
    String user;
    String password;
    int port;
    Thread net_thread = null;
    CheckboxGroup socks_group = new CheckboxGroup();
    SocksProxyBase proxy;
    InetRange ir;
    static final int COMMAND_MODE = 0;
    static final int OK_MODE = 1;
    int mode;
    public static boolean useThreads = true;

    public SocksDialog(Frame parent) {
        this(parent, (SocksProxyBase)null);
    }

    public SocksDialog(Frame parent, SocksProxyBase init_proxy) {
        super(parent, "Proxy Configuration", true);
        this.warning_dialog = new Dialog(parent, "Warning", true);
        this.guiInit();
        this.setResizable(false);
        this.addWindowListener(this);
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof Button) {
                ((Button)comps[i]).addActionListener(this);
                continue;
            }
            if (comps[i] instanceof TextField) {
                ((TextField)comps[i]).addActionListener(this);
                continue;
            }
            if (!(comps[i] instanceof Checkbox)) continue;
            ((Checkbox)comps[i]).addItemListener(this);
        }
        this.proxy = init_proxy;
        if (this.proxy != null) {
            this.doInit(this.proxy);
        } else {
            this.ir = new InetRange();
        }
        this.dismiss_button.addActionListener(this);
        this.warning_dialog.addWindowListener(this);
    }

    public SocksProxyBase getProxy() {
        this.mode = 0;
        this.pack();
        this.setVisible(true);
        return this.proxy;
    }

    public SocksProxyBase getProxy(SocksProxyBase p) {
        if (p != null) {
            this.doInit(p);
        }
        this.mode = 0;
        this.pack();
        this.setVisible(true);
        return this.proxy;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Window source = e.getWindow();
        if (source == this) {
            this.onCancel();
        } else if (source == this.warning_dialog) {
            this.onDismiss();
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.cancel_button) {
            this.onCancel();
        } else if (source == this.add_button || source == this.direct_text) {
            this.onAdd();
        } else if (source == this.remove_button) {
            this.onRemove();
        } else if (source == this.dismiss_button) {
            this.onDismiss();
        } else if (source == this.ok_button || source instanceof TextField) {
            this.onOK();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object source = ie.getSource();
        if (source == this.socks5radio || source == this.socks4radio) {
            this.onSocksChange();
        } else if (source == this.up_check) {
            this.onUPChange();
        }
    }

    @Override
    public void run() {
        if (!this.initProxy()) {
            if (this.mode != 1) {
                return;
            }
            if (this.net_thread != Thread.currentThread()) {
                return;
            }
            this.mode = 0;
            this.warning_label.setText("Look up failed.");
            this.warning_label.invalidate();
            return;
        }
        while (!this.warning_dialog.isShowing()) {
        }
        this.warning_dialog.dispose();
    }

    private void onOK() {
        this.host = this.host_text.getText().trim();
        this.user = this.user_text.getText();
        this.password = this.password_text.getText();
        if (this.host.length() == 0) {
            this.warn("Proxy host is not set!");
            return;
        }
        if (this.socks_group.getSelectedCheckbox() == this.socks4radio) {
            if (this.user.length() == 0) {
                this.warn("User name is not set");
                return;
            }
        } else if (this.up_check.getState()) {
            if (this.user.length() == 0) {
                this.warn("User name is not set.");
                return;
            }
            if (this.password.length() == 0) {
                this.warn("Password is not set.");
                return;
            }
        } else if (!this.none_check.getState()) {
            this.warn("Please select at least one Authentication Method.");
            return;
        }
        try {
            this.port = Integer.parseInt(this.port_text.getText());
        }
        catch (NumberFormatException nfe) {
            this.warn("Proxy port is invalid!");
            return;
        }
        this.mode = 1;
        if (useThreads) {
            this.net_thread = new Thread(this);
            this.net_thread.start();
            this.info("Looking up host: " + this.host);
        } else if (!this.initProxy()) {
            this.warn("Proxy host is invalid.");
            this.mode = 0;
        }
        if (this.mode == 1) {
            this.dispose();
        }
    }

    private void onCancel() {
        this.proxy = null;
        this.dispose();
    }

    private void onAdd() {
        String s = this.direct_text.getText();
        s.trim();
        if (s.length() == 0) {
            return;
        }
        String[] direct_hosts = this.direct_list.getItems();
        for (int i = 0; i < direct_hosts.length; ++i) {
            if (!direct_hosts[i].equals(s)) continue;
            return;
        }
        this.direct_list.add(s);
        this.ir.add(s);
    }

    private void onRemove() {
        int index = this.direct_list.getSelectedIndex();
        if (index < 0) {
            return;
        }
        this.ir.remove(this.direct_list.getItem(index));
        this.direct_list.remove(index);
        this.direct_list.select(index);
    }

    private void onSocksChange() {
        Checkbox selected = this.socks_group.getSelectedCheckbox();
        if (selected == this.socks4radio) {
            this.user_text.setEnabled(true);
            this.password_text.setEnabled(false);
            this.none_check.setEnabled(false);
            this.up_check.setEnabled(false);
        } else {
            if (this.up_check.getState()) {
                this.user_text.setEnabled(true);
                this.password_text.setEnabled(true);
            } else {
                this.user_text.setEnabled(false);
                this.password_text.setEnabled(false);
            }
            this.none_check.setEnabled(true);
            this.up_check.setEnabled(true);
        }
    }

    private void onUPChange() {
        if (this.up_check.getState()) {
            this.user_text.setEnabled(true);
            this.password_text.setEnabled(true);
        } else {
            this.user_text.setEnabled(false);
            this.password_text.setEnabled(false);
        }
    }

    private void onDismiss() {
        this.warning_dialog.dispose();
        if (this.mode == 1) {
            this.mode = 0;
            if (this.net_thread != null) {
                this.net_thread.interrupt();
            }
        }
    }

    private void doInit(SocksProxyBase p) {
        if (p.version == 5) {
            UserPasswordAuthentication auth;
            this.socks_group.setSelectedCheckbox(this.socks5radio);
            this.onSocksChange();
            if (((Socks5Proxy)p).getAuthenticationMethod(0) != null) {
                this.none_check.setState(true);
            }
            if ((auth = (UserPasswordAuthentication)((Socks5Proxy)p).getAuthenticationMethod(2)) != null) {
                this.user_text.setText(auth.getUser());
                this.password_text.setText(auth.getPassword());
                this.up_check.setState(true);
                this.onUPChange();
            }
        } else {
            this.socks_group.setSelectedCheckbox(this.socks4radio);
            this.onSocksChange();
            this.user_text.setText(((Socks4Proxy)p).user);
        }
        this.ir = (InetRange)p.directHosts.clone();
        String[] direct_hosts = this.ir.getAll();
        this.direct_list.removeAll();
        for (int i = 0; i < direct_hosts.length; ++i) {
            this.direct_list.add(direct_hosts[i]);
        }
        this.host_text.setText(p.proxyIP.getHostName());
        this.port_text.setText("" + p.proxyPort);
    }

    private boolean initProxy() {
        try {
            if (this.socks_group.getSelectedCheckbox() == this.socks5radio) {
                this.proxy = new Socks5Proxy(this.host, this.port);
                if (this.up_check.getState()) {
                    ((Socks5Proxy)this.proxy).setAuthenticationMethod(2, new UserPasswordAuthentication(this.user, this.password));
                }
                if (!this.none_check.getState()) {
                    ((Socks5Proxy)this.proxy).setAuthenticationMethod(0, null);
                }
            } else {
                this.proxy = new Socks4Proxy(this.host, this.port, this.user);
            }
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        this.proxy.directHosts = this.ir;
        return true;
    }

    private void info(String s) {
        this.msgBox("Info", s);
    }

    private void warn(String s) {
        this.msgBox("Warning", s);
    }

    private void msgBox(String title, String message) {
        this.warning_label.setText(message);
        this.warning_label.invalidate();
        this.warning_dialog.setTitle(title);
        this.warning_dialog.pack();
        this.warning_dialog.setVisible(true);
    }

    void guiInit() {
        GridBagConstraints c = new GridBagConstraints();
        Font font = new Font("Dialog", 0, 12);
        SocksDialog container = this;
        container.setLayout(new GridBagLayout());
        container.setFont(font);
        ((Component)container).setBackground(SystemColor.menu);
        c.insets = new Insets(3, 3, 3, 3);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 12;
        Label label = new Label("Host:");
        container.add((Component)label, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 18;
        this.host_text = new TextField("socks-proxy", 15);
        container.add((Component)this.host_text, c);
        c.gridx = 3;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 12;
        label = new Label("Port:");
        container.add((Component)label, c);
        c.gridx = 4;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 18;
        this.port_text = new TextField("1080", 5);
        container.add((Component)this.port_text, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.anchor = 11;
        this.socks4radio = new Checkbox("Socks4", this.socks_group, false);
        this.socks4radio.setFont(new Font(font.getName(), 1, 14));
        container.add((Component)this.socks4radio, c);
        c.gridx = 3;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 11;
        this.socks5radio = new Checkbox("Socks5", this.socks_group, true);
        this.socks5radio.setFont(new Font(font.getName(), 1, 14));
        container.add((Component)this.socks5radio, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 13;
        label = new Label("User Id:");
        container.add((Component)label, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 18;
        this.user_text = new TextField("", 15);
        this.user_text.setEnabled(false);
        container.add((Component)this.user_text, c);
        c.gridx = 3;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 11;
        label = new Label("Authentication");
        label.setFont(new Font(font.getName(), 1, 14));
        container.add((Component)label, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 13;
        label = new Label("Password:");
        container.add((Component)label, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 18;
        this.password_text = new TextField("", 15);
        this.password_text.setEchoChar('*');
        this.password_text.setEnabled(false);
        container.add((Component)this.password_text, c);
        c.gridx = 3;
        c.gridy = 3;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 18;
        this.none_check = new Checkbox("None", true);
        container.add((Component)this.none_check, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.anchor = 11;
        label = new Label("Direct Hosts");
        label.setFont(new Font(font.getName(), 1, 14));
        container.add((Component)label, c);
        c.gridx = 3;
        c.gridy = 4;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 18;
        this.up_check = new Checkbox("User/Password", false);
        container.add((Component)this.up_check, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 3;
        c.gridheight = 2;
        c.anchor = 18;
        c.fill = 1;
        this.direct_list = new List(3);
        container.add((Component)this.direct_list, c);
        c.gridx = 3;
        c.gridy = 5;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 18;
        this.gssapi_check = new Checkbox("GSSAPI", false);
        this.gssapi_check.setEnabled(false);
        container.add((Component)this.gssapi_check, c);
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.anchor = 18;
        this.direct_text = new TextField("", 25);
        container.add((Component)this.direct_text, c);
        c.gridx = 3;
        c.gridy = 7;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 11;
        this.add_button = new Button("Add");
        container.add((Component)this.add_button, c);
        c.gridx = 3;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 11;
        this.remove_button = new Button("Remove");
        container.add((Component)this.remove_button, c);
        c.gridx = 1;
        c.gridy = 8;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 11;
        this.cancel_button = new Button("Cancel");
        container.add((Component)this.cancel_button, c);
        c.gridx = 0;
        c.gridy = 8;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 18;
        this.ok_button = new Button("OK");
        container.add((Component)this.ok_button, c);
        this.dismiss_button = new Button("Dismiss");
        this.warning_label = new Label("", 1);
        this.warning_label.setFont(new Font("Dialog", 1, 15));
        Panel p = new Panel();
        p.add(this.dismiss_button);
        this.warning_dialog.add((Component)p, "South");
        this.warning_dialog.add((Component)this.warning_label, "Center");
        this.warning_dialog.setResizable(false);
    }
}

