/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jcsv.reader.internal;

import com.googlecode.jcsv.reader.CSVReader;
import com.googlecode.jcsv.reader.CachedCSVReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedCSVReaderImpl<E>
implements CachedCSVReader<E> {
    private final CSVReader<E> reader;
    private final List<E> cachedEntries;
    private int currentIndex;

    public CachedCSVReaderImpl(CSVReader<E> reader) {
        this.reader = reader;
        this.cachedEntries = new ArrayList();
        this.currentIndex = -1;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIndex + 1 >= this.cachedEntries.size()) {
            this.cacheNextEntry();
        }
        return this.currentIndex + 1 < this.cachedEntries.size();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException(String.format("size: %s, index: %s", this.cachedEntries.size(), this.currentIndex + 1));
        }
        ++this.currentIndex;
        return this.cachedEntries.get(this.currentIndex);
    }

    @Override
    public boolean hasPrevious() {
        return this.currentIndex > 0;
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException(String.format("size: %s, index: %s", this.cachedEntries.size(), this.currentIndex - 1));
        }
        --this.currentIndex;
        return this.cachedEntries.get(this.currentIndex);
    }

    @Override
    public int nextIndex() {
        if (this.currentIndex >= this.cachedEntries.size()) {
            this.cacheNextEntry();
        }
        if (this.currentIndex >= this.cachedEntries.size()) {
            return this.cachedEntries.size();
        }
        return this.currentIndex + 1;
    }

    @Override
    public int previousIndex() {
        return this.currentIndex - 1;
    }

    @Override
    public E get(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("i has to be greater 0, but was " + index);
        }
        this.readUntil(index);
        if (this.cachedEntries.size() < index) {
            throw new ArrayIndexOutOfBoundsException(String.format("size: %s, index: %s", this.cachedEntries.size(), index));
        }
        return this.cachedEntries.get(index);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not allowed");
    }

    @Override
    public void set(Object e) {
        throw new UnsupportedOperationException("set not allowed");
    }

    @Override
    public void add(Object e) {
        throw new UnsupportedOperationException("add not allowed");
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private void readUntil(int i) {
        while (this.cacheNextEntry() && this.cachedEntries.size() <= i) {
        }
    }

    private boolean cacheNextEntry() {
        boolean success = false;
        try {
            E entry = this.reader.readNext();
            if (entry != null) {
                this.cachedEntries.add(entry);
                success = true;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return success;
    }
}

