/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jcsv.reader.internal;

import com.googlecode.jcsv.CSVStrategy;
import com.googlecode.jcsv.reader.CSVEntryFilter;
import com.googlecode.jcsv.reader.CSVEntryParser;
import com.googlecode.jcsv.reader.CSVReader;
import com.googlecode.jcsv.reader.CSVTokenizer;
import com.googlecode.jcsv.reader.CachedCSVReader;
import com.googlecode.jcsv.reader.internal.CSVReaderImpl;
import com.googlecode.jcsv.reader.internal.CSVTokenizerImpl;
import com.googlecode.jcsv.reader.internal.CachedCSVReaderImpl;
import com.googlecode.jcsv.reader.internal.DefaultCSVEntryParser;
import com.googlecode.jcsv.util.Builder;
import java.io.Reader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVReaderBuilder<E>
implements Builder<CSVReader<E>> {
    final Reader reader;
    CSVEntryParser<E> entryParser;
    CSVStrategy strategy = CSVStrategy.DEFAULT;
    CSVEntryFilter<E> entryFilter;
    CSVTokenizer tokenizer = new CSVTokenizerImpl();

    public CSVReaderBuilder(Reader reader) {
        this.reader = reader;
    }

    public CSVReaderBuilder<E> strategy(CSVStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public CSVReaderBuilder<E> entryParser(CSVEntryParser<E> entryParser) {
        this.entryParser = entryParser;
        return this;
    }

    public CSVReaderBuilder<E> entryFilter(CSVEntryFilter<E> entryFilter) {
        this.entryFilter = entryFilter;
        return this;
    }

    public CSVReaderBuilder<E> tokenizer(CSVTokenizer tokenizer) {
        this.tokenizer = tokenizer;
        return this;
    }

    @Override
    public CSVReader<E> build() {
        if (this.entryParser == null) {
            throw new IllegalStateException("you have to specify a csv entry parser");
        }
        return new CSVReaderImpl(this);
    }

    public static CSVReader<String[]> newDefaultReader(Reader reader) {
        return new CSVReaderBuilder<String[]>(reader).entryParser(new DefaultCSVEntryParser()).build();
    }

    public static <E> CachedCSVReader<E> cached(CSVReader<E> reader) {
        return new CachedCSVReaderImpl<E>(reader);
    }
}

