/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jcsv.annotations.internal;

import com.googlecode.jcsv.annotations.ValueProcessor;
import com.googlecode.jcsv.annotations.processors.BooleanProcessor;
import com.googlecode.jcsv.annotations.processors.ByteProcessor;
import com.googlecode.jcsv.annotations.processors.CharacterProcessor;
import com.googlecode.jcsv.annotations.processors.DateProcessor;
import com.googlecode.jcsv.annotations.processors.DoubleProcessor;
import com.googlecode.jcsv.annotations.processors.FloatProcessor;
import com.googlecode.jcsv.annotations.processors.IntegerProcessor;
import com.googlecode.jcsv.annotations.processors.LongProcessor;
import com.googlecode.jcsv.annotations.processors.ShortProcessor;
import com.googlecode.jcsv.annotations.processors.StringProcessor;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueProcessorProvider {
    private final Map<Class<?>, ValueProcessor<?>> processors = new HashMap();
    private final Map<Class<?>, Class<?>> primitiveWrapperTypes = new HashMap();

    public ValueProcessorProvider() {
        this.fillPrimitiveWrapperTypesMap();
        this.registerDefaultValueProcessors();
    }

    public <E> void registerValueProcessor(Class<E> clazz, ValueProcessor<? extends E> processor) {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("can not register value processor for a primitive type, register it for the wrapper type instead");
        }
        if (this.processors.containsKey(clazz)) {
            throw new IllegalArgumentException(String.format("can not register value processor for %s, it is already registered.", clazz));
        }
        this.processors.put(clazz, processor);
    }

    public <E> void removeValueProcessor(Class<E> clazz) {
        if (!this.processors.containsKey(clazz)) {
            throw new IllegalArgumentException(String.format("can not remove value processor for %s, it is not registered yet.", clazz));
        }
        this.processors.remove(clazz);
    }

    public <E> ValueProcessor<E> getValueProcessor(Class<E> clazz) {
        if (clazz.isPrimitive()) {
            clazz = this.primitiveWrapperTypes.get(clazz);
        }
        if (!this.processors.containsKey(clazz)) {
            throw new IllegalArgumentException(String.format("no value processor registered for %s.", clazz));
        }
        return this.processors.get(clazz);
    }

    private void registerDefaultValueProcessors() {
        this.registerValueProcessor(String.class, new StringProcessor());
        this.registerValueProcessor(Boolean.class, new BooleanProcessor());
        this.registerValueProcessor(Byte.class, new ByteProcessor());
        this.registerValueProcessor(Character.class, new CharacterProcessor());
        this.registerValueProcessor(Double.class, new DoubleProcessor());
        this.registerValueProcessor(Float.class, new FloatProcessor());
        this.registerValueProcessor(Integer.class, new IntegerProcessor());
        this.registerValueProcessor(Long.class, new LongProcessor());
        this.registerValueProcessor(Short.class, new ShortProcessor());
        this.registerValueProcessor(Date.class, new DateProcessor(DateFormat.getDateInstance()));
    }

    private void fillPrimitiveWrapperTypesMap() {
        this.primitiveWrapperTypes.put(Boolean.TYPE, Boolean.class);
        this.primitiveWrapperTypes.put(Byte.TYPE, Byte.class);
        this.primitiveWrapperTypes.put(Character.TYPE, Character.class);
        this.primitiveWrapperTypes.put(Double.TYPE, Double.class);
        this.primitiveWrapperTypes.put(Float.TYPE, Float.class);
        this.primitiveWrapperTypes.put(Integer.TYPE, Integer.class);
        this.primitiveWrapperTypes.put(Long.TYPE, Long.class);
        this.primitiveWrapperTypes.put(Short.TYPE, Short.class);
    }
}

