/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.storage.persistence;

import com.google.common.annotations.VisibleForTesting;
import haveno.common.file.FileUtil;
import haveno.common.file.ResourceNotFoundException;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistableEnvelope;
import java.io.File;
import java.nio.file.Paths;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StoreService<T extends PersistableEnvelope> {
    private static final Logger log = LoggerFactory.getLogger(StoreService.class);
    protected final PersistenceManager<T> persistenceManager;
    protected final String absolutePathOfStorageDir;
    protected T store;

    public StoreService(File storageDir, PersistenceManager<T> persistenceManager) {
        this.persistenceManager = persistenceManager;
        this.absolutePathOfStorageDir = storageDir.getAbsolutePath();
    }

    protected void requestPersistence() {
        this.persistenceManager.requestPersistence();
    }

    protected T getStore() {
        return this.store;
    }

    public abstract String getFileName();

    protected void readFromResources(String postFix, Runnable completeHandler) {
        String fileName = this.getFileName();
        this.makeFileFromResourceFile(fileName, postFix);
        try {
            this.readStore(persisted -> completeHandler.run());
        }
        catch (Throwable t) {
            this.makeFileFromResourceFile(fileName, postFix);
            this.readStore(persisted -> completeHandler.run());
        }
    }

    @VisibleForTesting
    protected void readFromResourcesSync(String postFix) {
        String fileName = this.getFileName();
        this.makeFileFromResourceFile(fileName, postFix);
        try {
            this.readStoreSync();
        }
        catch (Throwable t) {
            this.makeFileFromResourceFile(fileName, postFix);
            this.readStoreSync();
        }
    }

    protected boolean makeFileFromResourceFile(String fileName, String postFix) {
        File destinationFile;
        String resourceFileName = fileName + postFix;
        File dbDir = new File(this.absolutePathOfStorageDir);
        if (!dbDir.exists() && !dbDir.mkdir()) {
            log.warn("make dir failed.\ndbDir=" + dbDir.getAbsolutePath());
        }
        if (!(destinationFile = new File(Paths.get(this.absolutePathOfStorageDir, fileName).toString())).exists()) {
            try {
                log.debug("We copy resource to file: resourceFileName={}, destinationFile={}", (Object)resourceFileName, (Object)destinationFile);
                FileUtil.resourceToFile((String)resourceFileName, (File)destinationFile);
                return true;
            }
            catch (ResourceNotFoundException e) {
                log.debug("Could not find resourceFile " + resourceFileName + ". That is expected if none is provided yet.");
            }
            catch (Throwable e) {
                log.error("Could not copy resourceFile " + resourceFileName + " to " + destinationFile.getAbsolutePath() + ".\n", e);
            }
        } else {
            log.debug("No resource file was copied. {} exists already.", (Object)fileName);
        }
        return false;
    }

    protected void readStore(String fileName, Consumer<T> consumer) {
        this.persistenceManager.readPersisted(fileName, consumer, () -> consumer.accept(this.createStore()));
    }

    protected void readStore(Consumer<T> consumer) {
        this.readStore(this.getFileName(), persisted -> {
            this.store = persisted;
            this.initializePersistenceManager();
            consumer.accept(persisted);
        });
    }

    @VisibleForTesting
    protected T getStoreSync(String fileName) {
        Object store = this.persistenceManager.getPersisted(fileName);
        if (store == null) {
            store = this.createStore();
        }
        return (T)store;
    }

    @VisibleForTesting
    protected void readStoreSync() {
        this.store = this.getStoreSync(this.getFileName());
        this.initializePersistenceManager();
    }

    protected abstract void initializePersistenceManager();

    protected abstract T createStore();
}

