/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.storage.persistence;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.network.p2p.storage.persistence.StoreService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDataStoreService {
    private static final Logger log = LoggerFactory.getLogger(ResourceDataStoreService.class);
    private final List<StoreService<? extends PersistableEnvelope>> services = new ArrayList<StoreService<? extends PersistableEnvelope>>();

    @Inject
    public ResourceDataStoreService() {
    }

    public void addService(StoreService<? extends PersistableEnvelope> service) {
        this.services.add(service);
    }

    public void readFromResources(String postFix, Runnable completeHandler) {
        if (this.services.isEmpty()) {
            completeHandler.run();
            return;
        }
        AtomicInteger remaining = new AtomicInteger(this.services.size());
        this.services.forEach(service -> service.readFromResources(postFix, () -> {
            if (remaining.decrementAndGet() == 0) {
                completeHandler.run();
            }
        }));
    }

    @VisibleForTesting
    public void readFromResourcesSync(String postFix) {
        this.services.forEach(service -> service.readFromResourcesSync(postFix));
    }
}

