/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.storage.persistence;

import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.common.util.Utilities;
import haveno.network.p2p.storage.P2PDataStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.RemovedPayloadsMap;

public class RemovedPayloadsMap
implements PersistableEnvelope {
    private static final Logger log = LoggerFactory.getLogger(RemovedPayloadsMap.class);
    private final Map<P2PDataStorage.ByteArray, Long> dateByHashes;

    public RemovedPayloadsMap() {
        this.dateByHashes = new HashMap<P2PDataStorage.ByteArray, Long>();
    }

    private RemovedPayloadsMap(Map<P2PDataStorage.ByteArray, Long> dateByHashes) {
        this.dateByHashes = dateByHashes;
    }

    public protobuf.PersistableEnvelope toProtoMessage() {
        RemovedPayloadsMap.Builder builder = protobuf.RemovedPayloadsMap.newBuilder().putAllDateByHashes(this.dateByHashes.entrySet().stream().collect(Collectors.toMap(e -> Utilities.encodeToHex((byte[])((P2PDataStorage.ByteArray)e.getKey()).bytes), Map.Entry::getValue)));
        return protobuf.PersistableEnvelope.newBuilder().setRemovedPayloadsMap(builder).build();
    }

    public static RemovedPayloadsMap fromProto(protobuf.RemovedPayloadsMap proto) {
        Map<P2PDataStorage.ByteArray, Long> dateByHashes = proto.getDateByHashesMap().entrySet().stream().collect(Collectors.toMap(e -> new P2PDataStorage.ByteArray(Utilities.decodeFromHex((String)((String)e.getKey()))), Map.Entry::getValue));
        return new RemovedPayloadsMap(dateByHashes);
    }

    public String toString() {
        return "RemovedPayloadsMap{\n     dateByHashes=" + String.valueOf(this.dateByHashes) + "\n}";
    }

    public Map<P2PDataStorage.ByteArray, Long> getDateByHashes() {
        return this.dateByHashes;
    }
}

