/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.storage.persistence;

import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.persistence.StoreService;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapStoreService<T extends PersistableEnvelope, R extends PersistablePayload>
extends StoreService<T> {
    private static final Logger log = LoggerFactory.getLogger(MapStoreService.class);

    public MapStoreService(File storageDir, PersistenceManager<T> persistenceManager) {
        super(storageDir, persistenceManager);
    }

    public abstract Map<P2PDataStorage.ByteArray, R> getMap();

    public abstract boolean canHandle(R var1);

    void put(P2PDataStorage.ByteArray hash, R payload) {
        this.getMap().put(hash, payload);
        this.requestPersistence();
    }

    protected R putIfAbsent(P2PDataStorage.ByteArray hash, R payload) {
        PersistablePayload previous = (PersistablePayload)this.getMap().putIfAbsent(hash, payload);
        this.requestPersistence();
        return (R)previous;
    }

    R remove(P2PDataStorage.ByteArray hash) {
        PersistablePayload result = (PersistablePayload)this.getMap().remove(hash);
        this.requestPersistence();
        return (R)result;
    }

    boolean containsKey(P2PDataStorage.ByteArray hash) {
        return this.getMap().containsKey(hash);
    }
}

