/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.storage.persistence;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.payload.PersistableNetworkPayload;
import haveno.network.p2p.storage.persistence.HistoricalDataStoreService;
import haveno.network.p2p.storage.persistence.MapStoreService;
import haveno.network.p2p.storage.persistence.PersistableNetworkPayloadStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendOnlyDataStoreService {
    private static final Logger log = LoggerFactory.getLogger(AppendOnlyDataStoreService.class);
    private final List<MapStoreService<? extends PersistableNetworkPayloadStore<? extends PersistableNetworkPayload>, PersistableNetworkPayload>> services = new ArrayList<MapStoreService<? extends PersistableNetworkPayloadStore<? extends PersistableNetworkPayload>, PersistableNetworkPayload>>();

    @Inject
    public AppendOnlyDataStoreService() {
    }

    public void addService(MapStoreService<? extends PersistableNetworkPayloadStore<? extends PersistableNetworkPayload>, PersistableNetworkPayload> service) {
        this.services.add(service);
    }

    public void readFromResources(String postFix, Runnable completeHandler) {
        if (this.services.isEmpty()) {
            completeHandler.run();
            return;
        }
        AtomicInteger remaining = new AtomicInteger(this.services.size());
        this.services.forEach(service -> service.readFromResources(postFix, () -> {
            if (remaining.decrementAndGet() == 0) {
                completeHandler.run();
            }
        }));
    }

    @VisibleForTesting
    public void readFromResourcesSync(String postFix) {
        this.services.forEach(service -> service.readFromResourcesSync(postFix));
    }

    public Map<P2PDataStorage.ByteArray, PersistableNetworkPayload> getMap(PersistableNetworkPayload payload) {
        return this.findService(payload).map(service -> service instanceof HistoricalDataStoreService ? ((HistoricalDataStoreService)service).getMapOfAllData() : service.getMap()).orElse(new HashMap());
    }

    public boolean put(P2PDataStorage.ByteArray hashAsByteArray, PersistableNetworkPayload payload) {
        Optional<MapStoreService<? extends PersistableNetworkPayloadStore<? extends PersistableNetworkPayload>, PersistableNetworkPayload>> optionalService = this.findService(payload);
        optionalService.ifPresent(service -> service.putIfAbsent(hashAsByteArray, payload));
        return optionalService.isPresent();
    }

    @NotNull
    private Optional<MapStoreService<? extends PersistableNetworkPayloadStore<? extends PersistableNetworkPayload>, PersistableNetworkPayload>> findService(PersistableNetworkPayload payload) {
        return this.services.stream().filter(service -> service.canHandle(payload)).findAny();
    }

    public List<MapStoreService<? extends PersistableNetworkPayloadStore<? extends PersistableNetworkPayload>, PersistableNetworkPayload>> getServices() {
        return this.services;
    }
}

