/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.storage.payload;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import haveno.common.crypto.CryptoException;
import haveno.common.crypto.Sig;
import haveno.common.proto.network.GetDataResponsePriority;
import haveno.common.proto.network.NetworkPayload;
import haveno.common.proto.network.NetworkProtoResolver;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.common.util.Utilities;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.payload.ExpirablePayload;
import haveno.network.p2p.storage.payload.MailboxStoragePayload;
import haveno.network.p2p.storage.payload.PersistableNetworkPayload;
import haveno.network.p2p.storage.payload.ProtectedStoragePayload;
import java.security.PublicKey;
import java.time.Clock;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.StoragePayload;

public class ProtectedStorageEntry
implements NetworkPayload,
PersistablePayload {
    private static final Logger log = LoggerFactory.getLogger(ProtectedStorageEntry.class);
    private final ProtectedStoragePayload protectedStoragePayload;
    private final byte[] ownerPubKeyBytes;
    private final transient PublicKey ownerPubKey;
    private final int sequenceNumber;
    private final byte[] signature;
    private long creationTimeStamp;

    public ProtectedStorageEntry(@NotNull ProtectedStoragePayload protectedStoragePayload, @NotNull PublicKey ownerPubKey, int sequenceNumber, byte[] signature, Clock clock) {
        this(protectedStoragePayload, Sig.getPublicKeyBytes((PublicKey)ownerPubKey), ownerPubKey, sequenceNumber, signature, clock.millis(), clock);
    }

    protected ProtectedStorageEntry(@NotNull ProtectedStoragePayload protectedStoragePayload, byte[] ownerPubKeyBytes, @NotNull PublicKey ownerPubKey, int sequenceNumber, byte[] signature, long creationTimeStamp, Clock clock) {
        Preconditions.checkArgument((!(protectedStoragePayload instanceof PersistableNetworkPayload) ? 1 : 0) != 0);
        this.protectedStoragePayload = protectedStoragePayload;
        this.ownerPubKeyBytes = ownerPubKeyBytes;
        this.ownerPubKey = ownerPubKey;
        this.sequenceNumber = sequenceNumber;
        this.signature = signature;
        this.creationTimeStamp = Math.min(creationTimeStamp, clock.millis());
    }

    private ProtectedStorageEntry(@NotNull ProtectedStoragePayload protectedStoragePayload, byte[] ownerPubKeyBytes, int sequenceNumber, byte[] signature, long creationTimeStamp, Clock clock) {
        this(protectedStoragePayload, ownerPubKeyBytes, Sig.getPublicKeyFromBytes((byte[])ownerPubKeyBytes), sequenceNumber, signature, creationTimeStamp, clock);
    }

    public Message toProtoMessage() {
        return protobuf.ProtectedStorageEntry.newBuilder().setStoragePayload((StoragePayload)this.protectedStoragePayload.toProtoMessage()).setOwnerPubKeyBytes(ByteString.copyFrom((byte[])this.ownerPubKeyBytes)).setSequenceNumber(this.sequenceNumber).setSignature(ByteString.copyFrom((byte[])this.signature)).setCreationTimeStamp(this.creationTimeStamp).build();
    }

    public protobuf.ProtectedStorageEntry toProtectedStorageEntry() {
        return (protobuf.ProtectedStorageEntry)this.toProtoMessage();
    }

    public static ProtectedStorageEntry fromProto(protobuf.ProtectedStorageEntry proto, NetworkProtoResolver resolver) {
        return new ProtectedStorageEntry(ProtectedStoragePayload.fromProto(proto.getStoragePayload(), resolver), proto.getOwnerPubKeyBytes().toByteArray(), proto.getSequenceNumber(), proto.getSignature().toByteArray(), proto.getCreationTimeStamp(), resolver.getClock());
    }

    public void backDate() {
        if (this.protectedStoragePayload instanceof ExpirablePayload) {
            this.creationTimeStamp -= ((ExpirablePayload)((Object)this.protectedStoragePayload)).getTTL() / 2L;
        }
    }

    public boolean isExpired(Clock clock) {
        return this.protectedStoragePayload instanceof ExpirablePayload && clock.millis() - this.creationTimeStamp > ((ExpirablePayload)((Object)this.protectedStoragePayload)).getTTL();
    }

    public GetDataResponsePriority getGetDataResponsePriority() {
        return this.protectedStoragePayload.getGetDataResponsePriority();
    }

    public boolean isValidForAddOperation() {
        if (!this.isSignatureValid()) {
            return false;
        }
        if (this.protectedStoragePayload instanceof MailboxStoragePayload) {
            MailboxStoragePayload mailboxStoragePayload = (MailboxStoragePayload)this.getProtectedStoragePayload();
            return mailboxStoragePayload.getSenderPubKeyForAddOperation().equals(this.getOwnerPubKey());
        }
        boolean result = this.ownerPubKey.equals(this.protectedStoragePayload.getOwnerPubKey());
        if (!result) {
            String res1 = this.toString();
            String res2 = "null";
            if (this.protectedStoragePayload.getOwnerPubKey() != null) {
                res2 = Utilities.encodeToHex((byte[])this.protectedStoragePayload.getOwnerPubKey().getEncoded(), (boolean)true);
            }
            log.warn("ProtectedStorageEntry::isValidForAddOperation() failed. Entry owner does not match Payload owner:\nProtectedStorageEntry={}\nPayloadOwner={}", (Object)res1, (Object)res2);
        }
        return result;
    }

    public boolean isValidForRemoveOperation() {
        boolean result = this.isValidForAddOperation();
        if (!result) {
            String res1 = this.toString();
            String res2 = "null";
            if (this.protectedStoragePayload.getOwnerPubKey() != null) {
                res2 = Utilities.encodeToHex((byte[])this.protectedStoragePayload.getOwnerPubKey().getEncoded(), (boolean)true);
            }
            log.warn("ProtectedStorageEntry::isValidForRemoveOperation() failed. Entry owner does not match Payload owner:\nProtectedStorageEntry={}\nPayloadOwner={}", (Object)res1, (Object)res2);
        }
        return result;
    }

    boolean isSignatureValid() {
        try {
            byte[] hashOfDataAndSeqNr = P2PDataStorage.get32ByteHash(new P2PDataStorage.DataAndSeqNrPair(this.protectedStoragePayload, this.sequenceNumber));
            boolean result = Sig.verify((PublicKey)this.ownerPubKey, (byte[])hashOfDataAndSeqNr, (byte[])this.signature);
            if (!result) {
                log.warn("ProtectedStorageEntry::isSignatureValid() failed.\n{}}", (Object)this);
            }
            return result;
        }
        catch (CryptoException e) {
            log.error("ProtectedStorageEntry::isSignatureValid() exception {}", (Object)e.toString());
            return false;
        }
    }

    public boolean matchesRelevantPubKey(ProtectedStorageEntry protectedStorageEntry) {
        boolean result = protectedStorageEntry.getOwnerPubKey().equals(this.ownerPubKey);
        if (!result) {
            log.warn("New data entry does not match our stored data. storedData.ownerPubKey={}, ownerPubKey={}}", (Object)protectedStorageEntry.getOwnerPubKey().toString(), (Object)this.ownerPubKey);
        }
        return result;
    }

    public String toString() {
        return "ProtectedStorageEntry {\n\tPayload:                 " + String.valueOf(this.protectedStoragePayload) + "\n\tOwner Public Key:        " + Utilities.bytesAsHexString((byte[])this.ownerPubKeyBytes) + "\n\tSequence Number:         " + this.sequenceNumber + "\n\tSignature:               " + Utilities.bytesAsHexString((byte[])this.signature) + "\n\tTimestamp:               " + this.creationTimeStamp + "\n} ";
    }

    public ProtectedStoragePayload getProtectedStoragePayload() {
        return this.protectedStoragePayload;
    }

    public byte[] getOwnerPubKeyBytes() {
        return this.ownerPubKeyBytes;
    }

    public PublicKey getOwnerPubKey() {
        return this.ownerPubKey;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public long getCreationTimeStamp() {
        return this.creationTimeStamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtectedStorageEntry)) {
            return false;
        }
        ProtectedStorageEntry other = (ProtectedStorageEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSequenceNumber() != other.getSequenceNumber()) {
            return false;
        }
        if (this.getCreationTimeStamp() != other.getCreationTimeStamp()) {
            return false;
        }
        ProtectedStoragePayload this$protectedStoragePayload = this.getProtectedStoragePayload();
        ProtectedStoragePayload other$protectedStoragePayload = other.getProtectedStoragePayload();
        if (this$protectedStoragePayload == null ? other$protectedStoragePayload != null : !this$protectedStoragePayload.equals(other$protectedStoragePayload)) {
            return false;
        }
        if (!Arrays.equals(this.getOwnerPubKeyBytes(), other.getOwnerPubKeyBytes())) {
            return false;
        }
        return Arrays.equals(this.getSignature(), other.getSignature());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProtectedStorageEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSequenceNumber();
        long $creationTimeStamp = this.getCreationTimeStamp();
        result = result * 59 + (int)($creationTimeStamp >>> 32 ^ $creationTimeStamp);
        ProtectedStoragePayload $protectedStoragePayload = this.getProtectedStoragePayload();
        result = result * 59 + ($protectedStoragePayload == null ? 43 : $protectedStoragePayload.hashCode());
        result = result * 59 + Arrays.hashCode(this.getOwnerPubKeyBytes());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        return result;
    }
}

