/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.storage.payload;

import com.google.protobuf.ByteString;
import haveno.common.crypto.Sig;
import haveno.common.proto.network.NetworkProtoResolver;
import haveno.common.util.Utilities;
import haveno.network.p2p.storage.payload.MailboxStoragePayload;
import haveno.network.p2p.storage.payload.ProtectedStorageEntry;
import java.security.PublicKey;
import java.time.Clock;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtectedMailboxStorageEntry
extends ProtectedStorageEntry {
    private static final Logger log = LoggerFactory.getLogger(ProtectedMailboxStorageEntry.class);
    private final byte[] receiversPubKeyBytes;
    private final transient PublicKey receiversPubKey;

    public ProtectedMailboxStorageEntry(MailboxStoragePayload mailboxStoragePayload, PublicKey ownerPubKey, int sequenceNumber, byte[] signature, PublicKey receiversPubKey, Clock clock) {
        this(mailboxStoragePayload, Sig.getPublicKeyBytes((PublicKey)ownerPubKey), ownerPubKey, sequenceNumber, signature, Sig.getPublicKeyBytes((PublicKey)receiversPubKey), receiversPubKey, clock.millis(), clock);
    }

    private ProtectedMailboxStorageEntry(MailboxStoragePayload mailboxStoragePayload, byte[] ownerPubKeyBytes, PublicKey ownerPubKey, int sequenceNumber, byte[] signature, byte[] receiversPubKeyBytes, PublicKey receiversPubKey, long creationTimeStamp, Clock clock) {
        super(mailboxStoragePayload, ownerPubKeyBytes, ownerPubKey, sequenceNumber, signature, creationTimeStamp, clock);
        this.receiversPubKey = receiversPubKey;
        this.receiversPubKeyBytes = receiversPubKeyBytes;
    }

    public MailboxStoragePayload getMailboxStoragePayload() {
        return (MailboxStoragePayload)this.getProtectedStoragePayload();
    }

    @Override
    public boolean isValidForAddOperation() {
        if (!this.isSignatureValid()) {
            return false;
        }
        MailboxStoragePayload mailboxStoragePayload = this.getMailboxStoragePayload();
        if (!mailboxStoragePayload.getOwnerPubKey().equals(this.receiversPubKey)) {
            log.debug("Entry receiversPubKey does not match payload owner which is a requirement for adding MailboxStoragePayloads");
            return false;
        }
        boolean result = mailboxStoragePayload.getSenderPubKeyForAddOperation().equals(this.getOwnerPubKey());
        if (!result) {
            String res1 = this.toString();
            String res2 = "null";
            if (mailboxStoragePayload.getOwnerPubKey() != null) {
                res2 = Utilities.encodeToHex((byte[])mailboxStoragePayload.getSenderPubKeyForAddOperation().getEncoded(), (boolean)true);
            }
            log.warn("ProtectedMailboxStorageEntry::isValidForAddOperation() failed. Entry owner does not match sender key in payload:\nProtectedStorageEntry=%{}\nSenderPubKeyForAddOperation=%{}", (Object)res1, (Object)res2);
        }
        return result;
    }

    @Override
    public boolean isValidForRemoveOperation() {
        boolean result;
        if (!this.isSignatureValid()) {
            return false;
        }
        MailboxStoragePayload mailboxStoragePayload = this.getMailboxStoragePayload();
        if (!mailboxStoragePayload.getOwnerPubKey().equals(this.receiversPubKey)) {
            log.debug("Entry receiversPubKey does not match payload owner which is a requirement for removing MailboxStoragePayloads");
            return false;
        }
        boolean bl = result = mailboxStoragePayload.getOwnerPubKey() != null && mailboxStoragePayload.getOwnerPubKey().equals(this.getOwnerPubKey());
        if (!result) {
            String res1 = this.toString();
            String res2 = "null";
            if (mailboxStoragePayload.getOwnerPubKey() != null) {
                res2 = Utilities.encodeToHex((byte[])mailboxStoragePayload.getOwnerPubKey().getEncoded(), (boolean)true);
            }
            log.warn("ProtectedMailboxStorageEntry::isValidForRemoveOperation() failed. Entry owner does not match Payload owner:\nProtectedStorageEntry={}\nPayloadOwner={}", (Object)res1, (Object)res2);
        }
        return result;
    }

    @Override
    public boolean matchesRelevantPubKey(ProtectedStorageEntry protectedStorageEntry) {
        if (!(protectedStorageEntry instanceof ProtectedMailboxStorageEntry)) {
            log.error("ProtectedMailboxStorageEntry::isMetadataEquals() failed due to object type mismatch. ProtectedMailboxStorageEntry required, but got\n" + String.valueOf(protectedStorageEntry));
            return false;
        }
        ProtectedMailboxStorageEntry protectedMailboxStorageEntry = (ProtectedMailboxStorageEntry)protectedStorageEntry;
        boolean result = protectedMailboxStorageEntry.getReceiversPubKey().equals(this.receiversPubKey);
        if (!result) {
            log.warn("ProtectedMailboxStorageEntry::isMetadataEquals() failed due to metadata mismatch. new.receiversPubKey=" + Utilities.bytesAsHexString((byte[])protectedMailboxStorageEntry.getReceiversPubKeyBytes()) + "stored.receiversPubKey=" + Utilities.bytesAsHexString((byte[])this.getReceiversPubKeyBytes()));
        }
        return result;
    }

    private ProtectedMailboxStorageEntry(MailboxStoragePayload mailboxStoragePayload, byte[] ownerPubKeyBytes, int sequenceNumber, byte[] signature, byte[] receiversPubKeyBytes, long creationTimeStamp, Clock clock) {
        this(mailboxStoragePayload, ownerPubKeyBytes, Sig.getPublicKeyFromBytes((byte[])ownerPubKeyBytes), sequenceNumber, signature, receiversPubKeyBytes, Sig.getPublicKeyFromBytes((byte[])receiversPubKeyBytes), creationTimeStamp, clock);
    }

    public protobuf.ProtectedMailboxStorageEntry toProtoMessage() {
        return protobuf.ProtectedMailboxStorageEntry.newBuilder().setEntry((protobuf.ProtectedStorageEntry)super.toProtoMessage()).setReceiversPubKeyBytes(ByteString.copyFrom((byte[])this.receiversPubKeyBytes)).build();
    }

    public static ProtectedMailboxStorageEntry fromProto(protobuf.ProtectedMailboxStorageEntry proto, NetworkProtoResolver resolver) {
        ProtectedStorageEntry entry = ProtectedStorageEntry.fromProto(proto.getEntry(), resolver);
        return new ProtectedMailboxStorageEntry((MailboxStoragePayload)entry.getProtectedStoragePayload(), entry.getOwnerPubKey().getEncoded(), entry.getSequenceNumber(), entry.getSignature(), proto.getReceiversPubKeyBytes().toByteArray(), entry.getCreationTimeStamp(), resolver.getClock());
    }

    @Override
    public String toString() {
        return "ProtectedMailboxStorageEntry{\n\tReceivers Public Key:    " + Utilities.bytesAsHexString((byte[])this.receiversPubKeyBytes) + "\n" + super.toString();
    }

    public byte[] getReceiversPubKeyBytes() {
        return this.receiversPubKeyBytes;
    }

    public PublicKey getReceiversPubKey() {
        return this.receiversPubKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtectedMailboxStorageEntry)) {
            return false;
        }
        ProtectedMailboxStorageEntry other = (ProtectedMailboxStorageEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.getReceiversPubKeyBytes(), other.getReceiversPubKeyBytes());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProtectedMailboxStorageEntry;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getReceiversPubKeyBytes());
        return result;
    }
}

