/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.peers.peerexchange.messages;

import com.google.common.base.Preconditions;
import haveno.common.app.Capabilities;
import haveno.common.app.Version;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.SendersNodeAddressMessage;
import haveno.network.p2p.SupportedCapabilitiesMessage;
import haveno.network.p2p.peers.peerexchange.Peer;
import haveno.network.p2p.peers.peerexchange.messages.PeerExchangeMessage;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import protobuf.GetPeersRequest;
import protobuf.NetworkEnvelope;

public final class GetPeersRequest
extends haveno.common.proto.network.NetworkEnvelope
implements PeerExchangeMessage,
SendersNodeAddressMessage,
SupportedCapabilitiesMessage {
    private final NodeAddress senderNodeAddress;
    private final int nonce;
    private final Set<Peer> reportedPeers;
    @Nullable
    private final Capabilities supportedCapabilities;

    public GetPeersRequest(NodeAddress senderNodeAddress, int nonce, Set<Peer> reportedPeers) {
        this(senderNodeAddress, nonce, reportedPeers, Capabilities.app, Version.getP2PMessageVersion());
    }

    private GetPeersRequest(NodeAddress senderNodeAddress, int nonce, Set<Peer> reportedPeers, @Nullable Capabilities supportedCapabilities, String messageVersion) {
        super(messageVersion);
        Preconditions.checkNotNull((Object)senderNodeAddress, (Object)"senderNodeAddress must not be null at GetPeersRequest");
        this.senderNodeAddress = senderNodeAddress;
        this.nonce = nonce;
        this.reportedPeers = reportedPeers;
        this.supportedCapabilities = supportedCapabilities;
    }

    public NetworkEnvelope toProtoNetworkEnvelope() {
        HashSet<Peer> clone = new HashSet<Peer>(this.reportedPeers);
        GetPeersRequest.Builder builder = protobuf.GetPeersRequest.newBuilder().setSenderNodeAddress(this.senderNodeAddress.toProtoMessage()).setNonce(this.nonce).addAllReportedPeers((Iterable)clone.stream().map(Peer::toProtoMessage).collect(Collectors.toList()));
        Optional.ofNullable(this.supportedCapabilities).ifPresent(e -> builder.addAllSupportedCapabilities((Iterable)Capabilities.toIntList((Capabilities)this.supportedCapabilities)));
        return this.getNetworkEnvelopeBuilder().setGetPeersRequest(builder).build();
    }

    public static GetPeersRequest fromProto(protobuf.GetPeersRequest proto, String messageVersion) {
        return new GetPeersRequest(NodeAddress.fromProto(proto.getSenderNodeAddress()), proto.getNonce(), new HashSet<Peer>(proto.getReportedPeersList().stream().map(Peer::fromProto).collect(Collectors.toSet())), Capabilities.fromIntList((List)proto.getSupportedCapabilitiesList()), messageVersion);
    }

    @Override
    public NodeAddress getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    public int getNonce() {
        return this.nonce;
    }

    public Set<Peer> getReportedPeers() {
        return this.reportedPeers;
    }

    @Override
    @Nullable
    public Capabilities getSupportedCapabilities() {
        return this.supportedCapabilities;
    }

    public String toString() {
        return "GetPeersRequest(senderNodeAddress=" + String.valueOf(this.getSenderNodeAddress()) + ", nonce=" + this.getNonce() + ", reportedPeers=" + String.valueOf(this.getReportedPeers()) + ", supportedCapabilities=" + String.valueOf(this.getSupportedCapabilities()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetPeersRequest)) {
            return false;
        }
        GetPeersRequest other = (GetPeersRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getNonce() != other.getNonce()) {
            return false;
        }
        NodeAddress this$senderNodeAddress = this.getSenderNodeAddress();
        NodeAddress other$senderNodeAddress = other.getSenderNodeAddress();
        if (this$senderNodeAddress == null ? other$senderNodeAddress != null : !((Object)this$senderNodeAddress).equals(other$senderNodeAddress)) {
            return false;
        }
        Set<Peer> this$reportedPeers = this.getReportedPeers();
        Set<Peer> other$reportedPeers = other.getReportedPeers();
        if (this$reportedPeers == null ? other$reportedPeers != null : !((Object)this$reportedPeers).equals(other$reportedPeers)) {
            return false;
        }
        Capabilities this$supportedCapabilities = this.getSupportedCapabilities();
        Capabilities other$supportedCapabilities = other.getSupportedCapabilities();
        return !(this$supportedCapabilities == null ? other$supportedCapabilities != null : !this$supportedCapabilities.equals(other$supportedCapabilities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetPeersRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getNonce();
        NodeAddress $senderNodeAddress = this.getSenderNodeAddress();
        result = result * 59 + ($senderNodeAddress == null ? 43 : ((Object)$senderNodeAddress).hashCode());
        Set<Peer> $reportedPeers = this.getReportedPeers();
        result = result * 59 + ($reportedPeers == null ? 43 : ((Object)$reportedPeers).hashCode());
        Capabilities $supportedCapabilities = this.getSupportedCapabilities();
        result = result * 59 + ($supportedCapabilities == null ? 43 : $supportedCapabilities.hashCode());
        return result;
    }
}

