/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.peers.peerexchange;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.ConnectionListener;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.peers.PeerManager;
import haveno.network.p2p.peers.peerexchange.GetPeersRequestHandler;
import haveno.network.p2p.peers.peerexchange.Peer;
import haveno.network.p2p.peers.peerexchange.PeerExchangeHandler;
import haveno.network.p2p.peers.peerexchange.messages.GetPeersRequest;
import haveno.network.p2p.seed.SeedNodeRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerExchangeManager
implements MessageListener,
ConnectionListener,
PeerManager.Listener {
    private static final Logger log = LoggerFactory.getLogger(PeerExchangeManager.class);
    private static final long RETRY_DELAY_SEC = 10L;
    private static final long RETRY_DELAY_AFTER_ALL_CON_LOST_SEC = 3L;
    private static final long REQUEST_PERIODICALLY_INTERVAL_MIN = 10L;
    private final NetworkNode networkNode;
    private final PeerManager peerManager;
    private final Set<NodeAddress> seedNodeAddresses;
    private final Map<NodeAddress, PeerExchangeHandler> handlerMap = new HashMap<NodeAddress, PeerExchangeHandler>();
    private Timer retryTimer;
    private Timer periodicTimer;
    private boolean stopped;

    @Inject
    public PeerExchangeManager(NetworkNode networkNode, SeedNodeRepository seedNodeRepository, PeerManager peerManager) {
        this.networkNode = networkNode;
        this.peerManager = peerManager;
        this.networkNode.addMessageListener(this);
        this.networkNode.addConnectionListener(this);
        this.peerManager.addListener(this);
        this.seedNodeAddresses = new HashSet<NodeAddress>(seedNodeRepository.getSeedNodeAddresses());
    }

    public void shutDown() {
        this.stopped = true;
        this.networkNode.removeMessageListener(this);
        this.networkNode.removeConnectionListener(this);
        this.peerManager.removeListener(this);
        this.stopPeriodicTimer();
        this.stopRetryTimer();
        this.closeAllHandlers();
    }

    public void requestReportedPeersFromSeedNodes(NodeAddress nodeAddress) {
        Preconditions.checkNotNull((Object)this.networkNode.getNodeAddress(), (Object)"My node address must not be null at requestReportedPeers");
        ArrayList<NodeAddress> remainingNodeAddresses = new ArrayList<NodeAddress>(this.seedNodeAddresses);
        remainingNodeAddresses.remove(nodeAddress);
        Collections.shuffle(remainingNodeAddresses);
        this.requestReportedPeers(nodeAddress, remainingNodeAddresses);
        this.startPeriodicTimer();
    }

    public void initialRequestPeersFromReportedOrPersistedPeers() {
        if (!this.peerManager.getReportedPeers().isEmpty() || !this.peerManager.getPersistedPeers().isEmpty()) {
            for (int i = 0; i < Math.min(8, this.peerManager.getMaxConnections()); ++i) {
                this.requestWithAvailablePeers();
            }
        } else {
            log.info("We don't have any reported or persisted peers, so we need to wait until we receive from the seed node the initial peer list.");
        }
    }

    @Override
    public void onConnection(Connection connection) {
    }

    @Override
    public void onDisconnect(CloseConnectionReason closeConnectionReason, Connection connection) {
        log.debug("onDisconnect closeConnectionReason={}, nodeAddressOpt={}", (Object)closeConnectionReason, connection.getPeersNodeAddressOptional());
        this.closeHandler(connection);
        if (this.retryTimer == null) {
            this.retryTimer = UserThread.runAfter(() -> {
                log.trace("ConnectToMorePeersTimer called from onDisconnect code path");
                this.stopRetryTimer();
                this.requestWithAvailablePeers();
            }, (long)10L);
        }
        if (this.peerManager.isPeerBanned(closeConnectionReason, connection)) {
            connection.getPeersNodeAddressOptional().ifPresent(this.seedNodeAddresses::remove);
        }
    }

    @Override
    public void onAllConnectionsLost() {
        this.closeAllHandlers();
        this.stopPeriodicTimer();
        this.stopRetryTimer();
        this.stopped = true;
        this.restart();
    }

    @Override
    public void onNewConnectionAfterAllConnectionsLost() {
        this.closeAllHandlers();
        this.stopped = false;
        this.restart();
    }

    @Override
    public void onAwakeFromStandby() {
        this.closeAllHandlers();
        this.stopped = false;
        if (!this.networkNode.getAllConnections().isEmpty()) {
            this.restart();
        }
    }

    @Override
    public void onMessage(NetworkEnvelope networkEnvelope, final Connection connection) {
        if (networkEnvelope instanceof GetPeersRequest) {
            if (!this.stopped) {
                GetPeersRequestHandler getPeersRequestHandler = new GetPeersRequestHandler(this.networkNode, this.peerManager, new GetPeersRequestHandler.Listener(){

                    @Override
                    public void onComplete() {
                        log.trace("PeerExchangeHandshake completed.\n\tConnection={}", (Object)connection);
                    }

                    @Override
                    public void onFault(String errorMessage, Connection connection2) {
                        log.trace("PeerExchangeHandshake failed.\n\terrorMessage={}\n\tconnection={}", (Object)errorMessage, (Object)connection2);
                        PeerExchangeManager.this.peerManager.handleConnectionFault(connection2);
                    }
                });
                getPeersRequestHandler.handle((GetPeersRequest)networkEnvelope, connection);
            } else {
                log.warn("We have stopped already. We ignore that onMessage call.");
            }
        }
    }

    private void requestReportedPeers(final NodeAddress nodeAddress, final List<NodeAddress> remainingNodeAddresses) {
        log.debug("requestReportedPeers nodeAddress={}; remainingNodeAddresses.size={}", (Object)nodeAddress, (Object)remainingNodeAddresses.size());
        if (!this.stopped) {
            if (!this.handlerMap.containsKey(nodeAddress)) {
                PeerExchangeHandler peerExchangeHandler = new PeerExchangeHandler(this.networkNode, this.peerManager, new PeerExchangeHandler.Listener(){

                    @Override
                    public void onComplete() {
                        PeerExchangeManager.this.handlerMap.remove(nodeAddress);
                        PeerExchangeManager.this.requestWithAvailablePeers();
                    }

                    @Override
                    public void onFault(String errorMessage, @Nullable Connection connection) {
                        log.debug("PeerExchangeHandshake of outbound connection failed.\n\terrorMessage={}\n\tnodeAddress={}", (Object)errorMessage, (Object)nodeAddress);
                        PeerExchangeManager.this.peerManager.handleConnectionFault(nodeAddress);
                        PeerExchangeManager.this.handlerMap.remove(nodeAddress);
                        if (!remainingNodeAddresses.isEmpty()) {
                            if (!PeerExchangeManager.this.peerManager.hasSufficientConnections()) {
                                log.debug("There are remaining nodes available for requesting peers. We will try getReportedPeers again.");
                                NodeAddress nextCandidate = (NodeAddress)remainingNodeAddresses.get(new Random().nextInt(remainingNodeAddresses.size()));
                                remainingNodeAddresses.remove(nextCandidate);
                                PeerExchangeManager.this.requestReportedPeers(nextCandidate, remainingNodeAddresses);
                            } else {
                                log.debug("We have already sufficient connections.");
                            }
                        } else {
                            log.debug("There is no remaining node available for requesting peers. That is expected if no other node is online.\n\tWe will try again after a pause.");
                            if (PeerExchangeManager.this.retryTimer == null) {
                                PeerExchangeManager.this.retryTimer = UserThread.runAfter(() -> {
                                    if (!PeerExchangeManager.this.stopped) {
                                        log.trace("retryTimer called from requestReportedPeers code path");
                                        PeerExchangeManager.this.stopRetryTimer();
                                        PeerExchangeManager.this.requestWithAvailablePeers();
                                    } else {
                                        PeerExchangeManager.this.stopRetryTimer();
                                        log.warn("We have stopped already. We ignore that retryTimer.run call.");
                                    }
                                }, (long)10L);
                            }
                        }
                    }
                });
                this.handlerMap.put(nodeAddress, peerExchangeHandler);
                peerExchangeHandler.sendGetPeersRequestAfterRandomDelay(nodeAddress);
            } else {
                log.trace("We have started already a peerExchangeHandler. We ignore that call. nodeAddress={}", (Object)nodeAddress);
            }
        } else {
            log.trace("We have stopped already. We ignore that requestReportedPeers call.");
        }
    }

    private void requestWithAvailablePeers() {
        if (!this.stopped) {
            if (!this.peerManager.hasSufficientConnections()) {
                List<NodeAddress> list = this.getFilteredNonSeedNodeList(this.getNodeAddresses(this.peerManager.getReportedPeers()), new ArrayList<NodeAddress>());
                Collections.shuffle(list);
                List<NodeAddress> filteredPersistedPeers = this.getFilteredNonSeedNodeList(this.getNodeAddresses(this.peerManager.getPersistedPeers()), list);
                Collections.shuffle(filteredPersistedPeers);
                list.addAll(filteredPersistedPeers);
                List<NodeAddress> filteredSeedNodeAddresses = this.getFilteredList(new ArrayList<NodeAddress>(this.seedNodeAddresses), list);
                Collections.shuffle(filteredSeedNodeAddresses);
                list.addAll(filteredSeedNodeAddresses);
                log.debug("Number of peers in list for connectToMorePeers: {}", (Object)list.size());
                log.trace("Filtered connectToMorePeers list: list={}", list);
                if (!list.isEmpty()) {
                    NodeAddress nextCandidate = list.get(0);
                    list.remove(nextCandidate);
                    this.requestReportedPeers(nextCandidate, list);
                } else {
                    log.debug("No more peers are available for requestReportedPeers. We will try again after a pause.");
                    if (this.retryTimer == null) {
                        this.retryTimer = UserThread.runAfter(() -> {
                            if (!this.stopped) {
                                log.trace("retryTimer called from requestWithAvailablePeers code path");
                                this.stopRetryTimer();
                                this.requestWithAvailablePeers();
                            } else {
                                this.stopRetryTimer();
                                log.warn("We have stopped already. We ignore that retryTimer.run call.");
                            }
                        }, (long)10L);
                    }
                }
            } else {
                log.debug("We have already sufficient connections.");
            }
        } else {
            log.trace("We have stopped already. We ignore that requestWithAvailablePeers call.");
        }
    }

    private void startPeriodicTimer() {
        this.stopped = false;
        if (this.periodicTimer == null) {
            this.periodicTimer = UserThread.runPeriodically(this::requestWithAvailablePeers, (long)10L, (TimeUnit)TimeUnit.MINUTES);
        }
    }

    private void restart() {
        this.startPeriodicTimer();
        if (this.retryTimer == null) {
            this.retryTimer = UserThread.runAfter(() -> {
                this.stopped = false;
                log.trace("retryTimer called from restart");
                this.stopRetryTimer();
                this.requestWithAvailablePeers();
            }, (long)3L);
        } else {
            log.debug("retryTimer already started");
        }
    }

    private List<NodeAddress> getNodeAddresses(Collection<Peer> collection) {
        return collection.stream().map(Peer::getNodeAddress).collect(Collectors.toList());
    }

    private List<NodeAddress> getFilteredList(Collection<NodeAddress> collection, List<NodeAddress> list) {
        return collection.stream().filter(e -> !list.contains(e) && !this.peerManager.isSelf((NodeAddress)e) && !this.peerManager.isConfirmed((NodeAddress)e)).collect(Collectors.toList());
    }

    private List<NodeAddress> getFilteredNonSeedNodeList(Collection<NodeAddress> collection, List<NodeAddress> list) {
        return this.getFilteredList(collection, list).stream().filter(e -> !this.peerManager.isSeedNode((NodeAddress)e)).collect(Collectors.toList());
    }

    private void stopPeriodicTimer() {
        this.stopped = true;
        if (this.periodicTimer != null) {
            this.periodicTimer.stop();
            this.periodicTimer = null;
        }
    }

    private void stopRetryTimer() {
        if (this.retryTimer != null) {
            this.retryTimer.stop();
            this.retryTimer = null;
        }
    }

    private void closeHandler(Connection connection) {
        NodeAddress nodeAddress;
        Optional<NodeAddress> peersNodeAddressOptional = connection.getPeersNodeAddressOptional();
        if (peersNodeAddressOptional.isPresent() && this.handlerMap.containsKey(nodeAddress = peersNodeAddressOptional.get())) {
            this.handlerMap.get(nodeAddress).cancel();
            this.handlerMap.remove(nodeAddress);
        }
    }

    private void closeAllHandlers() {
        this.handlerMap.values().stream().forEach(PeerExchangeHandler::cancel);
        this.handlerMap.clear();
    }
}

