/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.peers.peerexchange;

import haveno.common.app.Capabilities;
import haveno.common.app.Capability;
import haveno.common.app.HasCapabilities;
import haveno.common.proto.network.NetworkPayload;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.SupportedCapabilitiesListener;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Peer
implements HasCapabilities,
NetworkPayload,
PersistablePayload,
SupportedCapabilitiesListener {
    private static final Logger log = LoggerFactory.getLogger(Peer.class);
    private static final int MAX_FAILED_CONNECTION_ATTEMPTS = 8;
    private final NodeAddress nodeAddress;
    private final long date;
    private transient int failedConnectionAttempts = 0;
    private Capabilities capabilities = new Capabilities(new Capability[0]);

    public Peer(NodeAddress nodeAddress, @Nullable Capabilities supportedCapabilities) {
        this(nodeAddress, new Date().getTime(), supportedCapabilities);
    }

    private Peer(NodeAddress nodeAddress, long date, Capabilities supportedCapabilities) {
        this.nodeAddress = nodeAddress;
        this.date = date;
        this.capabilities.addAll(supportedCapabilities);
    }

    public protobuf.Peer toProtoMessage() {
        return protobuf.Peer.newBuilder().setNodeAddress(this.nodeAddress.toProtoMessage()).setDate(this.date).addAllSupportedCapabilities((Iterable)Capabilities.toIntList((Capabilities)this.getCapabilities())).build();
    }

    public static Peer fromProto(protobuf.Peer proto) {
        return new Peer(NodeAddress.fromProto(proto.getNodeAddress()), proto.getDate(), Capabilities.fromIntList((List)proto.getSupportedCapabilitiesList()));
    }

    public void onDisconnect() {
        ++this.failedConnectionAttempts;
    }

    public void onConnection() {
        --this.failedConnectionAttempts;
    }

    public boolean tooManyFailedConnectionAttempts() {
        return this.failedConnectionAttempts >= 8;
    }

    public Date getDate() {
        return new Date(this.date);
    }

    public long getDateAsLong() {
        return this.date;
    }

    @Override
    public void onChanged(Capabilities supportedCapabilities) {
        if (!supportedCapabilities.isEmpty()) {
            this.capabilities.set(supportedCapabilities);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Peer)) {
            return false;
        }
        Peer peer = (Peer)o;
        return this.nodeAddress != null ? this.nodeAddress.equals(peer.nodeAddress) : peer.nodeAddress == null;
    }

    public int hashCode() {
        return this.nodeAddress != null ? this.nodeAddress.hashCode() : 0;
    }

    public String toString() {
        return "Peer{\n     nodeAddress=" + String.valueOf(this.nodeAddress) + ",\n     date=" + this.date + ",\n     failedConnectionAttempts=" + this.failedConnectionAttempts + ",\n     capabilities=" + String.valueOf(this.capabilities) + "\n}";
    }

    public NodeAddress getNodeAddress() {
        return this.nodeAddress;
    }

    public int getFailedConnectionAttempts() {
        return this.failedConnectionAttempts;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void setFailedConnectionAttempts(int failedConnectionAttempts) {
        this.failedConnectionAttempts = failedConnectionAttempts;
    }

    public void setCapabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
    }
}

