/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.peers.keepalive;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.peers.PeerManager;
import haveno.network.p2p.peers.keepalive.messages.Ping;
import haveno.network.p2p.peers.keepalive.messages.Pong;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeepAliveHandler
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(KeepAliveHandler.class);
    private static final int DELAY_MS = 10000;
    private static final long LOG_THROTTLE_INTERVAL_MS = 60000L;
    private static long lastLoggedWarningTs = 0L;
    private static int numThrottledWarnings = 0;
    private final NetworkNode networkNode;
    private final PeerManager peerManager;
    private final Listener listener;
    private final int nonce = new Random().nextInt();
    @Nullable
    private Connection connection;
    private boolean stopped;
    private Timer delayTimer;
    private long sendTs;

    public KeepAliveHandler(NetworkNode networkNode, PeerManager peerManager, Listener listener) {
        this.networkNode = networkNode;
        this.peerManager = peerManager;
        this.listener = listener;
    }

    public void cancel() {
        this.cleanup();
    }

    public void sendPingAfterRandomDelay(Connection connection) {
        this.delayTimer = UserThread.runAfterRandomDelay(() -> this.sendPing(connection), (long)1L, (long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void sendPing(final Connection connection) {
        if (!this.stopped) {
            final Ping ping = new Ping(this.nonce, connection.getStatistic().roundTripTimeProperty().get());
            this.sendTs = System.currentTimeMillis();
            SettableFuture<Connection> future = this.networkNode.sendMessage(connection, (NetworkEnvelope)ping);
            Futures.addCallback(future, (FutureCallback)new FutureCallback<Connection>(){

                public void onSuccess(Connection connection2) {
                    if (!KeepAliveHandler.this.stopped) {
                        KeepAliveHandler.this.connection = connection2;
                        connection2.addMessageListener(KeepAliveHandler.this);
                    } else {
                        log.trace("We have stopped already. We ignore that networkNode.sendMessage.onSuccess call.");
                    }
                }

                public void onFailure(@NotNull Throwable throwable) {
                    if (!KeepAliveHandler.this.stopped) {
                        String errorMessage = "Sending ping to " + String.valueOf(connection) + " failed. That is expected if the peer is offline.\n\tping=" + String.valueOf(ping) + ".\n\tException=" + throwable.getMessage();
                        KeepAliveHandler.this.cleanup();
                        log.info(errorMessage);
                        KeepAliveHandler.this.peerManager.handleConnectionFault(connection);
                        KeepAliveHandler.this.listener.onFault(errorMessage);
                    } else {
                        log.trace("We have stopped already. We ignore that networkNode.sendMessage.onFailure call.");
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        } else {
            log.trace("We have stopped already. We ignore that sendPing call.");
        }
    }

    @Override
    public void onMessage(NetworkEnvelope networkEnvelope, Connection connection) {
        if (networkEnvelope instanceof Pong) {
            if (!this.stopped) {
                Pong pong = (Pong)networkEnvelope;
                if (pong.getRequestNonce() == this.nonce) {
                    int roundTripTime = (int)(System.currentTimeMillis() - this.sendTs);
                    connection.getStatistic().setRoundTripTime(roundTripTime);
                    this.cleanup();
                    this.listener.onComplete();
                } else {
                    this.throttleWarn("Nonce not matching. That should never happen.\n\tWe drop that message. nonce=" + this.nonce + ", requestNonce=" + pong.getRequestNonce() + ", peerNodeAddress=" + String.valueOf(connection.getPeersNodeAddressOptional().orElseGet(null)));
                }
            } else {
                log.trace("We have stopped already. We ignore that onMessage call.");
            }
        }
    }

    private void cleanup() {
        this.stopped = true;
        if (this.connection != null) {
            this.connection.removeMessageListener(this);
        }
        if (this.delayTimer != null) {
            this.delayTimer.stop();
            this.delayTimer = null;
        }
    }

    private synchronized void throttleWarn(String msg) {
        boolean logWarning;
        boolean bl = logWarning = System.currentTimeMillis() - lastLoggedWarningTs > 60000L;
        if (logWarning) {
            log.warn(msg);
            if (numThrottledWarnings > 0) {
                log.warn("We received {} throttled warnings since the last log entry" + (numThrottledWarnings >= 5 ? ". Possible DoS attack detected" : ""), (Object)numThrottledWarnings);
            }
            numThrottledWarnings = 0;
            lastLoggedWarningTs = System.currentTimeMillis();
        } else {
            ++numThrottledWarnings;
        }
    }

    public static interface Listener {
        public void onComplete();

        public void onFault(String var1);
    }
}

