/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.peers.getdata.messages;

import com.google.protobuf.ByteString;
import haveno.common.app.Capabilities;
import haveno.common.app.Version;
import haveno.common.proto.ProtoUtil;
import haveno.network.p2p.AnonymousMessage;
import haveno.network.p2p.SupportedCapabilitiesMessage;
import haveno.network.p2p.peers.getdata.messages.GetDataRequest;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.NetworkEnvelope;
import protobuf.PreliminaryGetDataRequest;

public final class PreliminaryGetDataRequest
extends GetDataRequest
implements AnonymousMessage,
SupportedCapabilitiesMessage {
    private static final Logger log = LoggerFactory.getLogger(PreliminaryGetDataRequest.class);
    private final Capabilities supportedCapabilities;

    public PreliminaryGetDataRequest(int nonce, Set<byte[]> excludedKeys) {
        this(nonce, excludedKeys, "1.2.2", Capabilities.app, Version.getP2PMessageVersion());
    }

    private PreliminaryGetDataRequest(int nonce, Set<byte[]> excludedKeys, @Nullable String version, Capabilities supportedCapabilities, String messageVersion) {
        super(messageVersion, nonce, excludedKeys, version);
        this.supportedCapabilities = supportedCapabilities;
    }

    public NetworkEnvelope toProtoNetworkEnvelope() {
        PreliminaryGetDataRequest.Builder builder = protobuf.PreliminaryGetDataRequest.newBuilder().addAllSupportedCapabilities((Iterable)Capabilities.toIntList((Capabilities)this.supportedCapabilities)).setNonce(this.nonce).addAllExcludedKeys((Iterable)this.excludedKeys.stream().map(ByteString::copyFrom).collect(Collectors.toList()));
        Optional.ofNullable(this.version).ifPresent(arg_0 -> ((PreliminaryGetDataRequest.Builder)builder).setVersion(arg_0));
        NetworkEnvelope proto = this.getNetworkEnvelopeBuilder().setPreliminaryGetDataRequest(builder).build();
        log.info("Sending a PreliminaryGetDataRequest with {} kB and {} excluded key entries. Requesters version={}", new Object[]{(double)proto.getSerializedSize() / 1000.0, this.excludedKeys.size(), this.version});
        return proto;
    }

    public static PreliminaryGetDataRequest fromProto(protobuf.PreliminaryGetDataRequest proto, String messageVersion) {
        Set excludedKeys = ProtoUtil.byteSetFromProtoByteStringList((List)proto.getExcludedKeysList());
        String requestersVersion = ProtoUtil.stringOrNullFromProto((String)proto.getVersion());
        log.info("Received a PreliminaryGetDataRequest with {} kB and {} excluded key entries. Requesters version={}", new Object[]{(double)proto.getSerializedSize() / 1000.0, excludedKeys.size(), requestersVersion});
        return new PreliminaryGetDataRequest(proto.getNonce(), excludedKeys, requestersVersion, Capabilities.fromIntList((List)proto.getSupportedCapabilitiesList()), messageVersion);
    }

    @Override
    public Capabilities getSupportedCapabilities() {
        return this.supportedCapabilities;
    }

    @Override
    public String toString() {
        return "PreliminaryGetDataRequest(supportedCapabilities=" + String.valueOf(this.getSupportedCapabilities()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreliminaryGetDataRequest)) {
            return false;
        }
        PreliminaryGetDataRequest other = (PreliminaryGetDataRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Capabilities this$supportedCapabilities = this.getSupportedCapabilities();
        Capabilities other$supportedCapabilities = other.getSupportedCapabilities();
        return !(this$supportedCapabilities == null ? other$supportedCapabilities != null : !this$supportedCapabilities.equals(other$supportedCapabilities));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PreliminaryGetDataRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Capabilities $supportedCapabilities = this.getSupportedCapabilities();
        result = result * 59 + ($supportedCapabilities == null ? 43 : $supportedCapabilities.hashCode());
        return result;
    }
}

