/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.peers.getdata;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.app.Version;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.ConnectionListener;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.peers.PeerManager;
import haveno.network.p2p.peers.getdata.GetDataRequestHandler;
import haveno.network.p2p.peers.getdata.RequestDataHandler;
import haveno.network.p2p.peers.getdata.messages.GetDataRequest;
import haveno.network.p2p.peers.peerexchange.Peer;
import haveno.network.p2p.seed.SeedNodeRepository;
import haveno.network.p2p.storage.P2PDataStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDataManager
implements MessageListener,
ConnectionListener,
PeerManager.Listener {
    private static final Logger log = LoggerFactory.getLogger(RequestDataManager.class);
    private static final long RETRY_DELAY_SEC = 10L;
    private static final long CLEANUP_TIMER = 120L;
    private static int NUM_SEEDS_FOR_PRELIMINARY_REQUEST = 2;
    private static int NUM_ADDITIONAL_SEEDS_FOR_UPDATE_REQUEST = 1;
    private static int MAX_REPEATED_REQUESTS = 30;
    private boolean isPreliminaryDataRequest = true;
    private final NetworkNode networkNode;
    private final P2PDataStorage dataStorage;
    private final PeerManager peerManager;
    private final List<NodeAddress> seedNodeAddresses;
    private final List<ResponseListener> responseListeners = new CopyOnWriteArrayList<ResponseListener>();
    private Listener listener;
    private final Map<NodeAddress, RequestDataHandler> handlerMap = new HashMap<NodeAddress, RequestDataHandler>();
    private final Map<String, GetDataRequestHandler> getDataRequestHandlers = new HashMap<String, GetDataRequestHandler>();
    private Optional<NodeAddress> nodeAddressOfPreliminaryDataRequest = Optional.empty();
    private Timer retryTimer;
    private boolean dataUpdateRequested;
    private boolean allDataReceived;
    private boolean stopped;
    private int numRepeatedRequests = 0;

    @Inject
    public RequestDataManager(NetworkNode networkNode, SeedNodeRepository seedNodeRepository, P2PDataStorage dataStorage, PeerManager peerManager) {
        this.networkNode = networkNode;
        this.dataStorage = dataStorage;
        this.peerManager = peerManager;
        this.networkNode.addMessageListener(this);
        this.networkNode.addConnectionListener(this);
        this.peerManager.addListener(this);
        this.seedNodeAddresses = new ArrayList<NodeAddress>(seedNodeRepository.getSeedNodeAddresses());
        Collections.shuffle(this.seedNodeAddresses);
        this.networkNode.nodeAddressProperty().addListener((observable, oldValue, myAddress) -> {
            if (myAddress != null) {
                this.seedNodeAddresses.remove(myAddress);
                if (seedNodeRepository.isSeedNode((NodeAddress)myAddress)) {
                    NUM_SEEDS_FOR_PRELIMINARY_REQUEST = 3;
                    NUM_ADDITIONAL_SEEDS_FOR_UPDATE_REQUEST = 2;
                    MAX_REPEATED_REQUESTS = 100;
                }
            }
        });
    }

    public void shutDown() {
        this.stopped = true;
        this.stopRetryTimer();
        this.networkNode.removeMessageListener(this);
        this.networkNode.removeConnectionListener(this);
        this.peerManager.removeListener(this);
        this.closeAllHandlers();
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void requestPreliminaryData() {
        ArrayList<NodeAddress> nodeAddresses = new ArrayList<NodeAddress>(this.seedNodeAddresses);
        if (!nodeAddresses.isEmpty()) {
            ArrayList<NodeAddress> finalNodeAddresses = new ArrayList<NodeAddress>(nodeAddresses);
            int size = Math.min(NUM_SEEDS_FOR_PRELIMINARY_REQUEST, finalNodeAddresses.size());
            for (int i = 0; i < size; ++i) {
                NodeAddress nodeAddress = finalNodeAddresses.get(i);
                nodeAddresses.remove(nodeAddress);
                ArrayList<NodeAddress> remainingNodeAddresses = new ArrayList<NodeAddress>(nodeAddresses);
                UserThread.runAfter(() -> this.requestData(nodeAddress, remainingNodeAddresses), (long)(i * 200 + 1), (TimeUnit)TimeUnit.MILLISECONDS);
            }
            this.isPreliminaryDataRequest = true;
        } else {
            ((Listener)Preconditions.checkNotNull((Object)this.listener)).onNoSeedNodeAvailable();
        }
    }

    public void requestUpdateData() {
        Preconditions.checkArgument((boolean)this.nodeAddressOfPreliminaryDataRequest.isPresent(), (Object)"nodeAddressOfPreliminaryDataRequest must be present");
        this.dataUpdateRequested = true;
        this.isPreliminaryDataRequest = false;
        ArrayList<NodeAddress> nodeAddresses = new ArrayList<NodeAddress>(this.seedNodeAddresses);
        if (!nodeAddresses.isEmpty()) {
            this.nodeAddressOfPreliminaryDataRequest.ifPresent(candidate -> {
                nodeAddresses.remove(candidate);
                this.requestData((NodeAddress)candidate, (List<NodeAddress>)nodeAddresses);
                ArrayList finalNodeAddresses = new ArrayList(nodeAddresses);
                int numRequests = 0;
                for (int i = 0; i < finalNodeAddresses.size() && numRequests < NUM_ADDITIONAL_SEEDS_FOR_UPDATE_REQUEST; ++i) {
                    NodeAddress nodeAddress = (NodeAddress)finalNodeAddresses.get(i);
                    nodeAddresses.remove(nodeAddress);
                    if (this.handlerMap.containsKey(nodeAddress)) continue;
                    UserThread.runAfter(() -> this.requestData(nodeAddress, nodeAddresses), (long)(i * 200 + 1), (TimeUnit)TimeUnit.MILLISECONDS);
                    ++numRequests;
                }
            });
        }
    }

    public Optional<NodeAddress> getNodeAddressOfPreliminaryDataRequest() {
        return this.nodeAddressOfPreliminaryDataRequest;
    }

    public void addResponseListener(ResponseListener responseListener) {
        this.responseListeners.add(responseListener);
    }

    @Override
    public void onConnection(Connection connection) {
    }

    @Override
    public void onDisconnect(CloseConnectionReason closeConnectionReason, Connection connection) {
        this.closeHandler(connection);
        if (this.peerManager.isPeerBanned(closeConnectionReason, connection) && connection.getPeersNodeAddressOptional().isPresent()) {
            NodeAddress nodeAddress = connection.getPeersNodeAddressOptional().get();
            this.seedNodeAddresses.remove(nodeAddress);
            this.handlerMap.remove(nodeAddress);
        }
    }

    @Override
    public void onAllConnectionsLost() {
        this.closeAllHandlers();
        this.stopRetryTimer();
        this.stopped = true;
        this.restart();
    }

    @Override
    public void onNewConnectionAfterAllConnectionsLost() {
        this.closeAllHandlers();
        this.stopped = false;
        this.restart();
    }

    @Override
    public void onAwakeFromStandby() {
        this.closeAllHandlers();
        this.stopped = false;
        if (!this.networkNode.getAllConnections().isEmpty()) {
            this.restart();
        }
    }

    @Override
    public void onMessage(NetworkEnvelope networkEnvelope, final Connection connection) {
        if (networkEnvelope instanceof GetDataRequest) {
            if (!this.stopped) {
                GetDataRequest getDataRequest = (GetDataRequest)networkEnvelope;
                if (getDataRequest.getVersion() == null || !Version.isNewVersion((String)getDataRequest.getVersion(), (String)"0.0.0")) {
                    connection.shutDown(CloseConnectionReason.MANDATORY_CAPABILITIES_NOT_SUPPORTED);
                    return;
                }
                final String uid = connection.getUid();
                if (!this.getDataRequestHandlers.containsKey(uid)) {
                    GetDataRequestHandler getDataRequestHandler = new GetDataRequestHandler(this.networkNode, this.dataStorage, new GetDataRequestHandler.Listener(){

                        @Override
                        public void onComplete(int serializedSize) {
                            RequestDataManager.this.getDataRequestHandlers.remove(uid);
                            log.trace("requestDataHandshake completed.\n\tConnection={}", (Object)connection);
                            RequestDataManager.this.responseListeners.forEach(listener -> listener.onSuccess(serializedSize));
                        }

                        @Override
                        public void onFault(String errorMessage, @Nullable Connection connection2) {
                            RequestDataManager.this.getDataRequestHandlers.remove(uid);
                            if (!RequestDataManager.this.stopped) {
                                log.trace("GetDataRequestHandler failed.\n\tConnection={}\n\tErrorMessage={}", (Object)connection2, (Object)errorMessage);
                                RequestDataManager.this.peerManager.handleConnectionFault(connection2);
                                RequestDataManager.this.responseListeners.forEach(ResponseListener::onFault);
                            } else {
                                log.warn("We have stopped already. We ignore that getDataRequestHandler.handle.onFault call.");
                            }
                        }
                    });
                    this.getDataRequestHandlers.put(uid, getDataRequestHandler);
                    getDataRequestHandler.handle(getDataRequest, connection);
                } else {
                    log.warn("We have already a GetDataRequestHandler for that connection started. We start a cleanup timer if the handler has not closed by itself in between 2 minutes.");
                    UserThread.runAfter(() -> {
                        if (this.getDataRequestHandlers.containsKey(uid)) {
                            GetDataRequestHandler handler = this.getDataRequestHandlers.get(uid);
                            handler.stop();
                            this.getDataRequestHandlers.remove(uid);
                        }
                    }, (long)120L);
                }
            } else {
                log.warn("We have stopped already. We ignore that onMessage call.");
            }
        }
    }

    private void requestData(final NodeAddress nodeAddress, final List<NodeAddress> remainingNodeAddresses) {
        if (!this.stopped) {
            if (!this.handlerMap.containsKey(nodeAddress)) {
                RequestDataHandler requestDataHandler = new RequestDataHandler(this.networkNode, this.dataStorage, this.peerManager, new RequestDataHandler.Listener(){

                    @Override
                    public void onComplete(boolean wasTruncated) {
                        log.trace("RequestDataHandshake of outbound connection complete. nodeAddress={}", (Object)nodeAddress);
                        RequestDataManager.this.stopRetryTimer();
                        RequestDataManager.this.handlerMap.remove(nodeAddress);
                        if (!RequestDataManager.this.nodeAddressOfPreliminaryDataRequest.isPresent()) {
                            RequestDataManager.this.nodeAddressOfPreliminaryDataRequest = Optional.of(nodeAddress);
                            UserThread.runAfter(((Listener)Preconditions.checkNotNull((Object)RequestDataManager.this.listener))::onPreliminaryDataReceived, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                        }
                        if (RequestDataManager.this.dataUpdateRequested) {
                            RequestDataManager.this.dataUpdateRequested = false;
                            ((Listener)Preconditions.checkNotNull((Object)RequestDataManager.this.listener)).onUpdatedDataReceived();
                        }
                        if (wasTruncated) {
                            if (RequestDataManager.this.numRepeatedRequests < MAX_REPEATED_REQUESTS) {
                                log.info("DataResponse did not contain all data, so we repeat request until we got all data");
                                UserThread.runAfter(() -> RequestDataManager.this.requestData(nodeAddress, remainingNodeAddresses), (long)2L);
                            } else if (!RequestDataManager.this.allDataReceived) {
                                RequestDataManager.this.allDataReceived = true;
                                log.warn("\n#################################################################\nLoading initial data from {} did not complete after 20 repeated requests. \n#################################################################\n", (Object)nodeAddress);
                                ((Listener)Preconditions.checkNotNull((Object)RequestDataManager.this.listener)).onDataReceived();
                            }
                        } else if (!RequestDataManager.this.allDataReceived) {
                            RequestDataManager.this.allDataReceived = true;
                            log.info("\n\n#################################################################\nLoading initial data from {} completed\n#################################################################\n", (Object)nodeAddress);
                            ((Listener)Preconditions.checkNotNull((Object)RequestDataManager.this.listener)).onDataReceived();
                        }
                    }

                    @Override
                    public void onFault(String errorMessage, @Nullable Connection connection) {
                        log.trace("requestDataHandshake with outbound connection failed.\n\tnodeAddress={}\n\tErrorMessage={}", (Object)nodeAddress, (Object)errorMessage);
                        RequestDataManager.this.peerManager.handleConnectionFault(nodeAddress);
                        RequestDataManager.this.handlerMap.remove(nodeAddress);
                        if (!remainingNodeAddresses.isEmpty()) {
                            log.debug("There are remaining nodes available for requesting data. We will try requestDataFromPeers again.");
                            NodeAddress nextCandidate = (NodeAddress)remainingNodeAddresses.get(0);
                            remainingNodeAddresses.remove(nextCandidate);
                            RequestDataManager.this.requestData(nextCandidate, remainingNodeAddresses);
                        } else if (RequestDataManager.this.handlerMap.isEmpty()) {
                            log.debug("There is no remaining node available for requesting data. That is expected if no other node is online.\n\tWe will try to use reported peers (if no available we use persisted peers) and try again to request data from our seed nodes after a random pause.");
                            if (!RequestDataManager.this.nodeAddressOfPreliminaryDataRequest.isPresent()) {
                                if (RequestDataManager.this.peerManager.isSeedNode(nodeAddress)) {
                                    ((Listener)Preconditions.checkNotNull((Object)RequestDataManager.this.listener)).onNoSeedNodeAvailable();
                                } else {
                                    ((Listener)Preconditions.checkNotNull((Object)RequestDataManager.this.listener)).onNoPeersAvailable();
                                }
                            }
                            RequestDataManager.this.requestFromNonSeedNodePeers();
                        } else {
                            log.info("We could not connect to seed node {} but we have other connection attempts open.", (Object)nodeAddress.getFullAddress());
                        }
                    }
                });
                this.handlerMap.put(nodeAddress, requestDataHandler);
                ++this.numRepeatedRequests;
                requestDataHandler.requestData(nodeAddress, this.isPreliminaryDataRequest);
            } else {
                log.warn("We have started already a requestDataHandshake to peer. nodeAddress=" + String.valueOf(nodeAddress) + "\nWe start a cleanup timer if the handler has not closed by itself in between 2 minutes.");
                UserThread.runAfter(() -> {
                    if (this.handlerMap.containsKey(nodeAddress)) {
                        RequestDataHandler handler = this.handlerMap.get(nodeAddress);
                        handler.stop();
                        this.handlerMap.remove(nodeAddress);
                    }
                }, (long)120L);
            }
        } else {
            log.warn("We have stopped already. We ignore that requestData call.");
        }
    }

    private void requestFromNonSeedNodePeers() {
        List<NodeAddress> list = this.getFilteredNonSeedNodeList(this.getSortedNodeAddresses(this.peerManager.getReportedPeers()), new ArrayList<NodeAddress>());
        List<NodeAddress> filteredPersistedPeers = this.getFilteredNonSeedNodeList(this.getSortedNodeAddresses(this.peerManager.getPersistedPeers()), list);
        list.addAll(filteredPersistedPeers);
        if (!list.isEmpty()) {
            NodeAddress nextCandidate = list.get(0);
            list.remove(nextCandidate);
            this.requestData(nextCandidate, list);
        }
    }

    private void restart() {
        if (this.retryTimer == null) {
            this.retryTimer = UserThread.runAfter(() -> {
                this.stopped = false;
                this.stopRetryTimer();
                List<NodeAddress> list = this.getFilteredList(new ArrayList<NodeAddress>(this.seedNodeAddresses), new ArrayList<NodeAddress>());
                Collections.shuffle(list);
                List<NodeAddress> filteredReportedPeers = this.getFilteredNonSeedNodeList(this.getSortedNodeAddresses(this.peerManager.getReportedPeers()), list);
                list.addAll(filteredReportedPeers);
                List<NodeAddress> filteredPersistedPeers = this.getFilteredNonSeedNodeList(this.getSortedNodeAddresses(this.peerManager.getPersistedPeers()), list);
                list.addAll(filteredPersistedPeers);
                if (!list.isEmpty()) {
                    NodeAddress nextCandidate = list.get(0);
                    list.remove(nextCandidate);
                    this.requestData(nextCandidate, list);
                }
            }, (long)10L);
        }
    }

    private List<NodeAddress> getSortedNodeAddresses(Collection<Peer> collection) {
        return new ArrayList<Peer>(collection).stream().sorted((o1, o2) -> o2.getDate().compareTo(o1.getDate())).map(Peer::getNodeAddress).collect(Collectors.toList());
    }

    private List<NodeAddress> getFilteredList(Collection<NodeAddress> collection, List<NodeAddress> list) {
        return collection.stream().filter(e -> !list.contains(e) && !this.peerManager.isSelf((NodeAddress)e)).collect(Collectors.toList());
    }

    private List<NodeAddress> getFilteredNonSeedNodeList(Collection<NodeAddress> collection, List<NodeAddress> list) {
        return this.getFilteredList(collection, list).stream().filter(e -> !this.peerManager.isSeedNode((NodeAddress)e)).collect(Collectors.toList());
    }

    private void stopRetryTimer() {
        if (this.retryTimer != null) {
            this.retryTimer.stop();
            this.retryTimer = null;
        }
    }

    private void closeHandler(Connection connection) {
        Optional<NodeAddress> peersNodeAddressOptional = connection.getPeersNodeAddressOptional();
        if (peersNodeAddressOptional.isPresent()) {
            NodeAddress nodeAddress = peersNodeAddressOptional.get();
            if (this.handlerMap.containsKey(nodeAddress)) {
                this.handlerMap.get(nodeAddress).cancel();
                this.handlerMap.remove(nodeAddress);
            }
        } else {
            log.trace("closeRequestDataHandler: nodeAddress not set in connection {}", (Object)connection);
        }
    }

    private void closeAllHandlers() {
        this.handlerMap.values().forEach(RequestDataHandler::cancel);
        this.handlerMap.clear();
    }

    public static interface Listener {
        public void onPreliminaryDataReceived();

        public void onUpdatedDataReceived();

        public void onDataReceived();

        default public void onNoPeersAvailable() {
        }

        default public void onNoSeedNodeAvailable() {
        }
    }

    public static interface ResponseListener {
        public void onSuccess(int var1);

        public void onFault();
    }
}

