/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.peers.getdata;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.proto.network.NetworkPayload;
import haveno.common.util.Tuple2;
import haveno.common.util.Utilities;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.peers.PeerManager;
import haveno.network.p2p.peers.getdata.messages.GetDataRequest;
import haveno.network.p2p.peers.getdata.messages.GetDataResponse;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.payload.PersistableNetworkPayload;
import haveno.network.p2p.storage.payload.ProtectedStorageEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestDataHandler
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(RequestDataHandler.class);
    private static final long TIMEOUT = 240L;
    private NodeAddress peersNodeAddress;
    private String getDataRequestType;
    private final NetworkNode networkNode;
    private final P2PDataStorage dataStorage;
    private final PeerManager peerManager;
    private final Listener listener;
    private Timer timeoutTimer;
    private final int nonce = new Random().nextInt();
    private boolean stopped;

    RequestDataHandler(NetworkNode networkNode, P2PDataStorage dataStorage, PeerManager peerManager, Listener listener) {
        this.networkNode = networkNode;
        this.dataStorage = dataStorage;
        this.peerManager = peerManager;
        this.listener = listener;
    }

    public void cancel() {
        this.cleanup();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void requestData(final NodeAddress nodeAddress, boolean isPreliminaryDataRequest) {
        this.peersNodeAddress = nodeAddress;
        if (!this.stopped) {
            final GetDataRequest getDataRequest = isPreliminaryDataRequest ? this.dataStorage.buildPreliminaryGetDataRequest(this.nonce) : this.dataStorage.buildGetUpdatedDataRequest(this.networkNode.getNodeAddress(), this.nonce);
            if (this.timeoutTimer == null) {
                this.timeoutTimer = UserThread.runAfter(() -> {
                    if (!this.stopped) {
                        String errorMessage = "A timeout occurred at sending getDataRequest:" + String.valueOf(getDataRequest) + " on nodeAddress:" + String.valueOf(nodeAddress);
                        log.debug(errorMessage + " / RequestDataHandler=" + String.valueOf(this));
                        this.handleFault(errorMessage, nodeAddress, CloseConnectionReason.SEND_MSG_TIMEOUT);
                    } else {
                        log.trace("We have stopped already. We ignore that timeoutTimer.run call. Might be caused by a previous networkNode.sendMessage.onFailure.");
                    }
                }, (long)240L);
            }
            this.getDataRequestType = getDataRequest.getClass().getSimpleName();
            log.info("\n\n>> We send a {} to peer {}\n", (Object)this.getDataRequestType, (Object)nodeAddress);
            this.networkNode.addMessageListener(this);
            try {
                SettableFuture<Connection> future = this.networkNode.sendMessage(nodeAddress, (NetworkEnvelope)getDataRequest);
                Futures.addCallback(future, (FutureCallback)new FutureCallback<Connection>(){

                    public void onSuccess(Connection connection) {
                        if (!RequestDataHandler.this.stopped) {
                            log.trace("Send {} to {} succeeded.", (Object)getDataRequest, (Object)nodeAddress);
                        } else {
                            log.trace("We have stopped already. We ignore that networkNode.sendMessage.onSuccess call.Might be caused by a previous timeout.");
                        }
                    }

                    public void onFailure(@NotNull Throwable throwable) {
                        if (!RequestDataHandler.this.stopped) {
                            String errorMessage = "Sending getDataRequest to " + String.valueOf(nodeAddress) + " failed. That is expected if the peer is offline.\n\tgetDataRequest=" + String.valueOf(getDataRequest) + ".\n\tException=" + throwable.getMessage();
                            RequestDataHandler.this.handleFault(errorMessage, nodeAddress, CloseConnectionReason.SEND_MSG_FAILURE);
                        } else {
                            log.trace("We have stopped already. We ignore that networkNode.sendMessage.onFailure call. Might be caused by a previous timeout.");
                        }
                    }
                }, (Executor)MoreExecutors.directExecutor());
                return;
            }
            catch (Exception e) {
                if (this.networkNode.isShutDownStarted()) return;
                throw e;
            }
        } else {
            log.warn("We have stopped already. We ignore that requestData call.");
        }
    }

    @Override
    public void onMessage(NetworkEnvelope networkEnvelope, Connection connection) {
        if (networkEnvelope instanceof GetDataResponse) {
            if (connection.getPeersNodeAddressOptional().isPresent() && connection.getPeersNodeAddressOptional().get().equals(this.peersNodeAddress)) {
                if (!this.stopped) {
                    long ts1 = System.currentTimeMillis();
                    GetDataResponse getDataResponse = (GetDataResponse)networkEnvelope;
                    this.logContents(getDataResponse);
                    if (getDataResponse.getRequestNonce() == this.nonce) {
                        this.stopTimeoutTimer();
                        if (!connection.getPeersNodeAddressOptional().isPresent()) {
                            log.error("RequestDataHandler.onMessage: connection.getPeersNodeAddressOptional() must be present at that moment");
                            return;
                        }
                        this.dataStorage.processGetDataResponse(getDataResponse, connection.getPeersNodeAddressOptional().get());
                        this.cleanup();
                        this.listener.onComplete(getDataResponse.isWasTruncated());
                    } else {
                        log.warn("Nonce not matching. That can happen rarely if we get a response after a canceled handshake (timeout causes connection close but peer might have sent a msg before connection was closed).\n\tWe drop that message. nonce={} / requestNonce={}", (Object)this.nonce, (Object)getDataResponse.getRequestNonce());
                    }
                    log.info("Processing GetDataResponse took {} ms", (Object)(System.currentTimeMillis() - ts1));
                } else {
                    log.warn("We have stopped already. We ignore that onDataRequest call.");
                }
            } else {
                log.debug("We got the message from another connection and ignore it on that handler. That is expected if we have several requests open.");
            }
        }
    }

    public void stop() {
        this.cleanup();
    }

    private void logContents(GetDataResponse getDataResponse) {
        Set<ProtectedStorageEntry> dataSet = getDataResponse.getDataSet();
        Set<PersistableNetworkPayload> persistableNetworkPayloadSet = getDataResponse.getPersistableNetworkPayloadSet();
        HashMap<String, Tuple2> numPayloadsByClassName = new HashMap<String, Tuple2>();
        dataSet.forEach(protectedStorageEntry -> {
            String className = protectedStorageEntry.getProtectedStoragePayload().getClass().getSimpleName();
            this.addDetails((Map<String, Tuple2<AtomicInteger, AtomicInteger>>)numPayloadsByClassName, (NetworkPayload)protectedStorageEntry, className);
        });
        persistableNetworkPayloadSet.forEach(persistableNetworkPayload -> {
            String className = persistableNetworkPayload.getClass().getSimpleName();
            this.addDetails((Map<String, Tuple2<AtomicInteger, AtomicInteger>>)numPayloadsByClassName, (NetworkPayload)persistableNetworkPayload, className);
        });
        StringBuilder sb = new StringBuilder();
        String sep = System.lineSeparator();
        sb.append(sep).append("#################################################################").append(sep);
        sb.append("Data provided by node: ").append(this.peersNodeAddress.getFullAddress()).append(sep);
        int items = dataSet.size() + persistableNetworkPayloadSet.size();
        sb.append("Received ").append(items).append(" instances from a ").append(this.getDataRequestType).append(sep);
        numPayloadsByClassName.forEach((key, value) -> sb.append((String)key).append(": ").append(((AtomicInteger)value.first).get()).append(" / ").append(Utilities.readableFileSize((long)((AtomicInteger)value.second).get())).append(sep));
        sb.append("#################################################################\n");
        log.info(sb.toString());
    }

    private void addDetails(Map<String, Tuple2<AtomicInteger, AtomicInteger>> numPayloadsByClassName, NetworkPayload networkPayload, String className) {
        numPayloadsByClassName.putIfAbsent(className, (Tuple2<AtomicInteger, AtomicInteger>)new Tuple2((Object)new AtomicInteger(0), (Object)new AtomicInteger(0)));
        ((AtomicInteger)numPayloadsByClassName.get((Object)className).first).getAndIncrement();
        ((AtomicInteger)numPayloadsByClassName.get((Object)className).second).getAndAdd(networkPayload.toProtoMessage().getSerializedSize());
    }

    private void handleFault(String errorMessage, NodeAddress nodeAddress, CloseConnectionReason closeConnectionReason) {
        this.cleanup();
        log.info(errorMessage);
        this.peerManager.handleConnectionFault(nodeAddress);
        this.listener.onFault(errorMessage, null);
    }

    private void cleanup() {
        this.stopped = true;
        this.networkNode.removeMessageListener(this);
        this.stopTimeoutTimer();
    }

    private void stopTimeoutTimer() {
        if (this.timeoutTimer != null) {
            this.timeoutTimer.stop();
            this.timeoutTimer = null;
        }
    }

    public static interface Listener {
        public void onComplete(boolean var1);

        public void onFault(String var1, @Nullable Connection var2);
    }
}

