/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.peers.getdata;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.peers.getdata.messages.GetDataRequest;
import haveno.network.p2p.peers.getdata.messages.GetDataResponse;
import haveno.network.p2p.storage.P2PDataStorage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDataRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(GetDataRequestHandler.class);
    private static final long TIMEOUT = 240L;
    private static final int MAX_ENTRIES = 5000;
    private final NetworkNode networkNode;
    private final P2PDataStorage dataStorage;
    private final Listener listener;
    private Timer timeoutTimer;
    private boolean stopped;

    public GetDataRequestHandler(NetworkNode networkNode, P2PDataStorage dataStorage, Listener listener) {
        this.networkNode = networkNode;
        this.dataStorage = dataStorage;
        this.listener = listener;
    }

    public void handle(GetDataRequest getDataRequest, final Connection connection) {
        long ts = System.currentTimeMillis();
        String connectionInfo = "connectionInfo" + connection.getPeersNodeAddressOptional().map(e -> "node address " + e.getFullAddress()).orElseGet(() -> "connection UID " + connection.getUid());
        AtomicBoolean wasPersistableNetworkPayloadsTruncated = new AtomicBoolean(false);
        AtomicBoolean wasProtectedStorageEntriesTruncated = new AtomicBoolean(false);
        final GetDataResponse getDataResponse = this.dataStorage.buildGetDataResponse(getDataRequest, 5000, wasPersistableNetworkPayloadsTruncated, wasProtectedStorageEntriesTruncated, connection.getCapabilities());
        if (wasPersistableNetworkPayloadsTruncated.get()) {
            log.info("The getDataResponse for peer {} got truncated.", (Object)connectionInfo);
        }
        if (wasProtectedStorageEntriesTruncated.get()) {
            log.info("The getDataResponse for peer {} got truncated.", (Object)connectionInfo);
        }
        log.info("The getDataResponse to peer with {} contains {} ProtectedStorageEntries and {} PersistableNetworkPayloads", new Object[]{connectionInfo, getDataResponse.getDataSet().size(), getDataResponse.getPersistableNetworkPayloadSet().size()});
        if (this.timeoutTimer == null) {
            this.timeoutTimer = UserThread.runAfter(() -> {
                String errorMessage = "A timeout occurred for getDataResponse  on connection:" + String.valueOf(connection);
                this.handleFault(errorMessage, CloseConnectionReason.SEND_MSG_TIMEOUT, connection);
            }, (long)240L, (TimeUnit)TimeUnit.SECONDS);
        }
        SettableFuture<Connection> future = this.networkNode.sendMessage(connection, (NetworkEnvelope)getDataResponse);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Connection>(){

            public void onSuccess(Connection connection2) {
                if (!GetDataRequestHandler.this.stopped) {
                    log.trace("Send DataResponse to {} succeeded. getDataResponse={}", connection2.getPeersNodeAddressOptional(), (Object)getDataResponse);
                    GetDataRequestHandler.this.listener.onComplete(getDataResponse.toProtoNetworkEnvelope().getSerializedSize());
                    GetDataRequestHandler.this.cleanup();
                } else {
                    log.trace("We have stopped already. We ignore that networkNode.sendMessage.onSuccess call.");
                }
            }

            public void onFailure(@NotNull Throwable throwable) {
                if (!GetDataRequestHandler.this.stopped) {
                    String errorMessage = "Sending getDataResponse to " + String.valueOf(connection) + " failed. That is expected if the peer is offline. getDataResponse=" + String.valueOf(getDataResponse) + ".Exception: " + throwable.getMessage();
                    GetDataRequestHandler.this.handleFault(errorMessage, CloseConnectionReason.SEND_MSG_FAILURE, connection);
                } else {
                    log.trace("We have stopped already. We ignore that networkNode.sendMessage.onFailure call.");
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
        log.info("handle GetDataRequest took {} ms", (Object)(System.currentTimeMillis() - ts));
    }

    public void stop() {
        this.cleanup();
    }

    private void handleFault(String errorMessage, CloseConnectionReason closeConnectionReason, Connection connection) {
        if (!this.stopped) {
            log.info(errorMessage + "\n\tcloseConnectionReason=" + String.valueOf((Object)closeConnectionReason));
            this.cleanup();
            this.listener.onFault(errorMessage, connection);
        } else {
            log.warn("We have already stopped (handleFault)");
        }
    }

    private void cleanup() {
        this.stopped = true;
        if (this.timeoutTimer != null) {
            this.timeoutTimer.stop();
            this.timeoutTimer = null;
        }
    }

    public static interface Listener {
        public void onComplete(int var1);

        public void onFault(String var1, Connection var2);
    }
}

