/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.network;

import com.google.common.base.Preconditions;
import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.proto.network.NetworkProtoResolver;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.BanFilter;
import haveno.network.p2p.network.SetupListener;
import haveno.network.p2p.network.TorMode;
import haveno.network.p2p.network.TorNetworkNode;
import haveno.network.utils.Utils;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Base64;
import org.berndpruenster.netlayer.tor.HiddenServiceSocket;
import org.berndpruenster.netlayer.tor.Tor;
import org.berndpruenster.netlayer.tor.TorCtlException;
import org.berndpruenster.netlayer.tor.TorSocket;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorNetworkNodeNetlayer
extends TorNetworkNode {
    private static final Logger log = LoggerFactory.getLogger(TorNetworkNodeNetlayer.class);
    private static final long SHUT_DOWN_TIMEOUT = 2L;
    private HiddenServiceSocket hiddenServiceSocket;
    private boolean streamIsolation;
    private Socks5Proxy socksProxy;
    protected TorMode torMode;
    private Tor tor;
    private final String torControlHost;
    private Timer shutDownTimeoutTimer;
    private boolean isShutDownStarted;
    private boolean isShutDownComplete;

    public TorNetworkNodeNetlayer(int servicePort, NetworkProtoResolver networkProtoResolver, TorMode torMode, @Nullable BanFilter banFilter, int maxConnections, boolean useStreamIsolation, String torControlHost) {
        super(servicePort, networkProtoResolver, banFilter, maxConnections);
        this.torControlHost = torControlHost;
        this.streamIsolation = useStreamIsolation;
        this.torMode = torMode;
    }

    @Override
    public void start(@Nullable SetupListener setupListener) {
        this.torMode.doRollingBackup();
        super.start(setupListener);
    }

    @Override
    public void shutDown(@Nullable Runnable shutDownCompleteHandler) {
        log.info("TorNetworkNodeNetlayer shutdown started");
        if (this.isShutDownComplete) {
            log.info("TorNetworkNodeNetlayer shutdown already completed");
            if (shutDownCompleteHandler != null) {
                shutDownCompleteHandler.run();
            }
            return;
        }
        if (this.isShutDownStarted) {
            log.warn("Ignoring request to shut down because shut down already started");
            return;
        }
        this.isShutDownStarted = true;
        this.shutDownTimeoutTimer = UserThread.runAfter(() -> {
            log.error("A timeout occurred at shutDown");
            this.isShutDownComplete = true;
            if (shutDownCompleteHandler != null) {
                shutDownCompleteHandler.run();
            }
            this.executor.shutdownNow();
        }, (long)2L);
        super.shutDown(() -> {
            try {
                this.tor = Tor.getDefault();
                if (this.tor != null) {
                    this.tor.shutdown();
                    this.tor = null;
                    log.info("Tor shutdown completed");
                }
                this.executor.shutdownNow();
            }
            catch (Throwable e) {
                log.error("Shutdown TorNetworkNodeNetlayer failed with exception", e);
            }
            finally {
                this.shutDownTimeoutTimer.stop();
                this.isShutDownComplete = true;
                if (shutDownCompleteHandler != null) {
                    shutDownCompleteHandler.run();
                }
            }
        });
    }

    @Override
    protected Socket createSocket(NodeAddress peerNodeAddress) throws IOException {
        Preconditions.checkArgument((boolean)peerNodeAddress.getHostName().endsWith(".onion"), (Object)"PeerAddress is not an onion address");
        return new TorSocket(peerNodeAddress.getHostName(), peerNodeAddress.getPort(), this.torControlHost, null);
    }

    @Override
    public Socks5Proxy getSocksProxy() {
        try {
            String stream = null;
            if (this.streamIsolation) {
                byte[] bytes = new byte[512];
                new SecureRandom().nextBytes(bytes);
                stream = Base64.getEncoder().encodeToString(bytes);
            }
            if (this.socksProxy == null || this.streamIsolation) {
                this.tor = Tor.getDefault();
                this.socksProxy = this.tor != null ? this.tor.getProxy(this.torControlHost, stream) : null;
            }
            return this.socksProxy;
        }
        catch (Throwable t) {
            log.error("Error at getSocksProxy", t);
            return null;
        }
    }

    @Override
    protected void createTorAndHiddenService() {
        int localPort = Utils.findFreeSystemPort();
        this.executor.submit(() -> {
            try {
                Tor.setDefault((Tor)this.torMode.getTor());
                long ts = System.currentTimeMillis();
                this.hiddenServiceSocket = new HiddenServiceSocket(localPort, this.torMode.getHiddenServiceDirectory(), this.servicePort);
                this.nodeAddressProperty.set((Object)new NodeAddress(this.hiddenServiceSocket.getServiceName() + ":" + this.hiddenServiceSocket.getHiddenServicePort()));
                UserThread.execute(() -> this.setupListeners.forEach(SetupListener::onTorNodeReady));
                this.hiddenServiceSocket.addReadyListener(socket -> {
                    log.info("\n################################################################\nTor hidden service published after {} ms. Socket={}\n################################################################", (Object)(System.currentTimeMillis() - ts), socket);
                    UserThread.execute(() -> {
                        this.nodeAddressProperty.set((Object)new NodeAddress(this.hiddenServiceSocket.getServiceName() + ":" + this.hiddenServiceSocket.getHiddenServicePort()));
                        this.startServer((ServerSocket)socket);
                        this.setupListeners.forEach(SetupListener::onHiddenServicePublished);
                    });
                    return null;
                });
            }
            catch (TorCtlException e) {
                log.error("Starting tor node failed", (Throwable)e);
                if (e.getCause() instanceof IOException) {
                    UserThread.execute(() -> this.setupListeners.forEach(s -> s.onSetupFailed(new RuntimeException(e.getMessage()))));
                } else {
                    UserThread.execute(() -> this.setupListeners.forEach(SetupListener::onRequestCustomBridges));
                    log.warn("We shutdown as starting tor with the default bridges failed. We request user to add custom bridges.");
                    this.shutDown(null);
                }
            }
            catch (IOException e) {
                log.error("Could not connect to running Tor", (Throwable)e);
                UserThread.execute(() -> this.setupListeners.forEach(s -> s.onSetupFailed(new RuntimeException(e.getMessage()))));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        });
    }
}

