/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.network;

import com.google.common.base.Preconditions;
import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import haveno.common.UserThread;
import haveno.common.proto.network.NetworkProtoResolver;
import haveno.common.util.Hex;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.BanFilter;
import haveno.network.p2p.network.SetupListener;
import haveno.network.p2p.network.TorNetworkNode;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorNetworkNodeDirectBind
extends TorNetworkNode {
    private static final Logger log = LoggerFactory.getLogger(TorNetworkNodeDirectBind.class);
    private static final int TOR_DATA_PORT = 9050;
    private final String serviceAddress;

    public TorNetworkNodeDirectBind(int servicePort, NetworkProtoResolver networkProtoResolver, @Nullable BanFilter banFilter, int maxConnections, String hiddenServiceAddress) {
        super(servicePort, networkProtoResolver, banFilter, maxConnections);
        this.serviceAddress = hiddenServiceAddress;
    }

    @Override
    public void shutDown(@Nullable Runnable shutDownCompleteHandler) {
        super.shutDown(() -> {
            log.info("TorNetworkNodeDirectBind shutdown completed");
            if (shutDownCompleteHandler != null) {
                shutDownCompleteHandler.run();
            }
        });
    }

    @Override
    public Socks5Proxy getSocksProxy() {
        Socks5Proxy proxy = new Socks5Proxy(InetAddress.getLoopbackAddress(), 9050);
        proxy.resolveAddrLocally(false);
        return proxy;
    }

    @Override
    protected Socket createSocket(NodeAddress peerNodeAddress) throws IOException {
        try {
            Preconditions.checkArgument((boolean)peerNodeAddress.getHostName().endsWith(".onion"), (Object)"PeerAddress is not an onion address");
            Socket sock = new Socket(InetAddress.getLoopbackAddress(), 9050);
            sock.getOutputStream().write(Hex.decode((String)"050100"));
            String response = Hex.encode((byte[])sock.getInputStream().readNBytes(2));
            if (!response.equalsIgnoreCase("0500")) {
                return null;
            }
            String connect_details = "050100033E" + Hex.encode((byte[])peerNodeAddress.getHostName().getBytes(StandardCharsets.UTF_8));
            StringBuilder connect_port = new StringBuilder(Integer.toHexString(peerNodeAddress.getPort()));
            while (connect_port.length() < 4) {
                connect_port.insert(0, "0");
            }
            connect_details = connect_details + String.valueOf(connect_port);
            sock.getOutputStream().write(Hex.decode((String)connect_details));
            response = Hex.encode((byte[])sock.getInputStream().readNBytes(10));
            if (response.substring(0, 2).equalsIgnoreCase("05") && response.substring(2, 4).equalsIgnoreCase("00")) {
                return sock;
            }
            if (response.substring(2, 4).equalsIgnoreCase("04")) {
                log.warn("Host unreachable: {}", (Object)peerNodeAddress);
            } else {
                log.warn("SOCKS error code received {} expected 00", (Object)response.substring(2, 4));
            }
            if (!response.substring(0, 2).equalsIgnoreCase("05")) {
                log.warn("unexpected response, this isn't a SOCKS5 proxy?: {} {}", (Object)response, (Object)response.substring(0, 2));
            }
        }
        catch (Exception e) {
            log.warn(e.toString());
        }
        throw new IOException("createSocket failed");
    }

    @Override
    protected void createTorAndHiddenService() {
        this.executor.submit(() -> {
            try {
                ServerSocket socket = new ServerSocket(this.servicePort);
                this.nodeAddressProperty.set((Object)new NodeAddress(this.serviceAddress + ":" + this.servicePort));
                log.info("\n################################################################\nBound to Tor hidden service: {} Port: {}\n################################################################", (Object)this.serviceAddress, (Object)this.servicePort);
                UserThread.execute(() -> this.setupListeners.forEach(SetupListener::onTorNodeReady));
                UserThread.runAfter(() -> {
                    this.nodeAddressProperty.set((Object)new NodeAddress(this.serviceAddress + ":" + this.servicePort));
                    this.startServer(socket);
                    this.setupListeners.forEach(SetupListener::onHiddenServicePublished);
                }, (long)3L);
                return null;
            }
            catch (IOException e) {
                log.error("Could not connect to external Tor", (Throwable)e);
                UserThread.execute(() -> this.setupListeners.forEach(s -> s.onSetupFailed(new RuntimeException(e.getMessage()))));
                return null;
            }
        });
    }
}

