/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.network;

import haveno.common.UserThread;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.util.Utilities;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Statistic {
    private static final Logger log = LoggerFactory.getLogger(Statistic.class);
    private static final long startTime = System.currentTimeMillis();
    private static final LongProperty totalSentBytes = new SimpleLongProperty(0L);
    private static final DoubleProperty totalSentBytesPerSec = new SimpleDoubleProperty(0.0);
    private static final LongProperty totalReceivedBytes = new SimpleLongProperty(0L);
    private static final DoubleProperty totalReceivedBytesPerSec = new SimpleDoubleProperty(0.0);
    private static final Map<String, Integer> totalReceivedMessages = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Integer> totalSentMessages = new ConcurrentHashMap<String, Integer>();
    private static final LongProperty numTotalSentMessages = new SimpleLongProperty(0L);
    private static final DoubleProperty numTotalSentMessagesPerSec = new SimpleDoubleProperty(0.0);
    private static final LongProperty numTotalReceivedMessages = new SimpleLongProperty(0L);
    private static final DoubleProperty numTotalReceivedMessagesPerSec = new SimpleDoubleProperty(0.0);
    private final Date creationDate;
    private long lastActivityTimestamp = System.currentTimeMillis();
    private final LongProperty sentBytes = new SimpleLongProperty(0L);
    private final LongProperty receivedBytes = new SimpleLongProperty(0L);
    private final Map<String, Integer> receivedMessages = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Integer> sentMessages = new ConcurrentHashMap<String, Integer>();
    private final IntegerProperty roundTripTime = new SimpleIntegerProperty(0);

    public static LongProperty totalSentBytesProperty() {
        return totalSentBytes;
    }

    public static DoubleProperty totalSentBytesPerSecProperty() {
        return totalSentBytesPerSec;
    }

    public static LongProperty totalReceivedBytesProperty() {
        return totalReceivedBytes;
    }

    public static DoubleProperty totalReceivedBytesPerSecProperty() {
        return totalReceivedBytesPerSec;
    }

    public static LongProperty numTotalSentMessagesProperty() {
        return numTotalSentMessages;
    }

    public static DoubleProperty numTotalSentMessagesPerSecProperty() {
        return numTotalSentMessagesPerSec;
    }

    public static LongProperty numTotalReceivedMessagesProperty() {
        return numTotalReceivedMessages;
    }

    public static DoubleProperty numTotalReceivedMessagesPerSecProperty() {
        return numTotalReceivedMessagesPerSec;
    }

    Statistic() {
        this.creationDate = new Date();
    }

    void updateLastActivityTimestamp() {
        UserThread.execute(() -> {
            this.lastActivityTimestamp = System.currentTimeMillis();
        });
    }

    void addSentBytes(int value) {
        UserThread.execute(() -> {
            this.sentBytes.set(this.sentBytes.get() + (long)value);
            totalSentBytes.set(totalSentBytes.get() + (long)value);
        });
    }

    void addReceivedBytes(int value) {
        UserThread.execute(() -> {
            this.receivedBytes.set(this.receivedBytes.get() + (long)value);
            totalReceivedBytes.set(totalReceivedBytes.get() + (long)value);
        });
    }

    void addReceivedMessage(NetworkEnvelope networkEnvelope) {
        String messageClassName = networkEnvelope.getClass().getSimpleName();
        int counter = 1;
        if (this.receivedMessages.containsKey(messageClassName)) {
            counter = this.receivedMessages.get(messageClassName) + 1;
        }
        this.receivedMessages.put(messageClassName, counter);
        counter = 1;
        if (totalReceivedMessages.containsKey(messageClassName)) {
            counter = totalReceivedMessages.get(messageClassName) + 1;
        }
        totalReceivedMessages.put(messageClassName, counter);
    }

    void addSentMessage(NetworkEnvelope networkEnvelope) {
        String messageClassName = networkEnvelope.getClass().getSimpleName();
        int counter = 1;
        if (this.sentMessages.containsKey(messageClassName)) {
            counter = this.sentMessages.get(messageClassName) + 1;
        }
        this.sentMessages.put(messageClassName, counter);
        counter = 1;
        if (totalSentMessages.containsKey(messageClassName)) {
            counter = totalSentMessages.get(messageClassName) + 1;
        }
        totalSentMessages.put(messageClassName, counter);
    }

    public void setRoundTripTime(int roundTripTime) {
        this.roundTripTime.set(roundTripTime);
    }

    public long getLastActivityTimestamp() {
        return this.lastActivityTimestamp;
    }

    public long getLastActivityAge() {
        return System.currentTimeMillis() - this.lastActivityTimestamp;
    }

    public long getSentBytes() {
        return this.sentBytes.get();
    }

    public LongProperty sentBytesProperty() {
        return this.sentBytes;
    }

    public long getReceivedBytes() {
        return this.receivedBytes.get();
    }

    public LongProperty receivedBytesProperty() {
        return this.receivedBytes;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public IntegerProperty roundTripTimeProperty() {
        return this.roundTripTime;
    }

    public static long getTotalSentBytes() {
        return totalSentBytes.get();
    }

    public static double getTotalSentBytesPerSec() {
        return totalSentBytesPerSec.get();
    }

    public static long getTotalReceivedBytes() {
        return totalReceivedBytes.get();
    }

    public static double getTotalReceivedBytesPerSec() {
        return totalReceivedBytesPerSec.get();
    }

    public static double numTotalReceivedMessagesPerSec() {
        return numTotalReceivedMessagesPerSec.get();
    }

    public static double getNumTotalSentMessagesPerSec() {
        return numTotalSentMessagesPerSec.get();
    }

    public String toString() {
        return "Statistic{\n     creationDate=" + String.valueOf(this.creationDate) + ",\n     lastActivityTimestamp=" + this.lastActivityTimestamp + ",\n     sentBytes=" + String.valueOf(this.sentBytes) + ",\n     receivedBytes=" + String.valueOf(this.receivedBytes) + ",\n     receivedMessages=" + String.valueOf(this.receivedMessages) + ",\n     sentMessages=" + String.valueOf(this.sentMessages) + ",\n     roundTripTime=" + String.valueOf(this.roundTripTime) + "\n}";
    }

    static {
        UserThread.runPeriodically(() -> {
            numTotalSentMessages.set((long)totalSentMessages.values().stream().mapToInt(Integer::intValue).sum());
            numTotalReceivedMessages.set((long)totalReceivedMessages.values().stream().mapToInt(Integer::intValue).sum());
            long passed = (System.currentTimeMillis() - startTime) / 1000L;
            numTotalSentMessagesPerSec.set((double)numTotalSentMessages.get() / (double)passed);
            numTotalReceivedMessagesPerSec.set((double)numTotalReceivedMessages.get() / (double)passed);
            totalSentBytesPerSec.set((double)totalSentBytes.get() / (double)passed);
            totalReceivedBytesPerSec.set((double)totalReceivedBytes.get() / (double)passed);
        }, (long)1L);
        UserThread.runPeriodically(() -> {
            String ls = System.lineSeparator();
            log.info("Accumulated network statistics:" + ls + "Bytes sent: {};" + ls + "Number of sent messages/Sent messages: {} / {};" + ls + "Number of sent messages per sec: {};" + ls + "Bytes received: {}" + ls + "Number of received messages/Received messages: {} / {};" + ls + "Number of received messages per sec: {}" + ls, new Object[]{Utilities.readableFileSize((long)totalSentBytes.get()), numTotalSentMessages.get(), totalSentMessages, numTotalSentMessagesPerSec.get(), Utilities.readableFileSize((long)totalReceivedBytes.get()), numTotalReceivedMessages.get(), totalReceivedMessages, numTotalReceivedMessagesPerSec.get()});
        }, (long)TimeUnit.MINUTES.toSeconds(60L));
    }
}

