/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.network;

import haveno.network.p2p.network.BridgeAddressProvider;
import haveno.network.p2p.network.TorMode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.berndpruenster.netlayer.tor.NativeTor;
import org.berndpruenster.netlayer.tor.Tor;
import org.berndpruenster.netlayer.tor.TorCtlException;
import org.berndpruenster.netlayer.tor.Torrc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewTor
extends TorMode {
    private static final Logger log = LoggerFactory.getLogger(NewTor.class);
    private final File torrcFile;
    private final String torrcOptions;
    private final BridgeAddressProvider bridgeAddressProvider;

    public NewTor(File torWorkingDirectory, @Nullable File torrcFile, String torrcOptions, BridgeAddressProvider bridgeAddressProvider) {
        super(torWorkingDirectory);
        this.torrcFile = torrcFile;
        this.torrcOptions = torrcOptions;
        this.bridgeAddressProvider = bridgeAddressProvider;
    }

    @Override
    public Tor getTor() throws IOException, TorCtlException {
        long ts1 = new Date().getTime();
        List<String> bridgeEntries = this.bridgeAddressProvider.getBridgeAddresses();
        if (bridgeEntries != null) {
            log.info("Using bridges: {}", (Object)bridgeEntries.stream().collect(Collectors.joining(",")));
        }
        Torrc override = null;
        if (this.torrcFile != null) {
            try {
                override = new Torrc((InputStream)new FileInputStream(this.torrcFile));
            }
            catch (IOException e) {
                log.error("custom torrc file not found ('{}'). Proceeding with defaults.", (Object)this.torrcFile);
            }
        }
        LinkedHashMap torrcOptionsMap = new LinkedHashMap();
        if (!"".equals(this.torrcOptions)) {
            Arrays.asList(this.torrcOptions.split(",")).forEach(line -> {
                if ((line = line.trim()).matches("^[^\\s]+\\s.+")) {
                    String[] tmp = line.split("\\s", 2);
                    torrcOptionsMap.put(tmp[0].trim(), tmp[1].trim());
                } else {
                    log.error("custom torrc override parse error ('{}'). Proceeding without custom overrides.", line);
                    torrcOptionsMap.clear();
                }
            });
        }
        if (!torrcOptionsMap.isEmpty()) {
            override = override != null ? new Torrc(override.getInputStream$tor_native(), torrcOptionsMap) : new Torrc(torrcOptionsMap);
        }
        log.info("Starting tor");
        NativeTor result = new NativeTor(this.torDir, bridgeEntries, override);
        log.info("\n################################################################\nTor started after {} ms. Start publishing hidden service.\n################################################################", (Object)(new Date().getTime() - ts1));
        return result;
    }

    @Override
    public String getHiddenServiceDirectory() {
        return "";
    }
}

