/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.mailbox;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import haveno.common.UserThread;
import haveno.common.crypto.CryptoException;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.PubKeyRing;
import haveno.common.crypto.SealedAndSigned;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.ProtobufferException;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.common.util.Tuple2;
import haveno.common.util.Utilities;
import haveno.network.crypto.EncryptionService;
import haveno.network.p2p.DecryptedMessageWithPubKey;
import haveno.network.p2p.NetworkNotReadyException;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.PrefixedSealedAndSignedMessage;
import haveno.network.p2p.SendMailboxMessageListener;
import haveno.network.p2p.mailbox.IgnoredMailboxService;
import haveno.network.p2p.mailbox.MailboxItem;
import haveno.network.p2p.mailbox.MailboxMessage;
import haveno.network.p2p.mailbox.MailboxMessageList;
import haveno.network.p2p.messaging.DecryptedMailboxListener;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.peers.BroadcastHandler;
import haveno.network.p2p.peers.Broadcaster;
import haveno.network.p2p.peers.PeerManager;
import haveno.network.p2p.storage.HashMapChangedListener;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.messages.AddDataMessage;
import haveno.network.p2p.storage.payload.MailboxStoragePayload;
import haveno.network.p2p.storage.payload.ProtectedMailboxStorageEntry;
import haveno.network.p2p.storage.payload.ProtectedStorageEntry;
import haveno.network.utils.CapabilityUtils;
import java.security.PublicKey;
import java.time.Clock;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MailboxMessageService
implements HashMapChangedListener,
PersistedDataHost {
    private static final Logger log = LoggerFactory.getLogger(MailboxMessageService.class);
    private static final long REPUBLISH_DELAY_SEC = TimeUnit.MINUTES.toSeconds(2L);
    private static final long MAX_SERIALIZED_SIZE = 50000L;
    private final NetworkNode networkNode;
    private final PeerManager peerManager;
    private final P2PDataStorage p2PDataStorage;
    private final EncryptionService encryptionService;
    private final IgnoredMailboxService ignoredMailboxService;
    private final PersistenceManager<MailboxMessageList> persistenceManager;
    private final KeyRing keyRing;
    private final Clock clock;
    private final boolean republishMailboxEntries;
    private final Set<DecryptedMailboxListener> decryptedMailboxListeners = new CopyOnWriteArraySet<DecryptedMailboxListener>();
    private final MailboxMessageList mailboxMessageList = new MailboxMessageList();
    private final Map<String, MailboxItem> mailboxItemsByUid = new HashMap<String, MailboxItem>();
    private boolean isBootstrapped;
    private boolean allServicesInitialized;
    private boolean initAfterBootstrapped;
    private static Comparator<MailboxMessage> mailboxMessageComparator;

    @Inject
    public MailboxMessageService(NetworkNode networkNode, PeerManager peerManager, P2PDataStorage p2PDataStorage, EncryptionService encryptionService, IgnoredMailboxService ignoredMailboxService, PersistenceManager<MailboxMessageList> persistenceManager, KeyRing keyRing, Clock clock, @Named(value="republishMailboxEntries") boolean republishMailboxEntries) {
        this.networkNode = networkNode;
        this.peerManager = peerManager;
        this.p2PDataStorage = p2PDataStorage;
        this.encryptionService = encryptionService;
        this.ignoredMailboxService = ignoredMailboxService;
        this.persistenceManager = persistenceManager;
        this.keyRing = keyRing;
        this.clock = clock;
        this.republishMailboxEntries = republishMailboxEntries;
        this.persistenceManager.initialize((PersistableEnvelope)this.mailboxMessageList, PersistenceManager.Source.PRIVATE_LOW_PRIO);
    }

    public void readPersisted(Runnable completeHandler) {
        this.persistenceManager.readPersisted(persisted -> {
            HashMap numItemsPerDay = new HashMap();
            AtomicLong totalSize = new AtomicLong();
            persisted.stream().sorted(Comparator.comparingLong(o -> ((MailboxItem)o).getProtectedMailboxStorageEntry().getCreationTimeStamp()).reversed()).filter(e -> !e.isExpired(this.clock)).filter(e -> !this.mailboxItemsByUid.containsKey(e.getUid())).limit(3000L).forEach(mailboxItem -> {
                ProtectedMailboxStorageEntry protectedMailboxStorageEntry = mailboxItem.getProtectedMailboxStorageEntry();
                int serializedSize = protectedMailboxStorageEntry.toProtoMessage().getSerializedSize();
                String date = new Date(protectedMailboxStorageEntry.getCreationTimeStamp()).toString();
                String day = date.substring(4, 10);
                numItemsPerDay.putIfAbsent(day, new Tuple2((Object)new AtomicLong(0L), new ArrayList()));
                Tuple2 tuple = (Tuple2)numItemsPerDay.get(day);
                ((AtomicLong)tuple.first).getAndIncrement();
                ((List)tuple.second).add(serializedSize);
                if ((long)serializedSize < 50000L) {
                    MailboxMessageList mailboxMessageList = this.mailboxMessageList;
                    synchronized (mailboxMessageList) {
                        this.mailboxItemsByUid.put(mailboxItem.getUid(), (MailboxItem)mailboxItem);
                        this.mailboxMessageList.add((PersistablePayload)mailboxItem);
                        totalSize.getAndAdd(serializedSize);
                    }
                    this.p2PDataStorage.addProtectedMailboxStorageEntryToMap(protectedMailboxStorageEntry);
                } else {
                    log.info("We ignore this large persisted mailboxItem. If still valid we will reload it from seed nodes at getData requests.\nSize={}; date={}; sender={}", new Object[]{Utilities.readableFileSize((long)serializedSize), date, mailboxItem.getProtectedMailboxStorageEntry().getMailboxStoragePayload().getPrefixedSealedAndSignedMessage().getSenderNodeAddress()});
                }
            });
            List perDay = numItemsPerDay.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> {
                Tuple2 tuple = (Tuple2)entry.getValue();
                List sizes = (List)tuple.second;
                long sum = sizes.stream().mapToLong(s -> s.intValue()).sum();
                List largeItems = sizes.stream().filter(s -> s > 20000).map(Utilities::readableFileSize).collect(Collectors.toList());
                String largeMsgInfo = largeItems.isEmpty() ? "" : "; Large messages: " + String.valueOf(largeItems);
                return (String)entry.getKey() + ": Num messages: " + String.valueOf(tuple.first) + "; Total size: " + Utilities.readableFileSize((long)sum) + largeMsgInfo;
            }).collect(Collectors.toList());
            log.info("We loaded {} persisted mailbox messages with {}.\nPer day distribution:\n{}", new Object[]{this.mailboxMessageList.size(), Utilities.readableFileSize((long)totalSize.get()), Joiner.on((String)"\n").join(perDay)});
            this.requestPersistence();
            completeHandler.run();
        }, completeHandler);
    }

    public void onAllServicesInitialized() {
        this.allServicesInitialized = true;
        this.init();
    }

    public void onBootstrapped() {
        if (!this.isBootstrapped) {
            this.isBootstrapped = true;
        }
    }

    public void initAfterBootstrapped() {
        this.initAfterBootstrapped = true;
        this.init();
    }

    private void init() {
        if (this.allServicesInitialized && this.initAfterBootstrapped) {
            this.addHashMapChangedListener();
            this.onAdded(this.p2PDataStorage.getMap().values());
            this.maybeRepublishMailBoxMessages();
        }
    }

    public void sendEncryptedMailboxMessage(NodeAddress peer, final PubKeyRing peersPubKeyRing, final MailboxMessage mailboxMessage, final SendMailboxMessageListener sendMailboxMessageListener) {
        if (peersPubKeyRing == null) {
            log.debug("sendEncryptedMailboxMessage: peersPubKeyRing is null. We ignore the call.");
            return;
        }
        Preconditions.checkNotNull((Object)peer, (Object)"PeerAddress must not be null (sendEncryptedMailboxMessage)");
        Preconditions.checkNotNull((Object)this.networkNode.getNodeAddress(), (Object)"My node address must not be null at sendEncryptedMailboxMessage");
        Preconditions.checkArgument((!this.keyRing.getPubKeyRing().equals((Object)peersPubKeyRing) ? 1 : 0) != 0, (Object)"We got own keyring instead of that from peer");
        if (!this.isBootstrapped) {
            throw new NetworkNotReadyException();
        }
        if (this.networkNode.getAllConnections().isEmpty()) {
            sendMailboxMessageListener.onFault("There are no P2P network nodes connected. Please check your internet connection.");
            return;
        }
        NetworkEnvelope networkEnvelope = (NetworkEnvelope)mailboxMessage;
        if (CapabilityUtils.capabilityRequiredAndCapabilityNotSupported(peer, networkEnvelope, this.peerManager)) {
            sendMailboxMessageListener.onFault("We did not send the EncryptedMailboxMessage because the peer does not support the capability.");
            return;
        }
        try {
            final PrefixedSealedAndSignedMessage prefixedSealedAndSignedMessage = new PrefixedSealedAndSignedMessage(this.networkNode.getNodeAddress(), this.encryptionService.encryptAndSign(peersPubKeyRing, networkEnvelope));
            SettableFuture<Connection> future = this.networkNode.sendMessage(peer, (NetworkEnvelope)prefixedSealedAndSignedMessage);
            Futures.addCallback(future, (FutureCallback)new FutureCallback<Connection>(){

                public void onSuccess(@Nullable Connection connection) {
                    sendMailboxMessageListener.onArrived();
                }

                public void onFailure(@NotNull Throwable throwable) {
                    PublicKey receiverStoragePublicKey = peersPubKeyRing.getSignaturePubKey();
                    long ttl = mailboxMessage.getTTL();
                    log.trace("## We take TTL from {}. ttl={}", (Object)mailboxMessage.getClass().getSimpleName(), (Object)ttl);
                    MailboxMessageService.this.addMailboxData(new MailboxStoragePayload(prefixedSealedAndSignedMessage, MailboxMessageService.this.keyRing.getSignatureKeyPair().getPublic(), receiverStoragePublicKey, ttl), receiverStoragePublicKey, sendMailboxMessageListener);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        catch (CryptoException e) {
            log.error("sendEncryptedMessage failed: {}\n", (Object)e.getMessage(), (Object)e);
            sendMailboxMessageListener.onFault("sendEncryptedMailboxMessage failed " + String.valueOf((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMailboxMsg(MailboxMessage mailboxMessage) {
        if (this.isBootstrapped) {
            MailboxMessageList mailboxMessageList = this.mailboxMessageList;
            synchronized (mailboxMessageList) {
                String uid = mailboxMessage.getUid();
                if (!this.mailboxItemsByUid.containsKey(uid)) {
                    return;
                }
                this.removeMailboxEntryFromNetwork(this.mailboxItemsByUid.get(uid).getProtectedMailboxStorageEntry());
                log.trace("## removeMailboxMsg uid={}", (Object)uid);
                this.removeMailboxItemFromLocalStore(uid);
            }
        } else {
            UserThread.runAfter(() -> this.removeMailboxMsg(mailboxMessage), (long)30L);
        }
    }

    public Set<DecryptedMessageWithPubKey> getMyDecryptedMailboxMessages() {
        return this.mailboxItemsByUid.values().stream().filter(MailboxItem::isMine).map(MailboxItem::getDecryptedMessageWithPubKey).collect(Collectors.toSet());
    }

    public void addDecryptedMailboxListener(DecryptedMailboxListener listener) {
        this.decryptedMailboxListeners.add(listener);
    }

    @Override
    public void onAdded(Collection<ProtectedStorageEntry> protectedStorageEntries) {
        log.trace("## onAdded");
        Collection entries = protectedStorageEntries.stream().filter(e -> e instanceof ProtectedMailboxStorageEntry).map(e -> (ProtectedMailboxStorageEntry)e).filter(e -> this.networkNode.getNodeAddress() != null).collect(Collectors.toSet());
        this.threadedBatchProcessMailboxEntries(entries);
    }

    @Override
    public void onRemoved(Collection<ProtectedStorageEntry> protectedStorageEntries) {
        log.trace("## onRemoved");
        protectedStorageEntries.stream().filter(protectedStorageEntry -> protectedStorageEntry instanceof ProtectedMailboxStorageEntry).map(protectedStorageEntry -> (ProtectedMailboxStorageEntry)protectedStorageEntry).map(e -> e.getMailboxStoragePayload().getPrefixedSealedAndSignedMessage().getUid()).filter(this.mailboxItemsByUid::containsKey).forEach(this::removeMailboxItemFromLocalStore);
    }

    public static void setMailboxMessageComparator(Comparator<MailboxMessage> comparator) {
        mailboxMessageComparator = comparator;
    }

    private void addHashMapChangedListener() {
        this.p2PDataStorage.addHashMapChangedListener(this);
    }

    private void threadedBatchProcessMailboxEntries(Collection<ProtectedMailboxStorageEntry> protectedMailboxStorageEntries) {
        long ts = System.currentTimeMillis();
        SettableFuture future = SettableFuture.create();
        new Thread(() -> {
            try {
                Set<MailboxItem> mailboxItems = this.getMailboxItems(protectedMailboxStorageEntries);
                if (!protectedMailboxStorageEntries.isEmpty()) {
                    log.info("Batch processing of {} mailbox entries took {} ms", (Object)protectedMailboxStorageEntries.size(), (Object)(System.currentTimeMillis() - ts));
                }
                future.set(mailboxItems);
            }
            catch (Throwable throwable) {
                future.setException(throwable);
            }
        }, "processMailboxEntry-" + new Random().nextInt(1000)).start();
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Set<MailboxItem>>(){

            public void onSuccess(Set<MailboxItem> decryptedMailboxMessageWithEntries) {
                new Thread(() -> MailboxMessageService.this.handleMailboxItems(decryptedMailboxMessageWithEntries)).start();
            }

            public void onFailure(@NotNull Throwable throwable) {
                log.error(throwable.toString());
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private Set<MailboxItem> getMailboxItems(Collection<ProtectedMailboxStorageEntry> protectedMailboxStorageEntries) {
        HashSet<MailboxItem> mailboxItems = new HashSet<MailboxItem>();
        protectedMailboxStorageEntries.stream().map(this::tryDecryptProtectedMailboxStorageEntry).forEach(mailboxItems::add);
        return mailboxItems;
    }

    private MailboxItem tryDecryptProtectedMailboxStorageEntry(ProtectedMailboxStorageEntry protectedMailboxStorageEntry) {
        PrefixedSealedAndSignedMessage prefixedSealedAndSignedMessage = protectedMailboxStorageEntry.getMailboxStoragePayload().getPrefixedSealedAndSignedMessage();
        SealedAndSigned sealedAndSigned = prefixedSealedAndSignedMessage.getSealedAndSigned();
        String uid = prefixedSealedAndSignedMessage.getUid();
        if (this.ignoredMailboxService.isIgnored(uid)) {
            return new MailboxItem(protectedMailboxStorageEntry, null);
        }
        try {
            DecryptedMessageWithPubKey decryptedMessageWithPubKey = this.encryptionService.decryptAndVerify(sealedAndSigned);
            Preconditions.checkArgument((boolean)(decryptedMessageWithPubKey.getNetworkEnvelope() instanceof MailboxMessage));
            return new MailboxItem(protectedMailboxStorageEntry, decryptedMessageWithPubKey);
        }
        catch (CryptoException ignore) {
            this.ignoredMailboxService.ignore(uid, protectedMailboxStorageEntry.getCreationTimeStamp());
        }
        catch (ProtobufferException e) {
            log.error(e.toString());
            e.getStackTrace();
        }
        return new MailboxItem(protectedMailboxStorageEntry, null);
    }

    private void handleMailboxItems(Set<MailboxItem> mailboxItems) {
        List<MailboxItem> mailboxItemsSorted = mailboxItems.stream().filter(e -> !e.isMine()).collect(Collectors.toList());
        mailboxItemsSorted.addAll(mailboxItems.stream().filter(e -> e.isMine()).sorted(new MailboxItemComparator()).collect(Collectors.toList()));
        mailboxItemsSorted.forEach(e -> this.handleMailboxItem((MailboxItem)e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMailboxItem(MailboxItem mailboxItem) {
        String uid = mailboxItem.getUid();
        MailboxMessageList mailboxMessageList = this.mailboxMessageList;
        synchronized (mailboxMessageList) {
            if (!this.mailboxItemsByUid.containsKey(uid)) {
                this.mailboxItemsByUid.put(uid, mailboxItem);
                this.mailboxMessageList.add(mailboxItem);
                log.trace("## handleMailboxItem uid={}\nhash={}", (Object)uid, (Object)P2PDataStorage.get32ByteHashAsByteArray(mailboxItem.getProtectedMailboxStorageEntry().getProtectedStoragePayload()));
                this.requestPersistence();
            }
        }
        if (mailboxItem.isMine()) {
            this.processMyMailboxItem(mailboxItem, uid);
        }
    }

    private void processMyMailboxItem(MailboxItem mailboxItem, String uid) {
        DecryptedMessageWithPubKey decryptedMessageWithPubKey = (DecryptedMessageWithPubKey)Preconditions.checkNotNull((Object)mailboxItem.getDecryptedMessageWithPubKey());
        MailboxMessage mailboxMessage = (MailboxMessage)decryptedMessageWithPubKey.getNetworkEnvelope();
        NodeAddress sender = mailboxMessage.getSenderNodeAddress();
        log.info("Received a {} mailbox message with uid {} and senderAddress {}", new Object[]{mailboxMessage.getClass().getSimpleName(), uid, sender});
        this.decryptedMailboxListeners.forEach(e -> e.onMailboxMessageAdded(decryptedMessageWithPubKey, sender));
        if (this.allServicesInitialized && this.isBootstrapped) {
            this.removeMailboxEntryFromNetwork(mailboxItem.getProtectedMailboxStorageEntry());
        } else {
            log.info("We are not bootstrapped yet, so we remove later once the mailBoxMessage got processed.");
        }
    }

    private void addMailboxData(MailboxStoragePayload expirableMailboxStoragePayload, PublicKey receiversPublicKey, final SendMailboxMessageListener sendMailboxMessageListener) {
        if (!this.isBootstrapped) {
            throw new NetworkNotReadyException();
        }
        if (this.networkNode.getAllConnections().isEmpty()) {
            sendMailboxMessageListener.onFault("There are no P2P network nodes connected. Please check your internet connection.");
            return;
        }
        try {
            final ProtectedMailboxStorageEntry protectedMailboxStorageEntry = this.p2PDataStorage.getMailboxDataWithSignedSeqNr(expirableMailboxStoragePayload, this.keyRing.getSignatureKeyPair(), receiversPublicKey);
            BroadcastHandler.Listener listener = new BroadcastHandler.Listener(){

                @Override
                public void onSufficientlyBroadcast(List<Broadcaster.BroadcastRequest> broadcastRequests) {
                    broadcastRequests.stream().filter(broadcastRequest -> broadcastRequest.getMessage() instanceof AddDataMessage).filter(broadcastRequest -> {
                        AddDataMessage addDataMessage = (AddDataMessage)broadcastRequest.getMessage();
                        return addDataMessage.getProtectedStorageEntry().equals(protectedMailboxStorageEntry);
                    }).forEach(e -> sendMailboxMessageListener.onStoredInMailbox());
                }

                @Override
                public void onNotSufficientlyBroadcast(int numOfCompletedBroadcasts, int numOfFailedBroadcast) {
                    sendMailboxMessageListener.onFault("Message was not sufficiently broadcast.\nnumOfCompletedBroadcasts: " + numOfCompletedBroadcasts + ".\nnumOfFailedBroadcast=" + numOfFailedBroadcast);
                }
            };
            boolean result = this.p2PDataStorage.addProtectedStorageEntry(protectedMailboxStorageEntry, this.networkNode.getNodeAddress(), listener);
            if (!result) {
                sendMailboxMessageListener.onFault("Data already exists in our local database");
                log.error("Unexpected state: adding mailbox message that already exists.");
            }
        }
        catch (CryptoException e) {
            log.error("Signing at getMailboxDataWithSignedSeqNr failed.");
        }
    }

    private void removeMailboxEntryFromNetwork(ProtectedMailboxStorageEntry protectedMailboxStorageEntry) {
        MailboxStoragePayload mailboxStoragePayload = (MailboxStoragePayload)protectedMailboxStorageEntry.getProtectedStoragePayload();
        PublicKey receiversPubKey = protectedMailboxStorageEntry.getReceiversPubKey();
        try {
            ProtectedMailboxStorageEntry updatedEntry = this.p2PDataStorage.getMailboxDataWithSignedSeqNr(mailboxStoragePayload, this.keyRing.getSignatureKeyPair(), receiversPubKey);
            P2PDataStorage.ByteArray hashOfPayload = P2PDataStorage.get32ByteHashAsByteArray(mailboxStoragePayload);
            if (this.p2PDataStorage.getMap().containsKey(hashOfPayload)) {
                boolean result = this.p2PDataStorage.remove(updatedEntry, this.networkNode.getNodeAddress());
                if (result) {
                    log.info("Removed mailboxEntry from network");
                } else {
                    log.warn("Removing mailboxEntry from network failed");
                }
            } else {
                log.info("The mailboxEntry was already removed earlier.");
            }
        }
        catch (CryptoException e) {
            log.error("Could not remove ProtectedMailboxStorageEntry from network. Error: {}\n", (Object)e.toString(), (Object)e);
        }
    }

    private void maybeRepublishMailBoxMessages() {
        if (!this.republishMailboxEntries) {
            return;
        }
        log.info("We will republish our persisted mailbox messages after a delay of {} sec.", (Object)REPUBLISH_DELAY_SEC);
        log.trace("## republishMailBoxMessages mailboxItemsByUid={}", this.mailboxItemsByUid.keySet());
        UserThread.runAfter(() -> this.republishInChunks(this.mailboxItemsByUid.values().stream().filter(e -> !e.isExpired(this.clock)).map(MailboxItem::getProtectedMailboxStorageEntry).collect(Collectors.toCollection(ArrayDeque::new))), (long)REPUBLISH_DELAY_SEC);
    }

    private void republishInChunks(Queue<ProtectedMailboxStorageEntry> queue) {
        int chunkSize = 50;
        log.info("Republish a bucket of {} persisted mailbox messages out of {}.", (Object)chunkSize, (Object)queue.size());
        for (int i = 0; !queue.isEmpty() && i < chunkSize; ++i) {
            ProtectedMailboxStorageEntry protectedMailboxStorageEntry = queue.poll();
            this.p2PDataStorage.republishExistingProtectedMailboxStorageEntry(protectedMailboxStorageEntry, this.networkNode.getNodeAddress(), null);
        }
        if (!queue.isEmpty()) {
            UserThread.runAfter(() -> this.republishInChunks(queue), (long)REPUBLISH_DELAY_SEC);
        }
    }

    private void removeMailboxItemFromLocalStore(String uid) {
        MailboxItem mailboxItem = this.mailboxItemsByUid.get(uid);
        this.mailboxItemsByUid.remove(uid);
        this.mailboxMessageList.remove(mailboxItem);
        log.trace("## removeMailboxItemFromMap uid={}\nhash={}\nmailboxItemsByUid={}", new Object[]{uid, P2PDataStorage.get32ByteHashAsByteArray(mailboxItem.getProtectedMailboxStorageEntry().getProtectedStoragePayload()), this.mailboxItemsByUid.keySet()});
        this.requestPersistence();
    }

    private void requestPersistence() {
        this.persistenceManager.requestPersistence();
    }

    private static class MailboxItemComparator
    implements Comparator<MailboxItem> {
        private DecryptedMessageWithPubKeyComparator comparator = new DecryptedMessageWithPubKeyComparator();

        private MailboxItemComparator() {
        }

        @Override
        public int compare(MailboxItem m1, MailboxItem m2) {
            return this.comparator.compare(m1.getDecryptedMessageWithPubKey(), m2.getDecryptedMessageWithPubKey());
        }
    }

    public static class DecryptedMessageWithPubKeyComparator
    implements Comparator<DecryptedMessageWithPubKey> {
        @Override
        public int compare(DecryptedMessageWithPubKey m1, DecryptedMessageWithPubKey m2) {
            if (m1.getNetworkEnvelope() instanceof MailboxMessage) {
                if (m2.getNetworkEnvelope() instanceof MailboxMessage) {
                    return mailboxMessageComparator.compare((MailboxMessage)m1.getNetworkEnvelope(), (MailboxMessage)m2.getNetworkEnvelope());
                }
                return 1;
            }
            return m2.getNetworkEnvelope() instanceof MailboxMessage ? -1 : 0;
        }
    }
}

