/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.mailbox;

import haveno.common.proto.ProtobufferException;
import haveno.common.proto.network.NetworkProtoResolver;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.network.p2p.DecryptedMessageWithPubKey;
import haveno.network.p2p.mailbox.MailboxMessage;
import haveno.network.p2p.storage.payload.ProtectedMailboxStorageEntry;
import java.time.Clock;
import java.util.Optional;
import javax.annotation.Nullable;
import protobuf.MailboxItem;

public final class MailboxItem
implements PersistablePayload {
    private final ProtectedMailboxStorageEntry protectedMailboxStorageEntry;
    @Nullable
    private final DecryptedMessageWithPubKey decryptedMessageWithPubKey;

    public MailboxItem(ProtectedMailboxStorageEntry protectedMailboxStorageEntry, @Nullable DecryptedMessageWithPubKey decryptedMessageWithPubKey) {
        this.protectedMailboxStorageEntry = protectedMailboxStorageEntry;
        this.decryptedMessageWithPubKey = decryptedMessageWithPubKey;
    }

    public protobuf.MailboxItem toProtoMessage() {
        MailboxItem.Builder builder = protobuf.MailboxItem.newBuilder().setProtectedMailboxStorageEntry(this.protectedMailboxStorageEntry.toProtoMessage());
        Optional.ofNullable(this.decryptedMessageWithPubKey).ifPresent(decryptedMessageWithPubKey -> builder.setDecryptedMessageWithPubKey(decryptedMessageWithPubKey.toProtoMessage()));
        return builder.build();
    }

    public static MailboxItem fromProto(protobuf.MailboxItem proto, NetworkProtoResolver networkProtoResolver) throws ProtobufferException {
        DecryptedMessageWithPubKey decryptedMessageWithPubKey = proto.hasDecryptedMessageWithPubKey() ? DecryptedMessageWithPubKey.fromProto(proto.getDecryptedMessageWithPubKey(), networkProtoResolver) : null;
        return new MailboxItem(ProtectedMailboxStorageEntry.fromProto(proto.getProtectedMailboxStorageEntry(), networkProtoResolver), decryptedMessageWithPubKey);
    }

    public boolean isMine() {
        return this.decryptedMessageWithPubKey != null;
    }

    public String getUid() {
        if (this.decryptedMessageWithPubKey != null) {
            MailboxMessage mailboxMessage = (MailboxMessage)this.decryptedMessageWithPubKey.getNetworkEnvelope();
            return mailboxMessage.getUid();
        }
        return this.protectedMailboxStorageEntry.getMailboxStoragePayload().getPrefixedSealedAndSignedMessage().getUid();
    }

    public boolean isExpired(Clock clock) {
        return this.protectedMailboxStorageEntry.isExpired(clock);
    }

    public ProtectedMailboxStorageEntry getProtectedMailboxStorageEntry() {
        return this.protectedMailboxStorageEntry;
    }

    @Nullable
    public DecryptedMessageWithPubKey getDecryptedMessageWithPubKey() {
        return this.decryptedMessageWithPubKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MailboxItem)) {
            return false;
        }
        MailboxItem other = (MailboxItem)o;
        ProtectedMailboxStorageEntry this$protectedMailboxStorageEntry = this.getProtectedMailboxStorageEntry();
        ProtectedMailboxStorageEntry other$protectedMailboxStorageEntry = other.getProtectedMailboxStorageEntry();
        if (this$protectedMailboxStorageEntry == null ? other$protectedMailboxStorageEntry != null : !((Object)this$protectedMailboxStorageEntry).equals(other$protectedMailboxStorageEntry)) {
            return false;
        }
        DecryptedMessageWithPubKey this$decryptedMessageWithPubKey = this.getDecryptedMessageWithPubKey();
        DecryptedMessageWithPubKey other$decryptedMessageWithPubKey = other.getDecryptedMessageWithPubKey();
        return !(this$decryptedMessageWithPubKey == null ? other$decryptedMessageWithPubKey != null : !((Object)this$decryptedMessageWithPubKey).equals(other$decryptedMessageWithPubKey));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProtectedMailboxStorageEntry $protectedMailboxStorageEntry = this.getProtectedMailboxStorageEntry();
        result = result * 59 + ($protectedMailboxStorageEntry == null ? 43 : ((Object)$protectedMailboxStorageEntry).hashCode());
        DecryptedMessageWithPubKey $decryptedMessageWithPubKey = this.getDecryptedMessageWithPubKey();
        result = result * 59 + ($decryptedMessageWithPubKey == null ? 43 : ((Object)$decryptedMessageWithPubKey).hashCode());
        return result;
    }

    public String toString() {
        return "MailboxItem(protectedMailboxStorageEntry=" + String.valueOf(this.getProtectedMailboxStorageEntry()) + ", decryptedMessageWithPubKey=" + String.valueOf(this.getDecryptedMessageWithPubKey()) + ")";
    }
}

