/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.mailbox;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.network.p2p.mailbox.IgnoredMailboxMap;
import haveno.network.p2p.storage.payload.MailboxStoragePayload;

@Singleton
public class IgnoredMailboxService
implements PersistedDataHost {
    private final PersistenceManager<IgnoredMailboxMap> persistenceManager;
    private final IgnoredMailboxMap ignoredMailboxMap = new IgnoredMailboxMap();

    @Inject
    public IgnoredMailboxService(PersistenceManager<IgnoredMailboxMap> persistenceManager) {
        this.persistenceManager = persistenceManager;
        this.persistenceManager.initialize((PersistableEnvelope)this.ignoredMailboxMap, PersistenceManager.Source.PRIVATE_LOW_PRIO);
    }

    public void readPersisted(Runnable completeHandler) {
        this.persistenceManager.readPersisted(persisted -> {
            long expiredDate = System.currentTimeMillis() - MailboxStoragePayload.TTL;
            persisted.getDataMap().entrySet().stream().filter(e -> (Long)e.getValue() > expiredDate).forEach(e -> this.ignoredMailboxMap.put((String)e.getKey(), (Long)e.getValue()));
            this.persistenceManager.requestPersistence();
            completeHandler.run();
        }, completeHandler);
    }

    public boolean isIgnored(String uid) {
        return this.ignoredMailboxMap.containsKey(uid);
    }

    public void ignore(String uid, long creationTimeStamp) {
        this.ignoredMailboxMap.put(uid, creationTimeStamp);
        this.persistenceManager.requestPersistence();
    }
}

