/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p;

import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import haveno.common.app.AppModule;
import haveno.common.config.Config;
import haveno.network.Socks5ProxyProvider;
import haveno.network.http.HttpClient;
import haveno.network.http.HttpClientImpl;
import haveno.network.p2p.NetworkNodeProvider;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.peers.Broadcaster;
import haveno.network.p2p.peers.PeerManager;
import haveno.network.p2p.peers.getdata.RequestDataManager;
import haveno.network.p2p.peers.keepalive.KeepAliveManager;
import haveno.network.p2p.peers.peerexchange.PeerExchangeManager;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.persistence.AppendOnlyDataStoreService;
import haveno.network.p2p.storage.persistence.ProtectedDataStoreService;
import haveno.network.p2p.storage.persistence.ResourceDataStoreService;
import java.io.File;
import java.lang.annotation.Annotation;
import java.time.Clock;
import java.util.List;

public class P2PModule
extends AppModule {
    public P2PModule(Config config) {
        super(config);
    }

    protected void configure() {
        this.bind(Clock.class).toInstance((Object)Clock.systemDefaultZone());
        this.bind(P2PService.class).in(Singleton.class);
        this.bind(PeerManager.class).in(Singleton.class);
        this.bind(P2PDataStorage.class).in(Singleton.class);
        this.bind(AppendOnlyDataStoreService.class).in(Singleton.class);
        this.bind(ProtectedDataStoreService.class).in(Singleton.class);
        this.bind(ResourceDataStoreService.class).in(Singleton.class);
        this.bind(RequestDataManager.class).in(Singleton.class);
        this.bind(PeerExchangeManager.class).in(Singleton.class);
        this.bind(KeepAliveManager.class).in(Singleton.class);
        this.bind(Broadcaster.class).in(Singleton.class);
        this.bind(NetworkNode.class).toProvider(NetworkNodeProvider.class).in(Singleton.class);
        this.bind(Socks5ProxyProvider.class).in(Singleton.class);
        this.bind(HttpClient.class).to(HttpClientImpl.class);
        this.requestStaticInjection(new Class[]{Connection.class});
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"useLocalhostForP2P")).to(this.config.useLocalhostForP2P);
        this.bind(File.class).annotatedWith((Annotation)Names.named((String)"torDir")).toInstance((Object)this.config.torDir);
        this.bind(Integer.TYPE).annotatedWith((Annotation)Names.named((String)"nodePort")).toInstance((Object)this.config.nodePort);
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"hiddenServiceAddress")).toInstance((Object)this.config.hiddenServiceAddress);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"maxConnections")).to(this.config.maxConnections);
        this.bind((TypeLiteral)new TypeLiteral<List<String>>(this){}).annotatedWith((Annotation)Names.named((String)"banList")).toInstance((Object)this.config.banList);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"socks5ProxyXmrAddress")).to(this.config.socks5ProxyXmrAddress);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"socks5ProxyHttpAddress")).to(this.config.socks5ProxyHttpAddress);
        this.bind(File.class).annotatedWith((Annotation)Names.named((String)"torrcFile")).toProvider(Providers.of((Object)this.config.torrcFile));
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"torrcOptions")).to(this.config.torrcOptions);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"torControlHost")).to(this.config.torControlHost);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"torControlPort")).to(this.config.torControlPort);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"torControlPassword")).to(this.config.torControlPassword);
        this.bind(File.class).annotatedWith((Annotation)Names.named((String)"torControlCookieFile")).toProvider(Providers.of((Object)this.config.torControlCookieFile));
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"torControlUseSafeCookieAuth")).to(this.config.useTorControlSafeCookieAuth);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"torStreamIsolation")).to(this.config.torStreamIsolation);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"MAX_SEQUENCE_NUMBER_MAP_SIZE_BEFORE_PURGE")).to(1000);
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"republishMailboxEntries")).toInstance((Object)this.config.republishMailboxEntries);
    }
}

