/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p;

import com.google.common.base.Preconditions;
import haveno.common.consensus.UsedForTradeContractJson;
import haveno.common.crypto.Hash;
import haveno.common.proto.network.NetworkPayload;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.common.util.JsonExclude;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeAddress
implements PersistablePayload,
NetworkPayload,
UsedForTradeContractJson {
    private static final Logger log = LoggerFactory.getLogger(NodeAddress.class);
    private final String hostName;
    private final int port;
    @JsonExclude
    private byte[] addressPrefixHash;

    public NodeAddress(String hostName, int port) {
        this.hostName = hostName;
        this.port = port;
    }

    public NodeAddress(String fullAddress) {
        String[] split = fullAddress.split(Pattern.quote(":"));
        Preconditions.checkArgument((split.length == 2 ? 1 : 0) != 0, (Object)"fullAddress must contain ':'");
        this.hostName = split[0];
        this.port = Integer.parseInt(split[1]);
    }

    public protobuf.NodeAddress toProtoMessage() {
        return protobuf.NodeAddress.newBuilder().setHostName(this.hostName).setPort(this.port).build();
    }

    public static NodeAddress fromProto(protobuf.NodeAddress proto) {
        return new NodeAddress(proto.getHostName(), proto.getPort());
    }

    public String getFullAddress() {
        return this.hostName + ":" + this.port;
    }

    public String getAddressForDisplay() {
        if (this.hostName.endsWith(".onion")) {
            return this.getHostNameForDisplay();
        }
        return this.shortenAddressForDisplay(this.getFullAddress());
    }

    private String getHostNameWithoutPostFix() {
        return this.hostName.replace(".onion", "");
    }

    private String getHostNameForDisplay() {
        return this.shortenAddressForDisplay(this.getHostNameWithoutPostFix());
    }

    private String shortenAddressForDisplay(String address) {
        if (address.length() > 16) {
            return address.substring(0, 7) + ".." + address.substring(address.length() - 7);
        }
        return address;
    }

    public byte[] getAddressPrefixHash() {
        if (this.addressPrefixHash == null) {
            this.addressPrefixHash = Hash.getSha256Hash((String)this.getFullAddress().substring(0, Math.min(2, this.getFullAddress().length())));
        }
        return this.addressPrefixHash;
    }

    public String toString() {
        return this.getFullAddress();
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeAddress)) {
            return false;
        }
        NodeAddress other = (NodeAddress)o;
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$hostName = this.getHostName();
        String other$hostName = other.getHostName();
        if (this$hostName == null ? other$hostName != null : !this$hostName.equals(other$hostName)) {
            return false;
        }
        return Arrays.equals(this.getAddressPrefixHash(), other.getAddressPrefixHash());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $hostName = this.getHostName();
        result = result * 59 + ($hostName == null ? 43 : $hostName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getAddressPrefixHash());
        return result;
    }
}

