/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import haveno.common.proto.network.NetworkProtoResolver;
import haveno.network.p2p.network.BanFilter;
import haveno.network.p2p.network.BridgeAddressProvider;
import haveno.network.p2p.network.DirectBindTor;
import haveno.network.p2p.network.LocalhostNetworkNode;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.network.NewTor;
import haveno.network.p2p.network.RunningTor;
import haveno.network.p2p.network.TorMode;
import haveno.network.p2p.network.TorNetworkNodeDirectBind;
import haveno.network.p2p.network.TorNetworkNodeNetlayer;
import java.io.File;
import javax.annotation.Nullable;

public class NetworkNodeProvider
implements Provider<NetworkNode> {
    private final NetworkNode networkNode;

    @Inject
    public NetworkNodeProvider(NetworkProtoResolver networkProtoResolver, BridgeAddressProvider bridgeAddressProvider, @Nullable BanFilter banFilter, @Named(value="maxConnections") int maxConnections, @Named(value="useLocalhostForP2P") boolean useLocalhostForP2P, @Named(value="nodePort") int port, @Named(value="hiddenServiceAddress") String hiddenServiceAddress, @Named(value="torDir") File torDir, @Nullable @Named(value="torrcFile") File torrcFile, @Named(value="torrcOptions") String torrcOptions, @Named(value="torControlHost") String controlHost, @Named(value="torControlPort") int controlPort, @Named(value="torControlPassword") String password, @Nullable @Named(value="torControlCookieFile") File cookieFile, @Named(value="torStreamIsolation") boolean streamIsolation, @Named(value="torControlUseSafeCookieAuth") boolean useSafeCookieAuthentication) {
        TorMode torMode;
        this.networkNode = useLocalhostForP2P ? new LocalhostNetworkNode(port, networkProtoResolver, banFilter, maxConnections) : ((torMode = this.getTorMode(bridgeAddressProvider, torDir, torrcFile, torrcOptions, controlHost, controlPort, hiddenServiceAddress, password, cookieFile, useSafeCookieAuthentication)) instanceof NewTor || torMode instanceof RunningTor ? new TorNetworkNodeNetlayer(port, networkProtoResolver, torMode, banFilter, maxConnections, streamIsolation, controlHost) : new TorNetworkNodeDirectBind(port, networkProtoResolver, banFilter, maxConnections, hiddenServiceAddress));
    }

    private TorMode getTorMode(BridgeAddressProvider bridgeAddressProvider, File torDir, @Nullable File torrcFile, String torrcOptions, String controlHost, int controlPort, String hiddenServiceAddress, String password, @Nullable File cookieFile, boolean useSafeCookieAuthentication) {
        if (!hiddenServiceAddress.equals("")) {
            return new DirectBindTor();
        }
        if (controlPort != -1) {
            return new RunningTor(torDir, controlHost, controlPort, password, cookieFile, useSafeCookieAuthentication);
        }
        return new NewTor(torDir, torrcFile, torrcOptions, bridgeAddressProvider);
    }

    public NetworkNode get() {
        return this.networkNode;
    }
}

