/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p;

import com.google.protobuf.ByteString;
import haveno.common.app.Version;
import haveno.network.p2p.ExtendedDataSizePermission;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.SendersNodeAddressMessage;
import protobuf.NetworkEnvelope;

public final class FileTransferPart
extends haveno.common.proto.network.NetworkEnvelope
implements ExtendedDataSizePermission,
SendersNodeAddressMessage {
    private final NodeAddress senderNodeAddress;
    public final String uid;
    public final String tradeId;
    public final int traderId;
    public final long seqNumOrFileLength;
    public final ByteString messageData;

    public FileTransferPart(NodeAddress senderNodeAddress, String tradeId, int traderId, String uid, long seqNumOrFileLength, ByteString messageData) {
        this(senderNodeAddress, tradeId, traderId, uid, seqNumOrFileLength, messageData, Version.getP2PMessageVersion());
    }

    public boolean isInitialRequest() {
        return this.messageData.size() == 0;
    }

    private FileTransferPart(NodeAddress senderNodeAddress, String tradeId, int traderId, String uid, long seqNumOrFileLength, ByteString messageData, String messageVersion) {
        super(messageVersion);
        this.senderNodeAddress = senderNodeAddress;
        this.tradeId = tradeId;
        this.traderId = traderId;
        this.uid = uid;
        this.seqNumOrFileLength = seqNumOrFileLength;
        this.messageData = messageData;
    }

    public NetworkEnvelope toProtoNetworkEnvelope() {
        return this.getNetworkEnvelopeBuilder().setFileTransferPart(protobuf.FileTransferPart.newBuilder().setSenderNodeAddress(this.senderNodeAddress.toProtoMessage()).setTradeId(this.tradeId).setTraderId(this.traderId).setUid(this.uid).setSeqNumOrFileLength(this.seqNumOrFileLength).setMessageData(this.messageData).build()).build();
    }

    public static FileTransferPart fromProto(protobuf.FileTransferPart proto, String messageVersion) {
        return new FileTransferPart(NodeAddress.fromProto(proto.getSenderNodeAddress()), proto.getTradeId(), proto.getTraderId(), proto.getUid(), proto.getSeqNumOrFileLength(), proto.getMessageData(), messageVersion);
    }

    public String toString() {
        return "FileTransferPart{\n     senderNodeAddress='" + this.senderNodeAddress.getAddressForDisplay() + "',\n     uid='" + this.uid + "',\n     tradeId='" + this.tradeId + "',\n     traderId='" + this.traderId + "',\n     seqNumOrFileLength=" + this.seqNumOrFileLength + "\n} " + super.toString();
    }

    @Override
    public NodeAddress getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    public String getUid() {
        return this.uid;
    }

    public String getTradeId() {
        return this.tradeId;
    }

    public int getTraderId() {
        return this.traderId;
    }

    public long getSeqNumOrFileLength() {
        return this.seqNumOrFileLength;
    }

    public ByteString getMessageData() {
        return this.messageData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileTransferPart)) {
            return false;
        }
        FileTransferPart other = (FileTransferPart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTraderId() != other.getTraderId()) {
            return false;
        }
        if (this.getSeqNumOrFileLength() != other.getSeqNumOrFileLength()) {
            return false;
        }
        NodeAddress this$senderNodeAddress = this.getSenderNodeAddress();
        NodeAddress other$senderNodeAddress = other.getSenderNodeAddress();
        if (this$senderNodeAddress == null ? other$senderNodeAddress != null : !((Object)this$senderNodeAddress).equals(other$senderNodeAddress)) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
            return false;
        }
        String this$tradeId = this.getTradeId();
        String other$tradeId = other.getTradeId();
        if (this$tradeId == null ? other$tradeId != null : !this$tradeId.equals(other$tradeId)) {
            return false;
        }
        ByteString this$messageData = this.getMessageData();
        ByteString other$messageData = other.getMessageData();
        return !(this$messageData == null ? other$messageData != null : !this$messageData.equals(other$messageData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileTransferPart;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getTraderId();
        long $seqNumOrFileLength = this.getSeqNumOrFileLength();
        result = result * 59 + (int)($seqNumOrFileLength >>> 32 ^ $seqNumOrFileLength);
        NodeAddress $senderNodeAddress = this.getSenderNodeAddress();
        result = result * 59 + ($senderNodeAddress == null ? 43 : ((Object)$senderNodeAddress).hashCode());
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        String $tradeId = this.getTradeId();
        result = result * 59 + ($tradeId == null ? 43 : $tradeId.hashCode());
        ByteString $messageData = this.getMessageData();
        result = result * 59 + ($messageData == null ? 43 : $messageData.hashCode());
        return result;
    }
}

