/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p;

import haveno.common.app.Version;
import haveno.common.proto.ProtoUtil;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.network.p2p.AckMessageSourceType;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.mailbox.MailboxMessage;
import haveno.network.p2p.storage.payload.ExpirablePayload;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.AckMessage;
import protobuf.NetworkEnvelope;

public final class AckMessage
extends haveno.common.proto.network.NetworkEnvelope
implements MailboxMessage,
PersistablePayload,
ExpirablePayload {
    private static final Logger log = LoggerFactory.getLogger(AckMessage.class);
    public static final long TTL = TimeUnit.DAYS.toMillis(7L);
    private final String uid;
    private final NodeAddress senderNodeAddress;
    private final AckMessageSourceType sourceType;
    private final String sourceMsgClassName;
    @Nullable
    private final String sourceUid;
    private final String sourceId;
    private final boolean success;
    @Nullable
    private final String errorMessage;
    @Nullable
    private final String updatedMultisigHex;

    public AckMessage(NodeAddress senderNodeAddress, AckMessageSourceType sourceType, String sourceMsgClassName, String sourceUid, String sourceId, boolean success, String errorMessage) {
        this(UUID.randomUUID().toString(), senderNodeAddress, sourceType, sourceMsgClassName, sourceUid, sourceId, success, errorMessage, null, Version.getP2PMessageVersion());
    }

    public AckMessage(NodeAddress senderNodeAddress, AckMessageSourceType sourceType, String sourceMsgClassName, String sourceUid, String sourceId, boolean success, String errorMessage, String updatedMultisigHex) {
        this(UUID.randomUUID().toString(), senderNodeAddress, sourceType, sourceMsgClassName, sourceUid, sourceId, success, errorMessage, updatedMultisigHex, Version.getP2PMessageVersion());
    }

    private AckMessage(String uid, NodeAddress senderNodeAddress, AckMessageSourceType sourceType, String sourceMsgClassName, @Nullable String sourceUid, String sourceId, boolean success, @Nullable String errorMessage, String updatedMultisigInfo, String messageVersion) {
        super(messageVersion);
        this.uid = uid;
        this.senderNodeAddress = senderNodeAddress;
        this.sourceType = sourceType;
        this.sourceMsgClassName = sourceMsgClassName;
        this.sourceUid = sourceUid;
        this.sourceId = sourceId;
        this.success = success;
        this.errorMessage = errorMessage;
        this.updatedMultisigHex = updatedMultisigInfo;
    }

    public protobuf.AckMessage toProtoMessage() {
        return this.getBuilder().build();
    }

    public NetworkEnvelope toProtoNetworkEnvelope() {
        return this.getNetworkEnvelopeBuilder().setAckMessage(this.getBuilder()).build();
    }

    public AckMessage.Builder getBuilder() {
        AckMessage.Builder builder = protobuf.AckMessage.newBuilder().setUid(this.uid).setSenderNodeAddress(this.senderNodeAddress.toProtoMessage()).setSourceType(this.sourceType.name()).setSourceMsgClassName(this.sourceMsgClassName).setSourceId(this.sourceId).setSuccess(this.success);
        Optional.ofNullable(this.sourceUid).ifPresent(arg_0 -> ((AckMessage.Builder)builder).setSourceUid(arg_0));
        Optional.ofNullable(this.errorMessage).ifPresent(arg_0 -> ((AckMessage.Builder)builder).setErrorMessage(arg_0));
        Optional.ofNullable(this.updatedMultisigHex).ifPresent(arg_0 -> ((AckMessage.Builder)builder).setUpdatedMultisigHex(arg_0));
        return builder;
    }

    public static AckMessage fromProto(protobuf.AckMessage proto, String messageVersion) {
        AckMessageSourceType sourceType = (AckMessageSourceType)ProtoUtil.enumFromProto(AckMessageSourceType.class, (String)proto.getSourceType());
        return new AckMessage(proto.getUid(), NodeAddress.fromProto(proto.getSenderNodeAddress()), sourceType, proto.getSourceMsgClassName(), proto.getSourceUid().isEmpty() ? null : proto.getSourceUid(), proto.getSourceId(), proto.getSuccess(), proto.getErrorMessage().isEmpty() ? null : proto.getErrorMessage(), proto.getUpdatedMultisigHex().isEmpty() ? null : proto.getUpdatedMultisigHex(), messageVersion);
    }

    @Override
    public long getTTL() {
        return TTL;
    }

    public String toString() {
        return "AckMessage{\n     uid='" + this.uid + "',\n     senderNodeAddress=" + String.valueOf(this.senderNodeAddress) + ",\n     sourceType=" + String.valueOf((Object)this.sourceType) + ",\n     sourceMsgClassName='" + this.sourceMsgClassName + "',\n     sourceUid='" + this.sourceUid + "',\n     sourceId='" + this.sourceId + "',\n     success=" + this.success + ",\n     errorMessage='" + this.errorMessage + "',\n     updatedMultisigInfo='" + this.updatedMultisigHex + "'\n} " + super.toString();
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public NodeAddress getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    public AckMessageSourceType getSourceType() {
        return this.sourceType;
    }

    public String getSourceMsgClassName() {
        return this.sourceMsgClassName;
    }

    @Nullable
    public String getSourceUid() {
        return this.sourceUid;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public String getUpdatedMultisigHex() {
        return this.updatedMultisigHex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AckMessage)) {
            return false;
        }
        AckMessage other = (AckMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        NodeAddress this$senderNodeAddress = this.getSenderNodeAddress();
        NodeAddress other$senderNodeAddress = other.getSenderNodeAddress();
        if (this$senderNodeAddress == null ? other$senderNodeAddress != null : !((Object)this$senderNodeAddress).equals(other$senderNodeAddress)) {
            return false;
        }
        AckMessageSourceType this$sourceType = this.getSourceType();
        AckMessageSourceType other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !((Object)((Object)this$sourceType)).equals((Object)other$sourceType)) {
            return false;
        }
        String this$sourceMsgClassName = this.getSourceMsgClassName();
        String other$sourceMsgClassName = other.getSourceMsgClassName();
        if (this$sourceMsgClassName == null ? other$sourceMsgClassName != null : !this$sourceMsgClassName.equals(other$sourceMsgClassName)) {
            return false;
        }
        String this$sourceUid = this.getSourceUid();
        String other$sourceUid = other.getSourceUid();
        if (this$sourceUid == null ? other$sourceUid != null : !this$sourceUid.equals(other$sourceUid)) {
            return false;
        }
        String this$sourceId = this.getSourceId();
        String other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$updatedMultisigHex = this.getUpdatedMultisigHex();
        String other$updatedMultisigHex = other.getUpdatedMultisigHex();
        return !(this$updatedMultisigHex == null ? other$updatedMultisigHex != null : !this$updatedMultisigHex.equals(other$updatedMultisigHex));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AckMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        NodeAddress $senderNodeAddress = this.getSenderNodeAddress();
        result = result * 59 + ($senderNodeAddress == null ? 43 : ((Object)$senderNodeAddress).hashCode());
        AckMessageSourceType $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : ((Object)((Object)$sourceType)).hashCode());
        String $sourceMsgClassName = this.getSourceMsgClassName();
        result = result * 59 + ($sourceMsgClassName == null ? 43 : $sourceMsgClassName.hashCode());
        String $sourceUid = this.getSourceUid();
        result = result * 59 + ($sourceUid == null ? 43 : $sourceUid.hashCode());
        String $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : $sourceId.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $updatedMultisigHex = this.getUpdatedMultisigHex();
        result = result * 59 + ($updatedMultisigHex == null ? 43 : $updatedMultisigHex.hashCode());
        return result;
    }
}

