/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.http;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import haveno.common.ThreadUtils;
import haveno.common.util.Utilities;
import haveno.network.Socks5ProxyProvider;
import haveno.network.http.FakeDnsResolver;
import haveno.network.http.HttpClient;
import haveno.network.http.HttpException;
import haveno.network.http.HttpMethod;
import haveno.network.http.SocksConnectionSocketFactory;
import haveno.network.http.SocksSSLConnectionSocketFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientImpl
implements HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClientImpl.class);
    @Nullable
    private Socks5ProxyProvider socks5ProxyProvider;
    @Nullable
    private HttpURLConnection connection;
    @Nullable
    private CloseableHttpClient closeableHttpClient;
    private static final long SHUTDOWN_TIMEOUT_MS = 5000L;
    private String baseUrl;
    private boolean ignoreSocks5Proxy;
    private final String uid;
    private boolean hasPendingRequest;

    @Inject
    public HttpClientImpl(@Nullable Socks5ProxyProvider socks5ProxyProvider) {
        this.socks5ProxyProvider = socks5ProxyProvider;
        this.uid = UUID.randomUUID().toString();
    }

    public HttpClientImpl(String baseUrl) {
        this.baseUrl = baseUrl;
        this.uid = UUID.randomUUID().toString();
    }

    @Override
    public void shutDown() {
        try {
            ThreadUtils.awaitTask(() -> {
                this.doShutDown(this.connection, this.closeableHttpClient);
                this.connection = null;
                this.closeableHttpClient = null;
            }, (Long)5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doShutDown(HttpURLConnection connection, CloseableHttpClient closeableHttpClient) {
        try {
            if (connection != null) {
                connection.getInputStream().close();
                connection.disconnect();
            }
            if (closeableHttpClient != null) {
                closeableHttpClient.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasPendingRequest() {
        return this.hasPendingRequest;
    }

    @Override
    public String get(String param, @Nullable String headerKey, @Nullable String headerValue) throws IOException {
        return this.doRequest(param, HttpMethod.GET, headerKey, headerValue);
    }

    @Override
    public String post(String param, @Nullable String headerKey, @Nullable String headerValue) throws IOException {
        return this.doRequest(param, HttpMethod.POST, headerKey, headerValue);
    }

    private String doRequest(String param, HttpMethod httpMethod, @Nullable String headerKey, @Nullable String headerValue) throws IOException {
        Preconditions.checkNotNull((Object)this.baseUrl, (Object)"baseUrl must be set before calling doRequest");
        Preconditions.checkArgument((!this.hasPendingRequest ? 1 : 0) != 0, (Object)"We got called on the same HttpClient again while a request is still open.");
        this.hasPendingRequest = true;
        Socks5Proxy socks5Proxy = this.getSocks5Proxy(this.socks5ProxyProvider);
        if (this.ignoreSocks5Proxy || socks5Proxy == null || this.baseUrl.contains("localhost")) {
            return this.requestWithoutProxy(this.baseUrl, param, httpMethod, headerKey, headerValue);
        }
        return this.doRequestWithProxy(this.baseUrl, param, httpMethod, socks5Proxy, headerKey, headerValue);
    }

    @Override
    public void cancelPendingRequest() {
        if (!this.hasPendingRequest) {
            return;
        }
        this.shutDown();
        this.hasPendingRequest = false;
    }

    private String requestWithoutProxy(String baseUrl, String param, HttpMethod httpMethod, @Nullable String headerKey, @Nullable String headerValue) throws IOException {
        long ts = System.currentTimeMillis();
        log.debug("requestWithoutProxy: URL={}, param={}, httpMethod={}", new Object[]{baseUrl, param, httpMethod});
        try {
            int responseCode;
            String spec = httpMethod == HttpMethod.GET ? baseUrl + param : baseUrl;
            URL url = new URL(spec);
            this.connection = (HttpURLConnection)url.openConnection();
            this.connection.setRequestMethod(httpMethod.name());
            this.connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(120L));
            this.connection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(120L));
            this.connection.setRequestProperty("User-Agent", "haveno/1.2.2");
            if (headerKey != null && headerValue != null) {
                this.connection.setRequestProperty(headerKey, headerValue);
            }
            if (httpMethod == HttpMethod.POST) {
                this.connection.setDoOutput(true);
                this.connection.getOutputStream().write(param.getBytes(StandardCharsets.UTF_8));
            }
            if ((responseCode = this.connection.getResponseCode()) == 200) {
                String response = this.convertInputStreamToString(this.connection.getInputStream());
                log.debug("Response from {} with param {} took {} ms. Data size:{}, response: {}", new Object[]{baseUrl, param, System.currentTimeMillis() - ts, Utilities.readableFileSize((long)response.getBytes().length), Utilities.toTruncatedString((Object)response)});
                String string = response;
                return string;
            }
            try {
                InputStream errorStream = this.connection.getErrorStream();
                if (errorStream != null) {
                    String error = this.convertInputStreamToString(errorStream);
                    errorStream.close();
                    log.info("Received errorMsg '{}' with responseCode {} from {}. Response took: {} ms. param: {}", new Object[]{error, responseCode, baseUrl, System.currentTimeMillis() - ts, param});
                    throw new HttpException(error, responseCode);
                }
                log.info("Response with responseCode {} from {}. Response took: {} ms. param: {}", new Object[]{responseCode, baseUrl, System.currentTimeMillis() - ts, param});
                throw new HttpException("Request failed", responseCode);
            }
            catch (Throwable t) {
                String message = "Error at requestWithoutProxy with url " + baseUrl + " and param " + param + ". Throwable=" + t.getMessage();
                throw new IOException(message, t);
            }
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.getInputStream().close();
                    this.connection.disconnect();
                    this.connection = null;
                }
            }
            catch (Throwable throwable) {}
            this.hasPendingRequest = false;
        }
    }

    /*
     * Loose catch block
     */
    private String doRequestWithProxy(String baseUrl, String param, HttpMethod httpMethod, Socks5Proxy socks5Proxy, @Nullable String headerKey, @Nullable String headerValue) throws IOException {
        long ts = System.currentTimeMillis();
        log.debug("doRequestWithProxy: baseUrl={}, param={}, httpMethod={}", new Object[]{baseUrl, param, httpMethod});
        Registry reg = RegistryBuilder.create().register("http", (Object)new SocksConnectionSocketFactory()).register("https", (Object)new SocksSSLConnectionSocketFactory(SSLContexts.createSystemDefault())).build();
        PoolingHttpClientConnectionManager cm = socks5Proxy.resolveAddrLocally() ? new PoolingHttpClientConnectionManager(reg) : new PoolingHttpClientConnectionManager(reg, (DnsResolver)new FakeDnsResolver());
        try {
            int statusCode;
            String response;
            block14: {
                String string;
                block15: {
                    this.closeableHttpClient = (CloseableHttpClient)Preconditions.checkNotNull((Object)HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build());
                    InetSocketAddress socksAddress = new InetSocketAddress(socks5Proxy.getInetAddress(), socks5Proxy.getPort());
                    HttpClientContext context = HttpClientContext.create();
                    context.setAttribute("socks.address", (Object)socksAddress);
                    HttpUriRequest request = this.getHttpUriRequest(httpMethod, baseUrl, param);
                    if (headerKey != null && headerValue != null) {
                        request.setHeader(headerKey, headerValue);
                    }
                    CloseableHttpResponse httpResponse = this.closeableHttpClient.execute(request, (HttpContext)context);
                    response = this.convertInputStreamToString(httpResponse.getEntity().getContent());
                    statusCode = httpResponse.getStatusLine().getStatusCode();
                    if (statusCode != 200) break block14;
                    log.debug("Response from {} took {} ms. Data size:{}, response: {}, param: {}", new Object[]{baseUrl, System.currentTimeMillis() - ts, Utilities.readableFileSize((long)response.getBytes().length), Utilities.toTruncatedString((Object)response), param});
                    string = response;
                    if (httpResponse == null) break block15;
                    {
                        catch (Throwable throwable) {
                            if (httpResponse != null) {
                                try {
                                    httpResponse.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    httpResponse.close();
                }
                return string;
            }
            try {
                log.info("Received errorMsg '{}' with statusCode {} from {}. Response took: {} ms. param: {}", new Object[]{response, statusCode, baseUrl, System.currentTimeMillis() - ts, param});
                throw new HttpException(response, statusCode);
            }
            catch (Throwable t) {
                String message = "Error at doRequestWithProxy with url " + baseUrl + " and param " + param + ". Throwable=" + t.getMessage();
                throw new IOException(message, t);
            }
        }
        finally {
            if (this.closeableHttpClient != null) {
                this.closeableHttpClient.close();
                this.closeableHttpClient = null;
            }
            this.hasPendingRequest = false;
        }
    }

    private HttpUriRequest getHttpUriRequest(HttpMethod httpMethod, String baseUrl, String param) throws UnsupportedEncodingException {
        switch (httpMethod) {
            case GET: {
                return new HttpGet(baseUrl + param);
            }
            case POST: {
                HttpPost httpPost = new HttpPost(baseUrl);
                StringEntity httpEntity = new StringEntity(param);
                httpPost.setEntity((HttpEntity)httpEntity);
                return httpPost;
            }
        }
        throw new IllegalArgumentException("HttpMethod not supported: " + String.valueOf((Object)httpMethod));
    }

    @Nullable
    private Socks5Proxy getSocks5Proxy(Socks5ProxyProvider socks5ProxyProvider) {
        if (socks5ProxyProvider == null) {
            return null;
        }
        Socks5Proxy socks5Proxy = socks5ProxyProvider.getSocks5ProxyHttp();
        if (socks5Proxy != null) {
            return socks5Proxy;
        }
        return socks5ProxyProvider.getSocks5Proxy();
    }

    private String convertInputStreamToString(InputStream inputStream) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(line);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return "HttpClientImpl{\n     socks5ProxyProvider=" + String.valueOf(this.socks5ProxyProvider) + ",\n     baseUrl='" + this.baseUrl + "',\n     ignoreSocks5Proxy=" + this.ignoreSocks5Proxy + ",\n     uid='" + this.uid + "',\n     connection=" + String.valueOf(this.connection) + ",\n     httpclient=" + String.valueOf(this.closeableHttpClient) + "\n}";
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public void setIgnoreSocks5Proxy(boolean ignoreSocks5Proxy) {
        this.ignoreSocks5Proxy = ignoreSocks5Proxy;
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}

