/*
 * Decompiled with CFR 0.152.
 */
package haveno.network;

import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import haveno.common.util.SingleThreadExecutorUtils;
import haveno.common.util.Utilities;
import haveno.network.DnsLookupTor;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.net.discovery.MultiplexingDiscovery;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.bitcoinj.utils.ContextPropagatingThreadFactory;
import org.bitcoinj.utils.DaemonThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Socks5DnsDiscovery
extends MultiplexingDiscovery {
    private static final Logger log = LoggerFactory.getLogger(Socks5DnsDiscovery.class);

    public Socks5DnsDiscovery(Socks5Proxy proxy, NetworkParameters netParams) {
        this(proxy, netParams.getDnsSeeds(), netParams);
    }

    public Socks5DnsDiscovery(Socks5Proxy proxy, String[] dnsSeeds, NetworkParameters params) {
        super(params, Socks5DnsDiscovery.buildDiscoveries(proxy, params, dnsSeeds));
    }

    private static List<PeerDiscovery> buildDiscoveries(Socks5Proxy proxy, NetworkParameters params, String[] seeds) {
        ArrayList<PeerDiscovery> discoveries = new ArrayList<PeerDiscovery>(seeds.length);
        for (String seed : seeds) {
            discoveries.add(new Socks5DnsSeedDiscovery(proxy, params, seed));
        }
        return discoveries;
    }

    protected ExecutorService createExecutor() {
        if (Utilities.isLinux()) {
            return SingleThreadExecutorUtils.getSingleThreadExecutor((ThreadFactory)new ContextPropagatingThreadFactory("DNS seed lookups"));
        }
        return Utilities.getFixedThreadPoolExecutor((int)this.seeds.size(), (ThreadFactory)new DaemonThreadFactory("DNS seed lookups"));
    }

    public static class Socks5DnsSeedDiscovery
    implements PeerDiscovery {
        private final String hostname;
        private final NetworkParameters params;
        private final Socks5Proxy proxy;

        public Socks5DnsSeedDiscovery(Socks5Proxy proxy, NetworkParameters params, String hostname) {
            this.hostname = hostname;
            this.params = params;
            this.proxy = proxy;
        }

        public InetSocketAddress[] getPeers(long services, long timeoutValue, TimeUnit timeoutUnit) throws PeerDiscoveryException {
            if (services != 0L) {
                throw new PeerDiscoveryException("DNS seeds cannot filter by services: " + services);
            }
            try {
                InetSocketAddress addr = new InetSocketAddress(DnsLookupTor.lookup(this.proxy, this.hostname), this.params.getPort());
                return new InetSocketAddress[]{addr};
            }
            catch (Exception e) {
                throw new PeerDiscoveryException((Throwable)e);
            }
        }

        public void shutdown() {
        }

        public String toString() {
            return this.hostname;
        }
    }
}

