/*
 * Decompiled with CFR 0.152.
 */
package haveno.network;

import com.google.common.base.Charsets;
import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import haveno.network.DnsLookupException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsLookupTor {
    private static final Logger log = LoggerFactory.getLogger(DnsLookupTor.class);
    private static final Map<Byte, String> torStatusErrors = DnsLookupTor.createMap();

    private static Map<Byte, String> createMap() {
        HashMap<Byte, String> map = new HashMap<Byte, String>();
        map.put(DnsLookupTor.b('\u0000'), "tor succeeded");
        map.put(DnsLookupTor.b('\u0001'), "tor general error");
        map.put(DnsLookupTor.b('\u0002'), "tor not allowed");
        map.put(DnsLookupTor.b('\u0003'), "tor network is unreachable");
        map.put(DnsLookupTor.b('\u0004'), "tor host is unreachable");
        map.put(DnsLookupTor.b('\u0005'), "tor connection refused");
        map.put(DnsLookupTor.b('\u0006'), "tor TTL expired");
        map.put(DnsLookupTor.b('\u0007'), "tor command not supported");
        map.put(DnsLookupTor.b('\b'), "tor address type not supported");
        return map;
    }

    public static InetAddress lookup(Socks5Proxy proxy, String host) throws DnsLookupException {
        try {
            Socket proxySocket = new Socket(proxy.getInetAddress(), proxy.getPort());
            proxySocket.getOutputStream().write(new byte[]{DnsLookupTor.b('\u0005'), DnsLookupTor.b('\u0001'), DnsLookupTor.b('\u0000')});
            byte[] buf = new byte[2];
            proxySocket.getInputStream().read(buf);
            if (buf[0] != DnsLookupTor.b('\u0005')) {
                throw new DnsLookupException("Invalid Proxy Response");
            }
            if (buf[1] != DnsLookupTor.b('\u0000')) {
                throw new DnsLookupException("Unrecognized Tor Auth Method");
            }
            byte[] hostBytes = host.getBytes(Charsets.UTF_8);
            buf = new byte[7 + hostBytes.length];
            buf[0] = DnsLookupTor.b('\u0005');
            buf[1] = DnsLookupTor.b('\u00f0');
            buf[2] = DnsLookupTor.b('\u0000');
            buf[3] = DnsLookupTor.b('\u0003');
            buf[4] = (byte)hostBytes.length;
            System.arraycopy(hostBytes, 0, buf, 5, hostBytes.length);
            buf[5 + hostBytes.length] = 0;
            proxySocket.getOutputStream().write(buf);
            buf = new byte[4];
            int bytesRead = proxySocket.getInputStream().read(buf);
            if (buf[0] != DnsLookupTor.b('\u0005')) {
                throw new DnsLookupException("Invalid Tor Proxy Response");
            }
            if (buf[1] != DnsLookupTor.b('\u0000')) {
                if (!torStatusErrors.containsKey(buf[1])) {
                    throw new DnsLookupException("Invalid Tor Proxy Response");
                }
                throw new DnsLookupException(torStatusErrors.get(buf[1]) + "(host=" + host + ")");
            }
            boolean SOCKS5_ATYPE_IPV4 = true;
            int SOCKS5_ATYPE_IPV6 = 4;
            byte atype = buf[3];
            if (atype != DnsLookupTor.b('\u0001') && atype != DnsLookupTor.b('\u0004')) {
                throw new DnsLookupException(torStatusErrors.get(DnsLookupTor.b('\u0001')) + "(host=" + host + ")");
            }
            int octets = atype == 1 ? 4 : 16;
            buf = new byte[octets];
            bytesRead = proxySocket.getInputStream().read(buf);
            if (bytesRead != octets) {
                throw new DnsLookupException("Invalid Tor Address Response");
            }
            return InetAddress.getByAddress(buf);
        }
        catch (DnsLookupException | IOException e) {
            log.warn("Error resolving " + host + ". Exception:\n" + e.toString());
            throw new DnsLookupException(e);
        }
    }

    private static byte b(char c) {
        return (byte)c;
    }
}

