/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.svg;

import com.jfoenix.svg.SVGGlyph;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Translate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SVGGlyphLoader {
    private static final HashMap<String, SVGGlyphBuilder> glyphsMap = new HashMap();

    public static SVGGlyph getGlyph(String glyphName) {
        return glyphsMap.get(glyphName).build();
    }

    public static SVGGlyph getIcoMoonGlyph(String glyphName) throws Exception {
        SVGGlyphBuilder builder = glyphsMap.get(glyphName);
        if (builder == null) {
            throw new Exception("Glyph '" + glyphName + "' not found!");
        }
        SVGGlyph glyph = builder.build();
        glyph.getTransforms().add((Object)new Scale(1.0, -1.0));
        Translate height = new Translate();
        height.yProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> -glyph.getHeight(), (Observable[])new Observable[]{glyph.heightProperty()}));
        glyph.getTransforms().add((Object)height);
        return glyph;
    }

    public static Set<String> getAllGlyphsIDs() {
        return glyphsMap.keySet();
    }

    public static void loadGlyphsFont(URL url) throws IOException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            File svgFontFile = new File(url.toURI());
            Document doc = docBuilder.parse(svgFontFile);
            doc.getDocumentElement().normalize();
            NodeList glyphsList = doc.getElementsByTagName("glyph");
            for (int i = 0; i < glyphsList.getLength(); ++i) {
                Node glyph = glyphsList.item(i);
                Node glyphName = glyph.getAttributes().getNamedItem("glyph-name");
                if (glyphName == null) continue;
                String glyphId = glyphName.getNodeValue();
                SVGGlyphBuilder glyphPane = new SVGGlyphBuilder(i, glyphId, glyph.getAttributes().getNamedItem("d").getNodeValue());
                glyphsMap.put(svgFontFile.getName() + "." + glyphId, glyphPane);
            }
        }
        catch (URISyntaxException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    public static void loadGlyphsFont(InputStream stream, String keyPrefix) throws IOException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            Document doc = docBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            NodeList glyphsList = doc.getElementsByTagName("glyph");
            for (int i = 0; i < glyphsList.getLength(); ++i) {
                Node glyph = glyphsList.item(i);
                Node glyphName = glyph.getAttributes().getNamedItem("glyph-name");
                if (glyphName == null) continue;
                String glyphId = glyphName.getNodeValue();
                SVGGlyphBuilder glyphPane = new SVGGlyphBuilder(i, glyphId, glyph.getAttributes().getNamedItem("d").getNodeValue());
                glyphsMap.put(keyPrefix + "." + glyphId, glyphPane);
            }
            stream.close();
        }
        catch (ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    public static SVGGlyph loadGlyph(URL url) throws IOException {
        int endPos;
        String urlString = url.toString();
        String filename = urlString.substring(urlString.lastIndexOf(47) + 1);
        int startPos = 0;
        for (endPos = 0; endPos < filename.length() && filename.charAt(endPos) != '-'; ++endPos) {
        }
        int id = Integer.parseInt(filename.substring(startPos, endPos));
        startPos = endPos + 1;
        while (endPos < filename.length() && filename.charAt(endPos) != '.') {
            ++endPos;
        }
        String name = filename.substring(startPos, endPos);
        return new SVGGlyph(id, name, SVGGlyphLoader.extractSvgPath(SVGGlyphLoader.getStringFromInputStream(url.openStream())), (Paint)Color.BLACK);
    }

    public static void clear() {
        glyphsMap.clear();
    }

    private static String extractSvgPath(String svgString) {
        return svgString.replaceFirst(".*d=\"", "").replaceFirst("\".*", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFromInputStream(InputStream is) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    private static final class SVGGlyphBuilder {
        private int glyphId;
        private String name;
        private String svgPathContent;

        SVGGlyphBuilder(int glyphId, String name, String svgPathContent) {
            this.glyphId = glyphId;
            this.name = name;
            this.svgPathContent = svgPathContent;
        }

        SVGGlyph build() {
            return new SVGGlyph(this.glyphId, this.name, this.svgPathContent, (Paint)Color.BLACK);
        }
    }
}

