/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.base.IFXValidatableControl;
import com.jfoenix.validation.base.ValidatorBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;

class ValidationControl
implements IFXValidatableControl {
    private ReadOnlyObjectWrapper<ValidatorBase> activeValidator = new ReadOnlyObjectWrapper();
    private Control control;
    private ObservableList<ValidatorBase> validators = FXCollections.observableArrayList();

    public ValidationControl(Control control) {
        this.control = control;
    }

    @Override
    public ValidatorBase getActiveValidator() {
        return this.activeValidator == null ? null : (ValidatorBase)this.activeValidator.get();
    }

    @Override
    public ReadOnlyObjectProperty<ValidatorBase> activeValidatorProperty() {
        return this.activeValidator.getReadOnlyProperty();
    }

    ReadOnlyObjectWrapper<ValidatorBase> activeValidatorWritableProperty() {
        return this.activeValidator;
    }

    @Override
    public ObservableList<ValidatorBase> getValidators() {
        return this.validators;
    }

    @Override
    public void setValidators(ValidatorBase ... validators) {
        this.validators.addAll((Object[])validators);
    }

    @Override
    public boolean validate() {
        for (ValidatorBase validator : this.validators) {
            validator.setSrcControl((Node)this.control);
            validator.validate();
            if (!validator.getHasErrors()) continue;
            this.activeValidator.set((Object)validator);
            return false;
        }
        this.activeValidator.set(null);
        return true;
    }

    @Override
    public void resetValidation() {
        this.control.pseudoClassStateChanged(ValidatorBase.PSEUDO_CLASS_ERROR, false);
        this.activeValidator.set(null);
    }
}

