/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import com.jfoenix.utils.JFXUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.util.Callback;

public class RecursiveTreeItem<T extends RecursiveTreeObject<T>>
extends TreeItem<T> {
    private Callback<RecursiveTreeObject<T>, ObservableList<T>> childrenFactory;
    private ObjectProperty<Predicate<TreeItem<T>>> predicate = new SimpleObjectProperty(t -> true);
    private HashMap<T, TreeItem<T>> itemsMap;
    ObservableList<TreeItem<T>> originalItems;
    FilteredList<TreeItem<T>> filteredItems;

    public RecursiveTreeItem(Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        this(null, null, func);
    }

    public RecursiveTreeItem(T value, Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        this(value, null, func);
    }

    public RecursiveTreeItem(T value, Node graphic, Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        super(value, graphic);
        this.childrenFactory = func;
        this.init((RecursiveTreeObject<T>)value);
    }

    public RecursiveTreeItem(ObservableList<T> dataList, Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        RecursiveTreeObject<T> root = new RecursiveTreeObject<T>();
        root.setChildren(dataList);
        this.childrenFactory = func;
        this.init(root);
    }

    private void init(RecursiveTreeObject<T> value) {
        this.addChildrenListener(value);
        this.valueProperty().addListener(observable -> {
            if (this.getValue() != null) {
                this.addChildrenListener((RecursiveTreeObject)this.getValue());
            }
        });
        this.predicate.addListener(observable -> this.filteredItems.setPredicate(child -> {
            if (child instanceof RecursiveTreeItem && !((RecursiveTreeItem)child).originalItems.isEmpty()) {
                RecursiveTreeItem filterableChild = (RecursiveTreeItem)((Object)((Object)child));
                filterableChild.setPredicate((Predicate)this.predicate.get());
            }
            if (this.predicate.get() == null) {
                return true;
            }
            if (child.getChildren().size() > 0) {
                return true;
            }
            if (child.getValue() instanceof RecursiveTreeObject && ((RecursiveTreeObject)child.getValue()).getClass() == RecursiveTreeObject.class) {
                return child.getChildren().size() != 0;
            }
            return ((Predicate)this.predicate.get()).test(child);
        }));
        this.filteredItems.predicateProperty().addListener(observable -> JFXUtilities.runInFXAndWait(() -> {
            this.getChildren().clear();
            this.getChildren().setAll(this.filteredItems);
        }));
    }

    private void addChildrenListener(RecursiveTreeObject<T> value) {
        ObservableList children = (ObservableList)this.childrenFactory.call(value);
        this.originalItems = FXCollections.observableArrayList();
        this.itemsMap = new HashMap();
        for (RecursiveTreeObject child : children) {
            RecursiveTreeItem<RecursiveTreeObject> treeItem = new RecursiveTreeItem<RecursiveTreeObject>(child, this.getGraphic(), this.childrenFactory);
            this.originalItems.add(treeItem);
            this.itemsMap.put(child, treeItem);
        }
        this.filteredItems = new FilteredList(this.originalItems, t -> true);
        this.getChildren().addAll(this.originalItems);
        children.addListener(change -> {
            while (change.next()) {
                if (change.wasRemoved()) {
                    ArrayList<TreeItem<T>> removedItems = new ArrayList<TreeItem<T>>();
                    for (RecursiveTreeObject t : change.getRemoved()) {
                        TreeItem<T> treeItem = this.itemsMap.remove(t);
                        if (treeItem == null) continue;
                        removedItems.add(treeItem);
                    }
                    if (this.originalItems.size() == removedItems.size()) {
                        this.originalItems.clear();
                        this.getChildren().clear();
                    } else {
                        this.getChildren().removeAll(removedItems);
                        this.originalItems.removeAll(removedItems);
                    }
                }
                if (!change.wasAdded()) continue;
                ArrayList<RecursiveTreeItem<RecursiveTreeObject>> addedItems = new ArrayList<RecursiveTreeItem<RecursiveTreeObject>>();
                for (RecursiveTreeObject newChild : change.getAddedSubList()) {
                    RecursiveTreeItem<RecursiveTreeObject> newTreeItem = new RecursiveTreeItem<RecursiveTreeObject>(newChild, this.getGraphic(), this.childrenFactory);
                    addedItems.add(newTreeItem);
                    this.itemsMap.put(newChild, newTreeItem);
                }
                this.getChildren().addAll(addedItems);
                this.originalItems.addAll(addedItems);
            }
        });
    }

    public final ObjectProperty<Predicate<TreeItem<T>>> predicateProperty() {
        return this.predicate;
    }

    public final Predicate<TreeItem<T>> getPredicate() {
        return (Predicate)this.predicateProperty().get();
    }

    public final void setPredicate(Predicate<TreeItem<T>> predicate) {
        this.predicateProperty().set(predicate);
    }

    public TreeItem<T> getTreeItem(T value) {
        return this.itemsMap.get(value);
    }
}

