/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.skins.JFXPopupSkin;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.stage.Window;

@DefaultProperty(value="popupContent")
public class JFXPopup
extends PopupControl {
    private ObjectProperty<Region> popupContent = new SimpleObjectProperty((Object)new Pane());
    private static final String DEFAULT_STYLE_CLASS = "jfx-popup";

    public JFXPopup() {
        this(null);
    }

    public JFXPopup(Region content) {
        this.setPopupContent(content);
        this.initialize();
    }

    private void initialize() {
        this.setAutoFix(false);
        this.setAutoHide(true);
        this.setHideOnEscape(true);
        this.setConsumeAutoHidingEvents(false);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.getScene().getRoot().setStyle("-fx-background-color: TRANSPARENT");
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXPopupSkin(this);
    }

    public final ObjectProperty<Region> popupContentProperty() {
        return this.popupContent;
    }

    public final Region getPopupContent() {
        return (Region)this.popupContentProperty().get();
    }

    public final void setPopupContent(Region popupContent) {
        this.popupContentProperty().set((Object)popupContent);
    }

    public void show(Node node) {
        this.show(node, PopupVPosition.TOP, PopupHPosition.LEFT, 0.0, 0.0);
    }

    public void show(Node node, PopupVPosition vAlign, PopupHPosition hAlign) {
        this.show(node, vAlign, hAlign, 0.0, 0.0);
    }

    public void show(Node node, PopupVPosition vAlign, PopupHPosition hAlign, double initOffsetX, double initOffsetY) {
        if (!this.isShowing()) {
            if (node.getScene() == null || node.getScene().getWindow() == null) {
                throw new IllegalStateException("Can not show popup. The node must be attached to a scene/window.");
            }
            Window parent = node.getScene().getWindow();
            Point2D origin = node.localToScene(0.0, 0.0);
            double anchorX = parent.getX() + origin.getX() + node.getScene().getX() + (hAlign == PopupHPosition.RIGHT ? ((Region)node).getWidth() : 0.0);
            double anchorY = parent.getY() + origin.getY() + node.getScene().getY() + (vAlign == PopupVPosition.BOTTOM ? ((Region)node).getHeight() : 0.0);
            this.show(parent, anchorX, anchorY);
            ((JFXPopupSkin)this.getSkin()).reset(vAlign, hAlign, initOffsetX, initOffsetY);
            Platform.runLater(() -> ((JFXPopupSkin)this.getSkin()).animate());
        }
    }

    public void show(Window window, double x, double y, PopupVPosition vAlign, PopupHPosition hAlign, double initOffsetX, double initOffsetY) {
        if (!this.isShowing()) {
            if (window == null) {
                throw new IllegalStateException("Can not show popup. The node must be attached to a scene/window.");
            }
            Window parent = window;
            double anchorX = parent.getX() + x + initOffsetX;
            double anchorY = parent.getY() + y + initOffsetY;
            this.show(parent, anchorX, anchorY);
            ((JFXPopupSkin)this.getSkin()).reset(vAlign, hAlign, initOffsetX, initOffsetY);
            Platform.runLater(() -> ((JFXPopupSkin)this.getSkin()).animate());
        }
    }

    public void hide() {
        super.hide();
        ((JFXPopupSkin)this.getSkin()).init();
    }

    public static enum PopupVPosition {
        TOP,
        BOTTOM;

    }

    public static enum PopupHPosition {
        RIGHT,
        LEFT;

    }
}

