/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class JFXDialogLayout
extends VBox {
    private StackPane heading = new StackPane();
    private StackPane body = new StackPane();
    private FlowPane actions = new FlowPane();
    private static final String DEFAULT_STYLE_CLASS = "jfx-dialog-layout";

    public JFXDialogLayout() {
        this.initialize();
        this.heading.getStyleClass().addAll((Object[])new String[]{"jfx-layout-heading", "title"});
        this.body.getStyleClass().add((Object)"jfx-layout-body");
        VBox.setVgrow((Node)this.body, (Priority)Priority.ALWAYS);
        this.actions.getStyleClass().add((Object)"jfx-layout-actions");
        this.getChildren().setAll((Object[])new Node[]{this.heading, this.body, this.actions});
    }

    public ObservableList<Node> getHeading() {
        return this.heading.getChildren();
    }

    public void setHeading(Node ... titleContent) {
        this.heading.getChildren().setAll((Object[])titleContent);
    }

    public ObservableList<Node> getBody() {
        return this.body.getChildren();
    }

    public void setBody(Node ... body) {
        this.body.getChildren().setAll((Object[])body);
    }

    public ObservableList<Node> getActions() {
        return this.actions.getChildren();
    }

    public void setActions(Node ... actions) {
        this.actions.getChildren().setAll((Object[])actions);
    }

    public void setActions(List<? extends Node> actions) {
        this.actions.getChildren().setAll(actions);
    }

    public String getUserAgentStylesheet() {
        return JFoenixResources.load("css/controls/jfx-dialog-layout.css").toExternalForm();
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }
}

