/*
 * Decompiled with CFR 0.152.
 */
package haveno.seednode;

import com.google.inject.Key;
import com.google.inject.name.Names;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.app.AppModule;
import haveno.common.app.Capabilities;
import haveno.common.app.Capability;
import haveno.common.config.BaseCurrencyNetwork;
import haveno.common.config.Config;
import haveno.common.handlers.ResultHandler;
import haveno.common.setup.GracefulShutDownHandler;
import haveno.core.app.TorSetup;
import haveno.core.app.misc.ExecutableForAppWithP2p;
import haveno.core.app.misc.ModuleForAppWithP2p;
import haveno.core.user.Cookie;
import haveno.core.user.CookieKey;
import haveno.core.user.User;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.P2PServiceListener;
import haveno.network.p2p.peers.PeerManager;
import haveno.seednode.SeedNode;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeedNodeMain
extends ExecutableForAppWithP2p {
    private static final Logger log = LoggerFactory.getLogger(SeedNodeMain.class);
    private static final long CHECK_CONNECTION_LOSS_SEC = 30L;
    private static final String VERSION = "1.2.0";
    private SeedNode seedNode;
    private Timer checkConnectionLossTime;

    public SeedNodeMain() {
        super("Haveno Seednode", "haveno-seednode", "haveno_seednode", VERSION);
    }

    public static void main(String[] args) {
        System.out.println("SeedNode.VERSION: 1.2.0");
        new SeedNodeMain().execute(args);
    }

    protected int doExecute() {
        super.doExecute();
        this.checkMemory(this.config, (GracefulShutDownHandler)this);
        return this.keepRunning();
    }

    protected void addCapabilities() {
        Capabilities.app.addAll(new Capability[]{Capability.SEED_NODE});
    }

    protected void launchApplication() {
        UserThread.execute(() -> {
            try {
                this.seedNode = new SeedNode();
                UserThread.execute(this::onApplicationLaunched);
            }
            catch (Exception e) {
                log.error("Error launching seed node: {}\n", (Object)e.toString(), (Object)e);
            }
        });
    }

    protected void onApplicationLaunched() {
        super.onApplicationLaunched();
    }

    protected AppModule getModule() {
        return new ModuleForAppWithP2p(this.config);
    }

    protected void applyInjector() {
        super.applyInjector();
        this.seedNode.setInjector(this.injector);
    }

    protected void startApplication() {
        Cookie cookie = ((User)this.injector.getInstance(User.class)).getCookie();
        cookie.getAsOptionalBoolean(CookieKey.CLEAN_TOR_DIR_AT_RESTART).ifPresent(wasCleanTorDirSet -> {
            if (wasCleanTorDirSet.booleanValue()) {
                ((TorSetup)this.injector.getInstance(TorSetup.class)).cleanupTorFiles(() -> {
                    log.info("Tor directory reset");
                    cookie.remove((Object)CookieKey.CLEAN_TOR_DIR_AT_RESTART);
                }, arg_0 -> ((Logger)log).error(arg_0));
            }
        });
        this.seedNode.startApplication();
        ((P2PService)this.injector.getInstance(P2PService.class)).addP2PServiceListener(new P2PServiceListener(){

            public void onDataReceived() {
            }

            public void onNoSeedNodeAvailable() {
            }

            public void onNoPeersAvailable() {
            }

            public void onUpdatedDataReceived() {
            }

            public void onTorNodeReady() {
            }

            public void onHiddenServicePublished() {
                boolean preventPeriodicShutdownAtSeedNode = (Boolean)SeedNodeMain.this.injector.getInstance(Key.get(Boolean.TYPE, (Annotation)Names.named((String)"preventPeriodicShutdownAtSeedNode")));
                if (!preventPeriodicShutdownAtSeedNode) {
                    SeedNodeMain.this.startShutDownInterval((GracefulShutDownHandler)SeedNodeMain.this);
                }
                UserThread.runAfter(() -> SeedNodeMain.this.setupConnectionLossCheck(), (long)60L);
            }

            public void onSetupFailed(Throwable throwable) {
            }

            public void onRequestCustomBridges() {
            }
        });
    }

    private void setupConnectionLossCheck() {
        if (Config.baseCurrencyNetwork() != BaseCurrencyNetwork.XMR_MAINNET) {
            return;
        }
        if (this.checkConnectionLossTime != null) {
            return;
        }
        this.checkConnectionLossTime = UserThread.runPeriodically(() -> {
            if (((PeerManager)this.injector.getInstance(PeerManager.class)).getNumAllConnectionsLostEvents() > 1) {
                ((User)this.injector.getInstance(User.class)).getCookie().putAsBoolean(CookieKey.CLEAN_TOR_DIR_AT_RESTART, true);
                this.shutDown((GracefulShutDownHandler)this);
            }
        }, (long)30L);
    }

    public void gracefulShutDown(ResultHandler resultHandler) {
        this.seedNode.shutDown();
        super.gracefulShutDown(resultHandler);
    }
}

