/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet.model;

import common.utils.GenUtils;
import java.math.BigInteger;

public class MoneroDestination {
    private String address;
    private BigInteger amount;

    public MoneroDestination() {
    }

    public MoneroDestination(String address) {
        this.address = address;
    }

    public MoneroDestination(String address, BigInteger amount) {
        this.address = address;
        this.amount = amount;
    }

    public MoneroDestination(MoneroDestination destination) {
        this.address = destination.address;
        this.amount = destination.amount;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public MoneroDestination copy() {
        return new MoneroDestination(this);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(GenUtils.kvLine("Address", this.getAddress(), indent));
        sb.append(GenUtils.kvLine("Amount", this.getAmount() != null ? this.getAmount().toString() : null, indent));
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.amount == null ? 0 : this.amount.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroDestination other = (MoneroDestination)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        return !(this.amount == null ? other.amount != null : !this.amount.equals(other.amount));
    }
}

